/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.phasing;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.deployment.backend.DeploymentEvent;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.phasing.ApplicationReferenceHelper;
import com.sun.enterprise.deployment.phasing.DeploymentContext;
import com.sun.enterprise.deployment.phasing.DeploymentPhase;
import com.sun.enterprise.deployment.phasing.DeploymentPhaseContext;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.deployment.phasing.DeploymentTarget;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Level;
import java.util.logging.Logger;

class DisassociationPhase
extends DeploymentPhase {
    public static final Logger sLogger = DeploymentLogger.get();
    private static StringManager localStrings = StringManager.getManager(DisassociationPhase.class);

    public DisassociationPhase(DeploymentContext deploymentCtx) {
        this.deploymentCtx = deploymentCtx;
        this.name = "Disassociate";
    }

    public void runPhase(DeploymentPhaseContext phaseCtx) {
        DeploymentStatus status2 = phaseCtx.getDeploymentStatus();
        try {
            DeploymentRequest req = phaseCtx.getDeploymentRequest();
            DeploymentTarget target = (DeploymentTarget)req.getTarget();
            ApplicationRef ref = ApplicationReferenceHelper.findCurrentAppRef(this.deploymentCtx, target.getName(), req.getName());
            boolean needToRemoveRef = true;
            DeploymentContext.SavedApplicationRefInfo info = null;
            if (req.isRedeployInProgress()) {
                info = this.deploymentCtx.saveAppRef(req.getName(), target.getName(), ref, req);
                needToRemoveRef = info.isChanging();
            }
            sLogger.fine("DisassociationPhase for " + req.getName() + " on " + target.getName() + "; isRedeployInProgress = " + req.isRedeployInProgress() + ", savedAppRefInfo is " + (info != null ? info.toString() : "<null>") + "need to remove = " + needToRemoveRef);
            if (needToRemoveRef) {
                sLogger.fine("DisassociationPhase removing app ref for " + req.getName() + " on " + target.getName());
                target.removeAppReference(req.getName());
                this.sendDisassociateEvent(req);
            }
            status2.setStageStatus(2);
        }
        catch (Throwable t) {
            status2.setStageStatus(0);
            status2.setStageException(t);
            status2.setStageStatusMessage(t.getMessage());
        }
    }

    private DeploymentEvent getPrePhaseEvent(DeploymentRequest req) {
        return new DeploymentEvent(9, new DeploymentEventInfo(req));
    }

    private DeploymentEvent getPostPhaseEvent(DeploymentRequest req) {
        return new DeploymentEvent(10, new DeploymentEventInfo(req));
    }

    private void sendDisassociateEvent(DeploymentRequest req) throws Exception {
        DeploymentTarget target = (DeploymentTarget)req.getTarget();
        String moduleType = req.isApplication() ? null : DeploymentServiceUtils.getModuleTypeString(req.getType());
        int eventType = 12;
        String appName = req.getName();
        String targetName = target.getTarget().getName();
        boolean success = DeploymentServiceUtils.multicastEvent(eventType, appName, moduleType, false, true, targetName);
        sLogger.log(Level.FINE, "sendDisassociateEvent: success=" + success);
    }
}

