/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.phasing;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.server.core.AdminNotificationHelper;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.deployment.backend.DeploymentEvent;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.phasing.DeploymentContext;
import com.sun.enterprise.deployment.phasing.DeploymentPhase;
import com.sun.enterprise.deployment.phasing.DeploymentPhaseContext;
import com.sun.enterprise.deployment.phasing.DeploymentPhaseException;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.deployment.phasing.DeploymentTarget;
import com.sun.enterprise.deployment.phasing.DeploymentTargetException;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ResourceAdapterStopPhase
extends DeploymentPhase {
    public static final Logger sLogger = DeploymentLogger.get();
    private static StringManager localStrings = StringManager.getManager(ResourceAdapterStopPhase.class);
    private static final String LIST_ADMIN_OBJECTS = "getAdminObjectResource";
    private static final String DELETE_ADMIN_OBJECT = "deleteAdminObjectResource";
    private static final String LIST_CONNECTOR_CONNECTION_POOLS = "getConnectorConnectionPool";
    private static final String DELETE_CONNECTOR_CONNECTION_POOL = "deleteConnectorConnectionPool";
    private static final String LIST_RESOURCE_ADAPTER_CONFIGS = "getResourceAdapterConfig";
    private static final String DELETE_RESOURCE_ADAPTER_CONFIG = "deleteResourceAdapterConfig";

    public ResourceAdapterStopPhase(DeploymentContext deploymentCtx) {
        this.deploymentCtx = deploymentCtx;
        this.name = "raStop";
    }

    public void runPhase(DeploymentPhaseContext phaseCtx) {
        boolean success;
        String type = null;
        DeploymentRequest req = phaseCtx.getDeploymentRequest();
        DeploymentTarget target = (DeploymentTarget)req.getTarget();
        DeploymentStatus status2 = phaseCtx.getDeploymentStatus();
        if (!DeploymentServiceUtils.containsResourceAdapter(req)) {
            status2.setStageStatus(2);
            return;
        }
        if (!req.isApplication()) {
            type = DeploymentServiceUtils.getModuleTypeString(req.getType());
        }
        try {
            if (req.getCascade() && !req.isForced()) {
                this.deleteConnectorDependentResources(req.getName(), target.getName());
                this.deploymentCtx.getConfigContext().flush();
                AdminContext adminContext = AdminService.getAdminService().getAdminContext();
                new AdminNotificationHelper(adminContext).sendNotification();
            }
        }
        catch (Throwable t) {
            status2.setStageStatus(1);
            status2.setStageException(t);
            status2.setStageStatusMessage(t.getMessage());
            return;
        }
        this.prePhaseNotify(this.getPrePhaseEvent(req));
        try {
            success = target.sendStopEvent(req.getActionCode(), req.getName(), type, req.getCascade(), req.isForced(), 5);
        }
        catch (DeploymentTargetException dte) {
            status2.setStageStatus(1);
            if (dte.getCause() != null) {
                status2.setStageException(dte.getCause());
                status2.setStageStatusMessage(dte.getMessage());
            }
            return;
        }
        if (success) {
            status2.setStageStatus(2);
        } else {
            status2.setStageStatus(1);
            status2.setStageStatusMessage("Application failed to stop");
        }
        this.postPhaseNotify(this.getPostPhaseEvent(req));
    }

    protected DeploymentEvent getPrePhaseEvent(DeploymentRequest req) {
        return new DeploymentEvent(13, new DeploymentEventInfo(req));
    }

    protected DeploymentEvent getPostPhaseEvent(DeploymentRequest req) {
        return new DeploymentEvent(14, new DeploymentEventInfo(req));
    }

    private void deleteConnectorDependentResources(String id, String targetName) throws Exception {
        try {
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            ObjectName mbeanName = new ObjectName("com.sun.appserv:type=resources,category=config");
            Object[] params = new Object[]{};
            String[] signature = new String[]{};
            ObjectName[] adminObjs = (ObjectName[])mbs.invoke(mbeanName, LIST_ADMIN_OBJECTS, params, signature);
            String[] adminObjSignature = new String[]{"java.lang.String", "java.lang.String"};
            for (int i = 0; i < adminObjs.length; ++i) {
                String raName = (String)mbs.getAttribute(adminObjs[i], "res_adapter");
                if (!id.equals(raName)) continue;
                String adminObjName = (String)mbs.getAttribute(adminObjs[i], "jndi_name");
                Object[] deleteAdminParams = new Object[]{adminObjName, targetName};
                mbs.invoke(mbeanName, DELETE_ADMIN_OBJECT, deleteAdminParams, adminObjSignature);
            }
            ObjectName[] poolNames = (ObjectName[])mbs.invoke(mbeanName, LIST_CONNECTOR_CONNECTION_POOLS, params, signature);
            String[] deletePoolSignature = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.String"};
            for (int i = 0; i < poolNames.length; ++i) {
                String raName = (String)mbs.getAttribute(poolNames[i], "resource_adapter_name");
                if (!id.equals(raName)) continue;
                String poolName = (String)mbs.getAttribute(poolNames[i], "name");
                Object[] deletePoolParams = new Object[]{poolName, Boolean.TRUE, targetName};
                mbs.invoke(mbeanName, DELETE_CONNECTOR_CONNECTION_POOL, deletePoolParams, deletePoolSignature);
            }
            ObjectName[] resAdapterConfigs = (ObjectName[])mbs.invoke(mbeanName, LIST_RESOURCE_ADAPTER_CONFIGS, params, signature);
            String[] adapterConfigSignature = new String[]{"java.lang.String", "java.lang.String"};
            Object[] adapterConfigParams = new Object[]{id, targetName};
            for (int i = 0; i < resAdapterConfigs.length; ++i) {
                String raName = (String)mbs.getAttribute(resAdapterConfigs[i], "resource_adapter_name");
                if (!id.equals(raName)) continue;
                mbs.invoke(mbeanName, DELETE_RESOURCE_ADAPTER_CONFIG, adapterConfigParams, adapterConfigSignature);
            }
        }
        catch (Exception e) {
            throw new DeploymentPhaseException(this.getName(), "Exception occured while deleting dependent connector resources", e);
        }
    }
}

