/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics;

import com.sun.enterprise.diagnostics.Defaults;
import com.sun.enterprise.diagnostics.TargetType;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportTarget {
    protected String targetDir;
    protected String targetName;
    protected String repositoryName;
    protected String repositoryDir;
    protected TargetType type;
    protected List<String> instances;
    private boolean local;
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.admin");

    public ReportTarget(String repositoryDir, String repositoryName, String targetName, TargetType type, List<String> instances, boolean local) {
        this.repositoryDir = repositoryDir;
        this.repositoryName = repositoryName;
        this.targetDir = repositoryDir + File.separator + repositoryName;
        this.targetName = targetName;
        this.type = type;
        this.instances = instances;
        this.local = local;
    }

    public TargetType getType() {
        return this.type;
    }

    public String getName() {
        return this.targetName;
    }

    public String getRepositoryDir() {
        return this.repositoryDir;
    }

    public String getTargetDir() {
        return this.targetDir;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getIntermediateReportDir() {
        return this.getArchiveDir() + File.separator + this.targetName;
    }

    public String getArchiveDir() {
        return this.repositoryDir + File.separator + this.repositoryName + Defaults.TEMP_REPORT_FOLDER;
    }

    public String getDefaultReportDir() {
        return this.targetDir + Defaults.REPORT_FOLDER;
    }

    public List<String> getInstances() {
        return this.instances;
    }

    public String toString() {
        return this.getName() + "," + this.getType() + "," + this.getRepositoryDir() + "," + this.getIntermediateReportDir() + "," + this.getDefaultReportDir() + "," + this.getInstances();
    }
}

