/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.collect;

import com.sun.enterprise.diagnostics.Data;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.collect.Collector;
import com.sun.enterprise.diagnostics.collect.FileData;
import com.sun.enterprise.diagnostics.collect.WritableDataImpl;
import com.sun.enterprise.diagnostics.util.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesCollector
implements Collector {
    private String repositoryDir;
    private String reportDir;
    private List<String> files;
    private String dataType;
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.admin");

    public FilesCollector(String repositoryDir, String reportDir, List<String> files, String dataType) {
        this.repositoryDir = repositoryDir;
        this.reportDir = reportDir;
        this.files = files;
        this.dataType = dataType;
    }

    @Override
    public Data capture() throws DiagnosticException {
        WritableDataImpl writableData = null;
        if (this.files != null && this.repositoryDir != null && this.reportDir != null) {
            writableData = new WritableDataImpl(this.dataType);
            for (String fileName : this.files) {
                String srcFile = this.repositoryDir + File.separator + fileName;
                if (!new File(srcFile).exists()) continue;
                String destFile = this.reportDir + File.separator + fileName;
                try {
                    FileUtils.copyFile(srcFile, destFile);
                    writableData.addChild(new FileData(fileName, this.dataType));
                }
                catch (IOException io) {
                    this.log(Level.WARNING, "Error occurred during copy of file" + srcFile);
                }
            }
        }
        return writableData;
    }

    private void log(Level level, String message) {
        logger.log(level, message);
    }
}

