/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop;

import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.ObjectKey;
import com.sun.corba.ee.spi.ior.TaggedProfile;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.presentation.rmi.StubAdapter;
import com.sun.ejb.base.sfsb.util.SimpleKeyGenerator;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Object;

public class EJBTargetKeyInfo {
    protected static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    public static final int EJBID_OFFSET = 0;
    public static final int INSTANCEKEYLEN_OFFSET = 8;
    public static final int INSTANCEKEY_OFFSET = 12;
    public static final byte HOME_KEY = -1;
    private byte[] oid;
    private long containerId;
    private int keyLength;
    private boolean local;
    private java.lang.Object instanceKey;
    private boolean validOid = false;
    private SimpleKeyGenerator gen = new SimpleKeyGenerator();

    public EJBTargetKeyInfo(byte[] oid, boolean local) {
        this.oid = oid;
        this.local = local;
        this.instanceKey = this.gen.byteArrayToKey(oid, 12, 20);
        this.validate();
    }

    public EJBTargetKeyInfo(Object effective_target) {
        try {
            if (StubAdapter.isStub(effective_target)) {
                IOR ior;
                Iterator iter;
                if (StubAdapter.isLocal(effective_target)) {
                    this.local = true;
                }
                if ((iter = (ior = ((ORB)((java.lang.Object)ORBManager.getORB())).getIOR(effective_target, false)).iterator()).hasNext()) {
                    TaggedProfile profile = (TaggedProfile)iter.next();
                    ObjectKey objKey = profile.getObjectKey();
                    this.oid = objKey.getId().getId();
                    SimpleKeyGenerator gen = new SimpleKeyGenerator();
                    this.instanceKey = gen.byteArrayToKey(this.oid, 12, 20);
                    this.validate();
                }
            }
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "EJBTargetKeyInfo: Exception during extraction of instance key", ex);
        }
    }

    public byte[] getOid() {
        return this.oid;
    }

    public java.lang.Object getInstanceKey() {
        return this.instanceKey;
    }

    private void validate() {
        if (this.oid != null && this.oid.length > 12) {
            this.containerId = Utility.bytesToLong(this.oid, 0);
            this.keyLength = Utility.bytesToInt(this.oid, 8);
            if (this.oid.length == this.keyLength + 12) {
                this.validOid = true;
            } else if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "[Invalid.1] oid.length: " + this.oid.length + "; keyLength: " + this.keyLength);
            }
        } else if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "[Invalid.2] oid: " + this.oid + "; " + "oid.length: " + (this.oid == null ? -1 : this.oid.length));
        }
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean isValid() {
        return this.validOid;
    }

    public long getContainerId() {
        return this.containerId;
    }

    public boolean isHomeOid() {
        return this.isValid() && this.keyLength == 1 && this.oid[12] == -1;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public static int getInstanceKeyOffset() {
        return 12;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder(this.validOid ? "valid" : "invalid");
        bldr.append(" {").append(this.containerId).append(" : ").append(this.isHomeOid() ? "HOME" : "EJBO").append(" ==> ").append(this.instanceKey).append("}");
        return bldr.toString();
    }
}

