/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop;

import com.sun.corba.ee.spi.monitoring.MonitoredObject;
import com.sun.enterprise.admin.monitor.stats.BoundedRangeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableBoundedRangeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.ThreadPoolStats;
import com.sun.enterprise.iiop.ORBCommonStatsImpl;
import javax.management.j2ee.statistics.BoundedRangeStatistic;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.RangeStatistic;

public class ThreadPoolStatsImpl
extends ORBCommonStatsImpl
implements ThreadPoolStats {
    private MonitoredObject threadPool;
    private MonitoredObject workQueue;
    private String threadPoolName;
    private MutableCountStatisticImpl numberOfBusyThreads;
    private MutableCountStatisticImpl numberOfAvailableThreads;
    private MutableBoundedRangeStatisticImpl currentNumberOfThreads;
    private MutableBoundedRangeStatisticImpl averageWorkCompletionTime;
    private MutableCountStatisticImpl totalWorkItemsAdded;
    private MutableBoundedRangeStatisticImpl numberOfWorkItemsInQueue;
    private MutableBoundedRangeStatisticImpl averageTimeInQueue;
    private static final String stringNumberOfBusyThreads = "numberOfBusyThreads";
    private static final String stringNumberOfAvailableThreads = "numberOfAvailableThreads";
    private static final String stringCurrentNumberOfThreads = "currentNumberOfThreads";
    private static final String stringAverageWorkCompletionTime = "averageWorkCompletionTime";
    private static final String stringTotalWorkItemsAdded = "totalWorkItemsAdded";
    private static final String stringNumberOfWorkItemsInQueue = "workItemsInQueue";
    private static final String stringAverageTimeInQueue = "averageTimeInQueue";

    public ThreadPoolStatsImpl(MonitoredObject threadPool) {
        this.threadPool = threadPool;
        this.threadPoolName = threadPool.getName();
        this.getWorkQueueForThreadPool();
        this.initializeStats();
    }

    private void getWorkQueueForThreadPool() {
        Object[] workQueues = this.threadPool.getChildren().toArray();
        this.workQueue = (MonitoredObject)workQueues[0];
    }

    private void initializeStats() {
        super.initialize("com.sun.enterprise.admin.monitor.stats.ThreadPoolStats");
        long time = System.currentTimeMillis();
        this.numberOfBusyThreads = new MutableCountStatisticImpl(new CountStatisticImpl(0L, stringNumberOfBusyThreads, "COUNT", this.threadPool.getAttribute(stringNumberOfBusyThreads).getAttributeInfo().getDescription(), time, time));
        this.numberOfAvailableThreads = new MutableCountStatisticImpl(new CountStatisticImpl(0L, stringNumberOfAvailableThreads, "count", this.threadPool.getAttribute(stringNumberOfAvailableThreads).getAttributeInfo().getDescription(), time, time));
        this.currentNumberOfThreads = new MutableBoundedRangeStatisticImpl(new BoundedRangeStatisticImpl(0L, 0L, 0L, Long.MAX_VALUE, 0L, stringCurrentNumberOfThreads, "count", this.threadPool.getAttribute(stringCurrentNumberOfThreads).getAttributeInfo().getDescription(), time, time));
        this.averageWorkCompletionTime = new MutableBoundedRangeStatisticImpl(new BoundedRangeStatisticImpl(0L, 0L, 0L, Long.MAX_VALUE, 0L, stringAverageWorkCompletionTime, "Milliseconds", this.threadPool.getAttribute(stringAverageWorkCompletionTime).getAttributeInfo().getDescription(), time, time));
        MonitoredObject workQueue = this.threadPool.getChild("default-workqueue");
        this.totalWorkItemsAdded = new MutableCountStatisticImpl(new CountStatisticImpl(0L, stringTotalWorkItemsAdded, "count", workQueue.getAttribute(stringTotalWorkItemsAdded).getAttributeInfo().getDescription(), time, time));
        this.numberOfWorkItemsInQueue = new MutableBoundedRangeStatisticImpl(new BoundedRangeStatisticImpl(0L, 0L, 0L, Long.MAX_VALUE, 0L, stringNumberOfWorkItemsInQueue, "count", workQueue.getAttribute(stringNumberOfWorkItemsInQueue).getAttributeInfo().getDescription(), time, time));
        this.averageTimeInQueue = new MutableBoundedRangeStatisticImpl(new BoundedRangeStatisticImpl(0L, 0L, 0L, Long.MAX_VALUE, 0L, stringAverageTimeInQueue, "Milliseconds", workQueue.getAttribute(stringAverageTimeInQueue).getAttributeInfo().getDescription(), time, time));
    }

    public CountStatistic getNumberOfBusyThreads() {
        long numBusyThreads = (Long)this.threadPool.getAttribute(stringNumberOfBusyThreads).getValue();
        this.numberOfBusyThreads.setCount(numBusyThreads);
        return (CountStatistic)this.numberOfBusyThreads.modifiableView();
    }

    public CountStatistic getNumberOfAvailableThreads() {
        long numAvailableThreads = (Long)this.threadPool.getAttribute(stringNumberOfAvailableThreads).getValue();
        this.numberOfAvailableThreads.setCount(numAvailableThreads);
        return (CountStatistic)this.numberOfAvailableThreads.modifiableView();
    }

    public BoundedRangeStatistic getCurrentNumberOfThreads() {
        long numCurrentThreads = (Long)this.threadPool.getAttribute(stringCurrentNumberOfThreads).getValue();
        this.currentNumberOfThreads.setCount(numCurrentThreads);
        return (BoundedRangeStatistic)this.currentNumberOfThreads.modifiableView();
    }

    public RangeStatistic getAverageWorkCompletionTime() {
        long avgWorkCompletionTime = (Long)this.threadPool.getAttribute(stringAverageWorkCompletionTime).getValue();
        this.averageWorkCompletionTime.setCount(avgWorkCompletionTime);
        return (RangeStatistic)this.averageWorkCompletionTime.modifiableView();
    }

    public CountStatistic getTotalWorkItemsAdded() {
        long totWorkItemsAdded = (Long)this.workQueue.getAttribute(stringTotalWorkItemsAdded).getValue();
        this.totalWorkItemsAdded.setCount(totWorkItemsAdded);
        return (CountStatistic)this.totalWorkItemsAdded.modifiableView();
    }

    public BoundedRangeStatistic getNumberOfWorkItemsInQueue() {
        long totWorkItemsInQueue = (Long)this.workQueue.getAttribute(stringNumberOfWorkItemsInQueue).getValue();
        this.numberOfWorkItemsInQueue.setCount(totWorkItemsInQueue);
        return (BoundedRangeStatistic)this.numberOfWorkItemsInQueue.modifiableView();
    }

    public RangeStatistic getAverageTimeInQueue() {
        long avgTimeInQueue = (Long)this.workQueue.getAttribute(stringAverageTimeInQueue).getValue();
        this.averageTimeInQueue.setCount(avgTimeInQueue);
        return (RangeStatistic)this.averageTimeInQueue.modifiableView();
    }
}

