/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.config.JDBCConnectionPoolConfig;
import com.sun.appserv.management.config.ResourceRefConfig;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.config.ResourceFactoryImplBase;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JDBCResourceConfigFactory
extends ResourceFactoryImplBase {
    public static final String POOL_NAME_KEY = "PoolName";

    public JDBCResourceConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    @Override
    protected ObjectName createOldChildConfig(AttributeList translatedAttrs) {
        this.trace("JDBCResourceConfigFactory.createOldChildConfig: creating using: " + this.stringify(translatedAttrs));
        ObjectName objectName = this.getOldResourcesMBean().createJdbcResource(translatedAttrs);
        return objectName;
    }

    @Override
    protected Map<String, String> getParamNameOverrides() {
        return MapUtil.newMap("Name", "jndi-name");
    }

    public ObjectName create(String jndiName, String poolName, Map<String, String> optional) {
        JDBCConnectionPoolConfig pool = (JDBCConnectionPoolConfig)this.getCallbacks().getProxyFactory().getDomainRoot().getDomainConfig().getContainee("X-JDBCConnectionPoolConfig", poolName);
        if (pool == null) {
            throw new IllegalArgumentException("JDBCConnectionPoolConfig does not exit: " + poolName);
        }
        String[] requiredParams = new String[]{POOL_NAME_KEY, poolName};
        Map<String, String> params = this.initParams(jndiName, requiredParams, optional);
        ObjectName amxName = this.createNamedChild(jndiName, params);
        return amxName;
    }

    @Override
    protected void removeByName(String name) {
        Set<ResourceRefConfig> refs = this.findAllRefConfigs("X-JDBCResourceConfig", name);
        if (refs.size() == 0) {
            this.getOldResourcesMBean().removeJdbcResourceByJndiName(name);
        } else {
            for (ResourceRefConfig ref : refs) {
                String target = ref.getContainer().getName();
                this.getOldResourcesMBean().deleteJdbcResource(name, target);
            }
        }
    }
}

