/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.deploy;

import com.sun.appserv.management.deploy.DeploymentStatusImpl;
import com.sun.appserv.management.util.misc.TypeCast;
import com.sun.enterprise.deployment.backend.DeploymentRequestRegistry;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.phasing.DeploymentService;
import java.io.Serializable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Undeployer {
    private final String mModuleID;
    private Map mParams;

    public Undeployer(String moduleID, Map<String, String> params) {
        this.mModuleID = moduleID;
        this.mParams = params;
    }

    public com.sun.appserv.management.deploy.DeploymentStatus undeploy() {
        try {
            DeploymentStatus ds = DeploymentService.getDeploymentService().undeploy(this.mModuleID, this.mParams);
            ds.setStageStatus(ds.getStatus());
            DeploymentRequestRegistry.getRegistry().removeDeploymentRequest(this.mModuleID);
            Map<String, Serializable> m = TypeCast.checkMap(ds.asMap(), String.class, Serializable.class);
            return new DeploymentStatusImpl(m);
        }
        catch (Exception e) {
            DeploymentStatus ds = new DeploymentStatus();
            ds.setStageException(e);
            ds.setStageStatus(0);
            ds.setStageStatusMessage(e.getMessage());
            ds.setStageDescription("UnDeployment");
            DeploymentRequestRegistry.getRegistry().removeDeploymentRequest(this.mModuleID);
            Map<String, Serializable> m = TypeCast.checkMap(ds.asMap(), String.class, Serializable.class);
            return new DeploymentStatusImpl(m);
        }
    }
}

