/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.monitor;

import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.enterprise.management.support.AMXImplBase;
import java.lang.reflect.Method;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.monitor.Monitor;

public class JMXMonitorBase
extends AMXImplBase {
    final Monitor mMonitor;

    protected JMXMonitorBase(Monitor mon) {
        this.mMonitor = mon;
    }

    public String getGroup() {
        return "utility";
    }

    protected Object getAttributeManually(String name) throws AttributeNotFoundException {
        MBeanAttributeInfo attrInfo = this.getAttributeInfos().get(name);
        assert (attrInfo != null);
        String prefix = attrInfo.isIs() ? "is" : "get";
        String operationName = prefix + name;
        Object result = null;
        try {
            result = this.invokeManually(operationName, null, null);
        }
        catch (Exception e) {
            throw new AttributeNotFoundException(name);
        }
        return result;
    }

    protected void setAttributeManually(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException {
        String operationName = "set" + attr.getName();
        MBeanAttributeInfo attrInfo = this.getAttributeInfos().get(attr.getName());
        Object result = null;
        try {
            Object value = attr.getValue();
            Class theClass = ClassUtil.getClassFromName(attrInfo.getType());
            result = this.invokeSig(operationName, new Object[]{value}, new Class[]{theClass});
            assert (result == null);
        }
        catch (Exception e) {
            throw new AttributeNotFoundException(attr.getName());
        }
    }

    private Object invokeSig(String operationName, Object[] args, Class[] sig) throws MBeanException, ReflectionException, NoSuchMethodException {
        Object result = null;
        try {
            Method m = this.mMonitor.getClass().getMethod(operationName, sig);
            result = m.invoke((Object)this.mMonitor, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    protected Object invokeManually(String operationName, Object[] args, String[] types) throws MBeanException, ReflectionException, NoSuchMethodException {
        Object result = null;
        try {
            Class[] sig = ClassUtil.signatureFromClassnames(types);
            result = this.invokeSig(operationName, args, sig);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return result;
    }

    public void preRegisterDone() throws Exception {
        ObjectName x = this.mMonitor.preRegister(this.getMBeanServer(), this.getObjectName());
    }

    public void postRegisterHook(Boolean registrationDone) {
        super.postRegisterHook(registrationDone);
        this.mMonitor.postRegister(registrationDone);
    }

    public void preDeregisterHook() {
        super.preDeregisterHook();
        try {
            this.mMonitor.preDeregister();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void postDeregisterHook() {
        super.postDeregisterHook();
        this.mMonitor.postDeregister();
    }
}

