/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.offline;

import com.sun.appserv.management.base.AMXDebug;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.ListUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.util.ConfigXPathHelper;
import com.sun.enterprise.management.offline.ConfigBeanHelperFactory;
import com.sun.enterprise.management.support.oldconfig.OldProps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ConfigBeanHelper {
    private final ConfigBean mConfigBean;
    private final String mXPath;
    private final ConfigContext mConfigContext;
    private final String mType;
    private final String mName;
    private static final String NAME_ATTR = "Name";
    private static final String VALUE_ATTR = "Value";
    private static final String DESCRIPTION_ATTR = "Description";
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];

    ConfigBeanHelper(ConfigContext configContext, ConfigBean configBean) {
        if (configBean == null) {
            throw new IllegalArgumentException("null configBean");
        }
        if (configContext == null) {
            throw new IllegalArgumentException("null configContext");
        }
        this.mConfigContext = configContext;
        this.mConfigBean = configBean;
        this.mXPath = this.mConfigBean.getXPath();
        assert (this.mXPath != null);
        this.mType = ConfigBeanHelper._getType(this.mXPath);
        this.mName = this._getName();
    }

    protected void debug(Object o) {
        this.sdebug(o);
        String xpath = "" + this.mXPath;
        AMXDebug.getInstance().getOutput("ConfigBeanHelper").println(xpath + ": " + o);
    }

    protected void sdebug(Object o) {
        System.out.println("" + o);
    }

    public ConfigBean getConfigBean() {
        return this.mConfigBean;
    }

    public ConfigContext getConfigContext() {
        return this.mConfigContext;
    }

    public Object getAttribute(String attrName) throws AttributeNotFoundException {
        String result = null;
        if (DESCRIPTION_ATTR.equals(attrName)) {
            result = this.getDescription();
        } else {
            try {
                result = this.mConfigBean.getAttributeValue(attrName);
            }
            catch (RuntimeException e) {
                this.debug("ATTR FAILED: " + attrName);
                throw e;
            }
        }
        return result;
    }

    public String getXPath() {
        return this.mXPath;
    }

    public String getParentXPath() {
        return ConfigXPathHelper.getParentXPath(this.getXPath());
    }

    public String getType() {
        return this.mType;
    }

    static String _getType(String xPath) {
        return ConfigXPathHelper.getLastNodeName(xPath);
    }

    public String getName() {
        return this.mName;
    }

    public String[] getTypeAndName() throws ConfigException {
        return new String[]{this.getType(), this.getName()};
    }

    private String _getName() {
        String name = null;
        Set<String> attrNames = GSetUtil.newStringSet(this.getAttributeNames());
        for (String nameKey : OldProps.getPossibleNameKeys()) {
            String camelized = ConfigBean.camelize(nameKey);
            if (!attrNames.contains(camelized)) continue;
            try {
                name = (String)this.getAttribute(camelized);
                if (name == null) continue;
                break;
            }
            catch (AttributeNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return name;
    }

    public List<String[]> getAllObjectNameProps(Set<String> ignoreTypes) throws ConfigException {
        ArrayList<String[]> props = new ArrayList<String[]>();
        String[] pair = this.getTypeAndName();
        props.add(pair);
        String curXPath = ConfigXPathHelper.getParentXPath(this.getXPath());
        String lastXPath = null;
        while (!curXPath.equals(lastXPath)) {
            ConfigBeanHelper helper = ConfigBeanHelperFactory.getInstance(this.getConfigContext()).getHelper(curXPath);
            pair = helper.getTypeAndName();
            if (!ignoreTypes.contains(pair[0])) {
                props.add(pair);
            }
            lastXPath = curXPath;
            curXPath = helper.getParentXPath();
        }
        return props;
    }

    public void setAttribute(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException {
        Object value = attr.getValue();
        this.setAttribute(attr.getName(), value);
    }

    public void setAttribute(String name, Object value) throws AttributeNotFoundException, InvalidAttributeValueException {
        if (DESCRIPTION_ATTR.equals(name)) {
            this.setDescription((String)value);
        } else {
            String valueString = value == null ? null : "" + value;
            this.mConfigBean.setAttributeValue(name, valueString);
        }
    }

    protected boolean hasValue(String valueName) {
        boolean hasValue = false;
        try {
            Object value = this.mConfigBean.getValue(valueName);
            hasValue = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hasValue;
    }

    private boolean hasDescription() {
        return this.hasValue(DESCRIPTION_ATTR);
    }

    public final String[] getAttributeNames() {
        return GSetUtil.toStringArray(this._getAttributeNames());
    }

    protected Set<String> _getAttributeNames() {
        Set<String> attrNames = GSetUtil.newSet(this.mConfigBean.getAttributeNames());
        assert (!attrNames.contains(null));
        attrNames.remove(null);
        if (this.hasDescription()) {
            attrNames.add(DESCRIPTION_ATTR);
        }
        return attrNames;
    }

    protected Class getAttributeClass(String attrName) {
        return String.class;
    }

    protected MBeanAttributeInfo getMBeanAttributeInfo(String attrName) {
        String description = "";
        boolean isReadable = true;
        boolean isWriteable = true;
        boolean isIs = false;
        assert (attrName != null);
        MBeanAttributeInfo info = new MBeanAttributeInfo(attrName, this.getAttributeClass(attrName).getName(), "", true, true, false);
        return info;
    }

    public MBeanInfo getMBeanInfo() {
        List<String> attrNames = ListUtil.newListFromArray(this.getAttributeNames());
        MBeanOperationInfo[] operationInfos = new MBeanOperationInfo[]{};
        MBeanAttributeInfo[] attributeInfos = new MBeanAttributeInfo[attrNames.size()];
        int i = 0;
        for (String name : attrNames) {
            assert (name != null);
            attributeInfos[i] = this.getMBeanAttributeInfo(name);
            assert (attributeInfos[i].getName() != null);
            ++i;
        }
        MBeanInfo info = new MBeanInfo(this.getClass().getName(), "exposes Attributes from ConfigBean", attributeInfos, null, operationInfos, null);
        for (MBeanAttributeInfo xxx : info.getAttributes()) {
            assert (xxx.getName() != null);
        }
        return info;
    }

    public List<ConfigBeanHelper> getAllChildren() {
        ArrayList<ConfigBeanHelper> children = new ArrayList<ConfigBeanHelper>();
        ConfigBean[] configBeans = this.mConfigBean.getAllChildBeans();
        if (configBeans != null) {
            for (ConfigBean configBean : configBeans) {
                if (configBean == null) continue;
                ConfigBeanHelper helper = ConfigBeanHelperFactory.getInstance(this.getConfigContext()).getHelper(configBean);
                children.add(helper);
            }
        }
        return children;
    }

    public List<ConfigBeanHelper> getAllChildrenOfType(String desiredType) {
        List<ConfigBeanHelper> children = this.getAllChildren();
        ArrayList<ConfigBeanHelper> propertyChildren = new ArrayList<ConfigBeanHelper>();
        for (ConfigBeanHelper helper : children) {
            if (!desiredType.equals(helper.getType())) continue;
            propertyChildren.add(helper);
        }
        return propertyChildren;
    }

    public Map<String, ConfigBeanHelper> getSpecialChildMap(String type) {
        if (!"element-property".equals(type) && !"system-property".equals(type) || "jvm-option".equals(type)) {
            throw new IllegalArgumentException(type);
        }
        List<ConfigBeanHelper> children = this.getAllChildrenOfType(type);
        HashMap<String, ConfigBeanHelper> m = new HashMap<String, ConfigBeanHelper>();
        for (ConfigBeanHelper helper : children) {
            try {
                String name = (String)helper.getAttribute(NAME_ATTR);
                m.put(name, helper);
            }
            catch (Exception e) {
                throw new RuntimeException("FAILURE getting Name Attribute for property element", e);
            }
        }
        return m;
    }

    public AttributeList getProperties() {
        Map<String, ConfigBeanHelper> children = this.getSpecialChildMap("element-property");
        AttributeList attrs = new AttributeList();
        for (String name : children.keySet()) {
            ConfigBeanHelper helper = children.get(name);
            String value = ConfigBeanHelper.getValueAttributeValue(helper);
            attrs.add(new Attribute(name, value));
        }
        return attrs;
    }

    public AttributeList getSystemProperties() {
        Map<String, ConfigBeanHelper> children = this.getSpecialChildMap("system-property");
        AttributeList attrs = new AttributeList();
        for (String name : children.keySet()) {
            ConfigBeanHelper helper = children.get(name);
            String value = ConfigBeanHelper.getValueAttributeValue(helper);
            attrs.add(new Attribute(name, value));
        }
        return attrs;
    }

    protected static String getValueAttributeValue(ConfigBeanHelper helper) {
        try {
            String value = (String)helper.getAttribute(VALUE_ATTR);
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException("FAILURE getting Value Attribute for property element ", e);
        }
    }

    public String getPropertyValue(String propertyName) {
        Map<String, ConfigBeanHelper> children = this.getSpecialChildMap("element-property");
        if (!children.containsKey(propertyName)) {
            String msg = "No such property: " + StringUtil.quote(propertyName);
            throw new IllegalArgumentException(msg);
        }
        return ConfigBeanHelper.getValueAttributeValue(children.get(propertyName));
    }

    public String getSystemPropertyValue(String propertyName) {
        Map<String, ConfigBeanHelper> children = this.getSpecialChildMap("system-property");
        if (!children.containsKey(propertyName)) {
            throw new IllegalArgumentException(propertyName);
        }
        return ConfigBeanHelper.getValueAttributeValue(children.get(propertyName));
    }

    private static void setValueAttributeValue(ConfigBeanHelper helper, String value) {
        try {
            helper.setAttribute(VALUE_ATTR, value);
        }
        catch (Exception e) {
            throw new RuntimeException("FAILURE setting Value Attribute for property element ", e);
        }
    }

    public void setProperty(Attribute attr) {
        Map<String, ConfigBeanHelper> children = this.getSpecialChildMap("element-property");
        ConfigBeanHelper helper = children.get(attr.getName());
        if (helper == null) {
            throw new IllegalArgumentException(attr.getName());
        }
        ConfigBeanHelper.setValueAttributeValue(helper, (String)attr.getValue());
    }

    public void setSystemProperty(Attribute attr) {
        Map<String, ConfigBeanHelper> children = this.getSpecialChildMap("system-property");
        ConfigBeanHelper helper = children.get(attr.getName());
        if (helper == null) {
            throw new IllegalArgumentException(attr.getName());
        }
        ConfigBeanHelper.setValueAttributeValue(helper, (String)attr.getValue());
    }

    public String getDescription() {
        String result = (String)this.getValue(DESCRIPTION_ATTR);
        return result;
    }

    public void setDescription(String description) {
        this.mConfigBean.setValue(DESCRIPTION_ATTR, description);
    }

    protected Object getValue(String valueName) {
        Object value = null;
        try {
            value = this.mConfigBean.getValue(valueName);
        }
        catch (Exception e) {
            this.debug("ConfigBeanHelper.getValue: Exception accessing value: " + valueName);
        }
        return value;
    }

    public abstract Object handleInvoke(String var1, Object[] var2, String[] var3);

    public void unsupportedOperation(String operationName, Object[] args, String[] types) {
        throw new IllegalArgumentException("invoke() unknown operation " + operationName + "()");
    }
}

