/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.offline;

import com.sun.appserv.management.base.AMXDebug;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.impl.ConfigContextImpl;
import com.sun.enterprise.management.offline.ConfigDelegate;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public final class ConfigDelegateFactory {
    private ConfigContext mConfigContext;
    private final File mDomainXML;
    private static Map<File, ConfigDelegateFactory> mFactories;

    private ConfigDelegateFactory(File domainXML) throws ConfigException {
        this.mDomainXML = domainXML;
        this.mConfigContext = this.createConfigContext(this.mDomainXML);
    }

    private void debug(Object o) {
        AMXDebug.getInstance().getOutput("ConfigDelegateFactory").println(o);
    }

    public static synchronized ConfigDelegateFactory getInstance(File domainXML) throws ConfigException {
        ConfigDelegateFactory instance;
        if (mFactories == null) {
            mFactories = new HashMap<File, ConfigDelegateFactory>();
        }
        if ((instance = mFactories.get(domainXML)) == null) {
            instance = new ConfigDelegateFactory(domainXML);
            mFactories.put(domainXML, instance);
        }
        return instance;
    }

    synchronized ConfigDelegate createConfigDelegate(ConfigBean configBean) throws ConfigException {
        if (this.getConfigContext() != configBean.getConfigContext()) {
            throw new IllegalArgumentException("ConfigBean " + configBean.getXPath() + " has mismatched ConfigContext");
        }
        return new ConfigDelegate(this.getConfigContext(), configBean);
    }

    private ConfigContext createConfigContext(File domainXML) throws ConfigException {
        this.setPreEnvironment();
        ConfigContext ctx = ConfigFactory.createConfigContext(domainXML.toString(), true, true, true);
        this.setPostEnvironment(ctx);
        return ctx;
    }

    public ConfigContext getConfigContext() {
        return this.mConfigContext;
    }

    private void setPreEnvironment() {
        System.setProperty("com.sun.enterprise.config.config_environment_factory_class", "com.sun.enterprise.config.serverbeans.AppserverConfigEnvironmentFactory");
    }

    private void setPostEnvironment(ConfigContext ctx) {
        try {
            ((ConfigContextImpl)ctx).setXPathInAllBeans();
        }
        catch (ConfigException e) {
            throw new RuntimeException(e);
        }
    }
}

