/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.SystemInfo;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.RefConfig;
import com.sun.appserv.management.config.ServerConfig;
import com.sun.appserv.management.config.ServerRefConfig;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.jmx.MBeanRegistrationListener;
import com.sun.appserv.management.util.misc.CollectionUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import com.sun.enterprise.management.support.Loader;
import com.sun.enterprise.management.support.LoaderOfOld;
import com.sun.enterprise.management.support.OldConfigTypes;
import com.sun.enterprise.management.support.OldTypeToJ2EETypeMapper;
import com.sun.enterprise.management.support.oldconfig.OldConfigProxies;
import com.sun.enterprise.management.support.oldconfig.OldProps;
import com.sun.enterprise.management.support.oldconfig.OldServersMBean;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LoaderOfOldConfig
extends LoaderOfOld {
    private final boolean mSupportsClusters;
    private final ServerRefListener mServerRefListener;
    private static final Set<String> NEEDS_SUPPORT = GSetUtil.newUnmodifiableStringSet(new String[0]);
    private static final String OLD_SERVER_TYPE = "server";

    LoaderOfOldConfig(Loader loader) {
        super(loader);
        SystemInfo systemInfo = this.getDomainRoot().getSystemInfo();
        this.mSupportsClusters = systemInfo.supportsFeature("SupportsClusters");
        if (NEEDS_SUPPORT.size() != 0) {
            this.getLogger().warning("Support for the following old config mbean types is not yet implemented: {" + SmartStringifier.toString(NEEDS_SUPPORT) + "}");
        }
        try {
            this.mServerRefListener = new ServerRefListener("LoaderOfOldConfig");
            this.mServerRefListener.startListening();
        }
        catch (Exception e) {
            this.debug("" + e);
            throw new Error(e);
        }
    }

    private ObjectName getListenToServerRefConfigPattern() {
        String jmxDomain = Util.getObjectName(this.getDomainRoot()).getDomain();
        String props = Util.makeJ2EETypeProp("X-ServerRefConfig");
        return Util.newObjectNamePattern(jmxDomain, props);
    }

    @Override
    protected Set<String> getIgnoreTypes() {
        return OldConfigTypes.getIgnoreTypes();
    }

    private Set<ObjectName> getOldServerConfigObjectNames() {
        ObjectName pattern = Util.newObjectNamePattern("com.sun.appserv", "type=server");
        Set<ObjectName> objectNames = JMXUtil.queryNames(this.getMBeanServer(), pattern, null);
        if (objectNames.size() == 0) {
            pattern = Util.newObjectNamePattern("ias", "type=server");
            objectNames = JMXUtil.queryNames(this.getMBeanServer(), pattern, null);
        }
        return objectNames;
    }

    @Override
    protected Set<ObjectName> findAllOldCandidates() {
        ObjectName pattern = null;
        Set<ObjectName> oldNames = null;
        pattern = Util.newObjectNamePattern("com.sun.appserv", "category=config");
        oldNames = JMXUtil.queryNames(this.getMBeanServer(), pattern, null);
        oldNames.addAll(this.getOldServerConfigObjectNames());
        this.debug("LoaderOfOldConfig: found the following:");
        this.debug(CollectionUtil.toString(oldNames, "\n"));
        return oldNames;
    }

    @Override
    protected Set<String> getNeedsSupport() {
        return NEEDS_SUPPORT;
    }

    private boolean isOldConfigMBean(ObjectName objectName) {
        boolean isOldConfigMBean = false;
        if (objectName.getDomain().equals("com.sun.appserv") && "config".equals(objectName.getKeyProperty("category"))) {
            String type = objectName.getKeyProperty("type");
            isOldConfigMBean = !OldConfigTypes.getIgnoreTypes().contains(type);
        }
        return isOldConfigMBean;
    }

    @Override
    protected boolean isOldMBean(ObjectName objectName) {
        return this.isOldConfigMBean(objectName);
    }

    @Override
    protected ObjectName oldToNewObjectName(ObjectName oldObjectName) {
        this.trace("oldToNewObjectName: " + oldObjectName);
        MyOldTypes mapper = new MyOldTypes();
        OldProps oldProps = new OldProps(oldObjectName, mapper);
        String domainName = this.mLoader.getAMXJMXDomainName();
        String props = oldProps.getNewProps();
        ObjectName newObjectName = Util.newObjectName(domainName, props);
        return newObjectName;
    }

    private final class MyOldTypes
    implements OldTypeToJ2EETypeMapper {
        private final OldConfigTypes mOldTypes = OldConfigTypes.getInstance();
        private final OldServersMBean mOldServers;

        public MyOldTypes() {
            this.mOldServers = OldConfigProxies.getInstance(LoaderOfOldConfig.this.getMBeanServer()).getOldServersMBean();
        }

        public String j2eeTypeToOldType(String j2eeType) {
            return this.mOldTypes.j2eeTypeToOldType(j2eeType);
        }

        private boolean isStandaloneServer(String name) {
            boolean isStandalone = true;
            if (LoaderOfOldConfig.this.mSupportsClusters) {
                ObjectName[] standaloneServerObjectNames = this.mOldServers.listUnclusteredServerInstances(false);
                isStandalone = false;
                for (int i = 0; i < standaloneServerObjectNames.length; ++i) {
                    if (!name.equals(Util.getName(standaloneServerObjectNames[i]))) continue;
                    isStandalone = true;
                    break;
                }
            }
            LoaderOfOldConfig.this.debug("isStandalone: " + name + " = " + isStandalone);
            return isStandalone;
        }

        private String getServerJ2EEType(String name) {
            assert (name != null);
            String j2eeType = this.isStandaloneServer(name) ? "X-StandaloneServerConfig" : "X-ClusteredServerConfig";
            LoaderOfOldConfig.this.debug("Server " + name + " is of type " + j2eeType);
            return j2eeType;
        }

        public String oldTypeToJ2EEType(String oldType, ObjectName objectName) {
            String j2eeType = null;
            if (oldType.equals(objectName.getKeyProperty("type"))) {
                j2eeType = this.oldObjectNameToJ2EEType(objectName);
            } else if (oldType.equals(LoaderOfOldConfig.OLD_SERVER_TYPE)) {
                String name = objectName.getKeyProperty(LoaderOfOldConfig.OLD_SERVER_TYPE);
                assert (name != null) : "no name in: " + objectName;
                j2eeType = this.getServerJ2EEType(name);
            } else {
                j2eeType = this.mOldTypes.oldTypeToJ2EEType(oldType, objectName);
            }
            return j2eeType;
        }

        public String oldObjectNameToJ2EEType(ObjectName objectName) {
            String j2eeType = null;
            String oldType = objectName.getKeyProperty("type");
            if (oldType.equals(LoaderOfOldConfig.OLD_SERVER_TYPE)) {
                String name = objectName.getKeyProperty("name");
                j2eeType = this.getServerJ2EEType(name);
            } else {
                j2eeType = this.mOldTypes.oldTypeToJ2EEType(oldType);
            }
            if (j2eeType == null) {
                LoaderOfOldConfig.this.getLogger().warning("can't find j2eeType for com.sun.appserv type=" + oldType + StringUtil.NEWLINE() + "This usually means that a new domain.xml element has been added which " + "is not yet supported by AMX.  File a bug requesting support, being sure to " + "specify the ObjectName " + StringUtil.quote(objectName));
            }
            return j2eeType;
        }
    }

    private final class ServerRefListener
    extends MBeanRegistrationListener {
        public ServerRefListener(String name) throws InstanceNotFoundException, IOException {
            super(name, LoaderOfOldConfig.this.getMBeanServer(), LoaderOfOldConfig.this.getListenToServerRefConfigPattern());
        }

        protected void mbeanRegistered(ObjectName objectName) {
            LoaderOfOldConfig.this.debug("mbeanRegistered: " + objectName);
            ServerRefConfig ref = ProxyFactory.getInstance(LoaderOfOldConfig.this.getMBeanServer()).getProxy(objectName, ServerRefConfig.class);
            if (ref.getContainer() instanceof ClusterConfig) {
                String serverName = ref.getRef();
                LoaderOfOldConfig.this.debug("mbeanRegistered: serverName = " + serverName);
                DomainConfig domainConfig = LoaderOfOldConfig.this.getDomainRoot().getDomainConfig();
                if (domainConfig.getClusteredServerConfigMap().get(serverName) == null) {
                    ServerConfig server = domainConfig.getServerConfigMap().get(serverName);
                    ObjectName serverObjectName = Util.getObjectName(server);
                    LoaderOfOldConfig.this.debug("mbeanRegistered: serverConfig = " + serverObjectName);
                    try {
                        HashSet<RefConfig> containees = new HashSet<RefConfig>();
                        containees.addAll(server.getResourceRefConfigMap().values());
                        containees.addAll(server.getDeployedItemRefConfigMap().values());
                        LoaderOfOldConfig.this.mLoader.resyncAMXMBean(serverObjectName);
                        for (RefConfig containee : containees) {
                            LoaderOfOldConfig.this.mLoader.resyncAMXMBean(Util.getObjectName(containee));
                        }
                    }
                    catch (Throwable t) {
                        LoaderOfOldConfig.this.getLogger().warning("mbeanRegistered: can't resync with: " + serverObjectName + ": " + t);
                    }
                } else {
                    LoaderOfOldConfig.this.debug("mbeanRegistered: server is already Clustered (ignoring)");
                }
            } else {
                LoaderOfOldConfig.this.debug("mbeanRegistered: ref not from a cluster (ignoring)");
            }
        }

        protected void mbeanUnregistered(ObjectName objectName) {
            LoaderOfOldConfig.this.debug("mbeanUnregistered: " + objectName);
        }
    }
}

