/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.management.support.Loader;
import com.sun.enterprise.management.support.LoaderOfOld;
import com.sun.enterprise.management.support.OldMonitorTypes;
import com.sun.enterprise.management.support.TypeInfos;
import com.sun.enterprise.management.support.oldconfig.OldProps;
import java.util.Set;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LoaderOfOldMonitor
extends LoaderOfOld {
    private static final Set<String> IGNORE_TYPES = GSetUtil.newUnmodifiableStringSet("connection-factories", "connector-modules", "connector-service", "connection-factory", "standalone-connector-module", "connection-pools", "resources", "thread-pools", "applications", "orb", "connection-managers", "bean-methods", "web-module", "standalone-web-module", "operating-system", "threadinfo", "memory", "thread-system", "garbage-collectors", "garbage-collector", "runtime", "compilation-system", "class-loading-system", "request", "pwc-thread-pool", "jndi", "jms-service", "jndi", "GMSClientMBean", "DomainDiagnostics", "JVMInformation", "JVMInformationCollector", "work-management");
    private static final Set<String> NEEDS_SUPPORT = GSetUtil.newUnmodifiableStringSet(new String[0]);

    LoaderOfOldMonitor(Loader loader) {
        super(loader);
    }

    @Override
    public Set<ObjectName> findAllOldCandidates() {
        ObjectName pattern = JMXUtil.newObjectName("com.sun.appserv:category=monitor,*");
        Set<ObjectName> all = JMXUtil.queryNames(this.getMBeanServer(), pattern, null);
        return all;
    }

    private static void mySleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private final String formApplicationAndServerProps(ObjectName oldObjectName) {
        String serverProp;
        String serverName = oldObjectName.getKeyProperty("server");
        String props = serverProp = Util.makeProp("X-ServerRootMonitor", serverName);
        String applicationName = oldObjectName.getKeyProperty("application");
        if (applicationName == null) {
            applicationName = "null";
        }
        String applicationProp = Util.makeProp("X-ApplicationMonitor", applicationName);
        props = Util.concatenateProps(props, applicationProp);
        return props;
    }

    @Override
    protected ObjectName oldToNewObjectName(ObjectName oldObjectName) {
        String oldType = oldObjectName.getKeyProperty("type");
        String domainName = this.mLoader.getAMXJMXDomainName();
        ObjectName newObjectName = null;
        if (oldType.equals("servlet")) {
            String webModuleVirtualServerMonitorName = oldObjectName.getKeyProperty("webmodule-virtual-server");
            String requiredProps = Util.makeRequiredProps("X-ServletMonitor", oldObjectName.getKeyProperty("name"));
            String containerProp = Util.makeProp("X-WebModuleVirtualServerMonitor", webModuleVirtualServerMonitorName);
            String containmentProps = this.formApplicationAndServerProps(oldObjectName);
            String props = Util.concatenateProps(requiredProps, containerProp, containmentProps);
            newObjectName = JMXUtil.newObjectName(domainName, props);
        } else if (oldType.equals("webservice-endpoint")) {
            String ejbModName = oldObjectName.getKeyProperty("standalone-ejb-module");
            if (ejbModName == null) {
                ejbModName = oldObjectName.getKeyProperty("ejb-module");
            }
            if (ejbModName != null) {
                String requiredProps = Util.makeRequiredProps("X-WebServiceEndpointMonitor", oldObjectName.getKeyProperty("name"));
                String modProp = Util.makeProp("X-EJBModuleMonitor", ejbModName);
                String containmentProps = this.formApplicationAndServerProps(oldObjectName);
                String props = Util.concatenateProps(requiredProps, modProp, containmentProps);
                newObjectName = JMXUtil.newObjectName(domainName, props);
            } else {
                String requiredProps = Util.makeRequiredProps("X-WebServiceEndpointMonitor", oldObjectName.getKeyProperty("name"));
                String webModuleVirtualServerMonitorName = oldObjectName.getKeyProperty("webmodule-virtual-server");
                String modProp = Util.makeProp("X-WebModuleVirtualServerMonitor", webModuleVirtualServerMonitorName);
                String containmentProps = this.formApplicationAndServerProps(oldObjectName);
                String props = Util.concatenateProps(requiredProps, modProp, containmentProps);
                newObjectName = JMXUtil.newObjectName(domainName, props);
            }
        } else {
            OldMonitorTypes mapper = OldMonitorTypes.getInstance();
            OldProps oldProps = new OldProps(oldObjectName, mapper);
            String props = oldProps.getNewProps();
            newObjectName = JMXUtil.newObjectName(domainName, props);
            String j2eeType = newObjectName.getKeyProperty("j2eeType");
            String[] fullType = TypeInfos.getInstance().getJ2EETypeChain(newObjectName);
            for (int i = 0; i < fullType.length - 1; ++i) {
                if (!fullType[i].equals("X-ApplicationMonitor") || newObjectName.getKeyProperty("X-ApplicationMonitor") != null) continue;
                String prop = Util.makeProp("X-ApplicationMonitor", "null");
                newObjectName = JMXUtil.newObjectName(newObjectName, prop);
                break;
            }
        }
        return newObjectName;
    }

    private String getContextRoot(String webModuleName) {
        ConfigBean cb = null;
        ConfigContext cCtx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        try {
            cb = ApplicationHelper.findApplication(cCtx, webModuleName);
        }
        catch (Exception e) {
            return null;
        }
        if (cb instanceof WebModule) {
            String ctxRoot = ((WebModule)cb).getContextRoot();
            if (ctxRoot != null && ctxRoot.length() > 0 && ctxRoot.charAt(0) == '/') {
                ctxRoot = ctxRoot.substring(1, ctxRoot.length());
            }
            return ctxRoot;
        }
        return null;
    }

    private boolean isOldMonitorObjectName(ObjectName objectName) {
        boolean isOldMonitor = false;
        if (objectName.getDomain().equals("com.sun.appserv") && "monitor".equals(objectName.getKeyProperty("category"))) {
            String type = objectName.getKeyProperty("type");
            isOldMonitor = !this.getIgnoreTypes().contains(type);
        }
        return isOldMonitor;
    }

    @Override
    protected Set<String> getNeedsSupport() {
        return NEEDS_SUPPORT;
    }

    @Override
    protected Set<String> getIgnoreTypes() {
        return IGNORE_TYPES;
    }

    @Override
    public boolean isOldMBean(ObjectName oldObjectName) {
        return this.isOldMonitorObjectName(oldObjectName);
    }
}

