/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.AMXDebug;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.jmx.NotificationBuilder;
import com.sun.appserv.management.util.misc.Output;
import com.sun.enterprise.management.support.MBeanInfoConverter;
import com.sun.enterprise.management.support.TestDummyMBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public final class TestDummy
implements TestDummyMBean,
DynamicMBean,
MBeanRegistration {
    private final NotificationBroadcasterSupport mBroadcaster;
    private final Map<String, Object> mAttributes = Collections.synchronizedMap(new HashMap());
    private MBeanInfo mMBeanInfo = null;
    private Output mDebug = AMXDebug.getInstance().getOutput(this.getDebugID());
    private MBeanServer mServer;
    private ObjectName mSelfObjectName;

    public TestDummy() {
        this.mBroadcaster = new NotificationBroadcasterSupport();
    }

    public String getAttr1() {
        return (String)this.mAttributes.get("Attr1");
    }

    public void setAttr1(String value) {
        this.setAttribute("Attr1", value);
    }

    public String getAttr2() {
        return (String)this.mAttributes.get("Attr2");
    }

    public void setAttr2(String value) {
        this.setAttribute("Attr2", value);
    }

    private void debug(Object o) {
        this.mDebug.println(o);
    }

    private String getDebugID() {
        return this.getClass().getName();
    }

    public void addAttribute(String name, Object value) {
        if (name == null || name.length() == 0) {
            this.debug("Illegal Attribute name: " + name);
            throw new IllegalArgumentException();
        }
        this.mAttributes.put(name, value);
        this.mMBeanInfo = null;
        this.debug("added Attribute: " + name);
    }

    public void removeAttribute(String name) {
        this.mAttributes.remove(name);
        this.mMBeanInfo = null;
        this.debug("removed Attribute: " + name);
    }

    private synchronized MBeanInfo createMBeanInfo() {
        this.debug("createMBeanInfo");
        MBeanInfo baseMBeanInfo = MBeanInfoConverter.getInstance().convert(TestDummy.class, null);
        ArrayList<MBeanAttributeInfo> dynamicAttrInfos = new ArrayList<MBeanAttributeInfo>();
        boolean i = false;
        for (String name : this.mAttributes.keySet()) {
            Object value = this.mAttributes.get(name);
            String type = value == null ? String.class.getName() : value.getClass().getName();
            MBeanAttributeInfo info = new MBeanAttributeInfo(name, type, "dynamically-added Attribute", true, true, false);
            dynamicAttrInfos.add(info);
        }
        MBeanAttributeInfo[] dynInfos = new MBeanAttributeInfo[dynamicAttrInfos.size()];
        dynamicAttrInfos.toArray(dynInfos);
        MBeanAttributeInfo[] attrInfos = JMXUtil.mergeMBeanAttributeInfos(dynInfos, baseMBeanInfo.getAttributes());
        return JMXUtil.newMBeanInfo(baseMBeanInfo, attrInfos);
    }

    public synchronized MBeanInfo getMBeanInfo() {
        if (this.mMBeanInfo == null) {
            this.mMBeanInfo = this.createMBeanInfo();
        }
        return this.mMBeanInfo;
    }

    public Object getAttribute(String name) throws AttributeNotFoundException {
        if (!this.mAttributes.containsKey(name)) {
            throw new AttributeNotFoundException(name);
        }
        return this.mAttributes.get(name);
    }

    public AttributeList getAttributes(String[] names) {
        AttributeList attrs = new AttributeList();
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                try {
                    Object result = this.getAttribute(names[i]);
                    attrs.add(new Attribute(names[i], result));
                    continue;
                }
                catch (AttributeNotFoundException e) {
                    // empty catch block
                }
            }
        }
        return attrs;
    }

    public AttributeList setAttributes(AttributeList attrs) {
        throw new RuntimeException("TestDummy: setAttributes() not yet implemented");
    }

    public Object invoke(String methodName, Object[] args, String[] signature) {
        Long result = null;
        if (args == null) {
            throw new RuntimeException("internal Error -- no args");
        }
        int numArgs = args.length;
        if ("addAttribute".equals(methodName) && numArgs == 2) {
            this.addAttribute((String)args[0], args[1]);
        } else if ("removeAttribute".equals(methodName) && numArgs == 1) {
            this.removeAttribute((String)args[0]);
        } else if (numArgs == 2 && "emitNotifications".equals(methodName)) {
            String type = (String)args[0];
            int howMany = (Integer)args[1];
            result = this.emitNotifications(type, howMany);
        } else {
            throw new RuntimeException("invoke: no such method " + methodName);
        }
        return result;
    }

    public void setAttribute(String name, Object value) {
        this.debug("setAttribute" + name + "=" + value);
        this.addAttribute(name, value);
    }

    public void setAttribute(Attribute attr) {
        this.setAttribute(attr.getName(), attr.getValue());
    }

    protected ObjectName preRegisterModifyName(MBeanServer server, ObjectName nameIn) {
        String EXTRA = "";
        ObjectName nameOut = Util.newObjectName(nameIn.toString() + "");
        return nameOut;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName nameIn) throws Exception {
        this.mServer = server;
        this.mSelfObjectName = this.preRegisterModifyName(server, nameIn);
        return this.mSelfObjectName;
    }

    public void postRegister(Boolean registrationSucceeded) {
    }

    public void preDeregister() {
    }

    public void postDeregister() {
    }

    public long emitNotifications(String notifType, int howMany) {
        NotificationBuilder builder = new NotificationBuilder(notifType, this.mSelfObjectName);
        long start = System.currentTimeMillis();
        for (int i = 0; i < howMany; ++i) {
            Notification notif = builder.buildNew("test Notification");
            this.sendNotification(notif);
        }
        long elapsed = System.currentTimeMillis() - start;
        return elapsed;
    }

    public void addNotificationListener(NotificationListener listener) {
        this.mBroadcaster.addNotificationListener(listener, null, null);
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.mBroadcaster.addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.mBroadcaster.removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.mBroadcaster.removeNotificationListener(listener, filter, handback);
    }

    public void sendNotification(Notification notification) {
        this.mBroadcaster.sendNotification(notification);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }
}

