/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.ManagementObjectManager;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.SecurityMap;
import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.util.ConnectionPoolObjectsUtils;
import com.sun.enterprise.connectors.util.SecurityMapUtils;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.resource.GlobalResourceDeployer;
import com.sun.enterprise.server.ResourceDeployer;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectorConnectionPoolDeployer
extends GlobalResourceDeployer
implements ResourceDeployer {
    private static final String QUEUE_CF = "javax.jms.QueueConnectionFactory";
    private static final String TOPIC_CF = "javax.jms.TopicConnectionFactory";
    private static final String UNIVERSAL_CF = "javax.jms.ConnectionFactory";
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    private static StringManager localStrings = StringManager.getManager(ConnectorConnectionPoolDeployer.class);

    public synchronized void deployResource(Object resource) throws Exception {
        _logger.fine("ConnectorConnectionPoolDeployer : deployResource ");
        ConnectorConnectionPool domainCcp = (ConnectorConnectionPool)resource;
        if (ConnectionPoolObjectsUtils.isPoolSystemPool(domainCcp)) {
            this.redeployResource(resource);
            return;
        }
        com.sun.enterprise.connectors.ConnectorConnectionPool ccp = this.getConnectorConnectionPool(domainCcp);
        String defName = domainCcp.getConnectionDefinitionName();
        ConnectorRuntime crt = ConnectorRuntime.getRuntime();
        if (domainCcp.isEnabled()) {
            if (UNIVERSAL_CF.equals(defName) || QUEUE_CF.equals(defName) || TOPIC_CF.equals(defName)) {
                ManagementObjectManager mgr = this.getAppServerSwitchObject().getManagementObjectManager();
                mgr.registerJMSResource(domainCcp.getName(), defName, null, null, this.getPropNamesAsStrArr(domainCcp.getElementProperty()), this.getPropValuesAsStrArr(domainCcp.getElementProperty()));
            }
        } else {
            _logger.log(Level.INFO, "core.resource_disabled", new Object[]{domainCcp.getName(), "connector-connection-pool"});
        }
        _logger.log(Level.FINE, "Calling backend to add connectorConnectionPool", domainCcp.getResourceAdapterName());
        crt.createConnectorConnectionPool(ccp, defName, domainCcp.getResourceAdapterName(), domainCcp.getElementProperty(), domainCcp.getSecurityMap());
        _logger.log(Level.FINE, "Added connectorConnectionPool in backend", domainCcp.getResourceAdapterName());
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        _logger.fine("ConnectorConnectionPoolDeployer : undeployResource : ");
        ConnectorConnectionPool domainCcp = (ConnectorConnectionPool)resource;
        String poolName = domainCcp.getName();
        ConnectorRuntime crt = ConnectorRuntime.getRuntime();
        String defName = domainCcp.getConnectionDefinitionName();
        _logger.log(Level.FINE, "Calling backend to delete ConnectorConnectionPool", poolName);
        crt.deleteConnectorConnectionPool(poolName);
        _logger.log(Level.FINE, "Deleted ConnectorConnectionPool in backend", poolName);
        if (QUEUE_CF.equals(defName) || TOPIC_CF.equals(defName)) {
            ManagementObjectManager mgr = this.getAppServerSwitchObject().getManagementObjectManager();
            mgr.unregisterJMSResource(domainCcp.getName());
        }
    }

    public synchronized void redeployResource(Object resource) throws Exception {
        ConnectorConnectionPool domainCcp = (ConnectorConnectionPool)resource;
        SecurityMap[] securityMaps = domainCcp.getSecurityMap();
        String poolName = domainCcp.getName();
        ConnectorRuntime crt = ConnectorRuntime.getRuntime();
        if (!crt.isConnectorConnectionPoolDeployed(poolName)) {
            _logger.fine("The connector connection pool " + poolName + " is either not referred or not yet created in " + "this server instance and pool and hence " + "redeployment is ignored");
            return;
        }
        String rarName = domainCcp.getResourceAdapterName();
        String connDefName = domainCcp.getConnectionDefinitionName();
        ElementProperty[] props = domainCcp.getElementProperty();
        com.sun.enterprise.connectors.ConnectorConnectionPool ccp = this.getConnectorConnectionPool(domainCcp);
        this.populateConnectorConnectionPool(ccp, connDefName, rarName, props, securityMaps);
        boolean poolRecreateRequired = false;
        try {
            _logger.fine("Calling reconfigure pool");
            poolRecreateRequired = crt.reconfigureConnectorConnectionPool(ccp, new HashSet());
        }
        catch (ConnectorRuntimeException cre) {
            cre.printStackTrace();
        }
        if (poolRecreateRequired) {
            _logger.fine("Pool recreation required");
            crt.recreateConnectorConnectionPool(ccp);
            _logger.fine("Pool recreation done");
        }
    }

    public synchronized void disableResource(Object resource) throws Exception {
    }

    public synchronized void enableResource(Object resource) throws Exception {
    }

    public Object getResource(String name, Resources rbeans) throws Exception {
        ConnectorConnectionPool res = rbeans.getConnectorConnectionPoolByName(name);
        if (res == null) {
            Exception ex = new Exception("No such resource");
            _logger.log(Level.SEVERE, "no_resource", name);
            _logger.log(Level.SEVERE, "", ex);
            throw ex;
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     */
    private com.sun.enterprise.connectors.ConnectorConnectionPool getConnectorConnectionPool(ConnectorConnectionPool domainCcp) throws Exception {
        com.sun.enterprise.connectors.ConnectorConnectionPool ccp = new com.sun.enterprise.connectors.ConnectorConnectionPool(domainCcp.getName());
        ccp.setSteadyPoolSize(domainCcp.getSteadyPoolSize());
        ccp.setMaxPoolSize(domainCcp.getMaxPoolSize());
        ccp.setMaxWaitTimeInMillis(domainCcp.getMaxWaitTimeInMillis());
        ccp.setPoolResizeQuantity(domainCcp.getPoolResizeQuantity());
        ccp.setIdleTimeoutInSeconds(domainCcp.getIdleTimeoutInSeconds());
        ccp.setFailAllConnections(domainCcp.isFailAllConnections());
        ccp.setAuthCredentialsDefinedInPool(this.isAuthCredentialsDefinedInPool(domainCcp));
        ccp.setConnectionValidationRequired(domainCcp.isIsConnectionValidationRequired());
        String txSupport = domainCcp.getTransactionSupport();
        int txSupportIntVal = this.parseTransactionSupportString(txSupport);
        if (txSupportIntVal == -1) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Got transaction-support attr null from domain.xml");
            }
            txSupportIntVal = ConnectionPoolObjectsUtils.getTransactionSupportFromRaXml(domainCcp.getResourceAdapterName());
        } else if (!this.isTxSupportConfigurationSane(txSupportIntVal, domainCcp.getResourceAdapterName())) {
            String i18nMsg = localStrings.getString("ccp_deployer.incorrect_tx_support");
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            _logger.log(Level.SEVERE, "rardeployment.incorrect_tx_support", ccp.getName());
            throw cre;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("setting txSupportVal to " + txSupportIntVal + " in pool " + domainCcp.getName());
        }
        ccp.setTransactionSupport(txSupportIntVal);
        ccp.setNonComponent(false);
        ccp.setNonTransactional(false);
        ccp.setConnectionLeakTracingTimeout(domainCcp.getConnectionLeakTimeoutInSeconds());
        ccp.setConnectionReclaim(domainCcp.isConnectionLeakReclaim());
        ccp.setMatchConnections(domainCcp.isMatchConnections());
        ccp.setAssociateWithThread(domainCcp.isAssociateWithThread());
        boolean lazyConnectionEnlistment = domainCcp.isLazyConnectionEnlistment();
        boolean lazyConnectionAssociation = domainCcp.isLazyConnectionAssociation();
        if (lazyConnectionAssociation) {
            if (!lazyConnectionEnlistment) {
                _logger.log(Level.SEVERE, "conn_pool_obj_utils.lazy_enlist-lazy_assoc-invalid-combination", domainCcp.getName());
                String i18nMsg = localStrings.getString("cpou.lazy_enlist-lazy_assoc-invalid-combination", domainCcp.getName());
                throw new RuntimeException(i18nMsg);
            }
            ccp.setLazyConnectionAssoc(true);
            ccp.setLazyConnectionEnlist(true);
        } else {
            ccp.setLazyConnectionAssoc(lazyConnectionAssociation);
            ccp.setLazyConnectionEnlist(lazyConnectionEnlistment);
        }
        ccp.setMaxConnectionUsage(domainCcp.getMaxConnectionUsageCount());
        ccp.setValidateAtmostOncePeriod(domainCcp.getValidateAtmostOncePeriodInSeconds());
        ccp.setConCreationRetryAttempts(domainCcp.getConnectionCreationRetryAttempts());
        ccp.setConCreationRetryInterval(domainCcp.getConnectionCreationRetryIntervalInSeconds());
        this.convertElementPropertyToPoolProperty(ccp, domainCcp);
        return ccp;
    }

    private void populateConnectorConnectionPool(com.sun.enterprise.connectors.ConnectorConnectionPool ccp, String connectionDefinitionName, String rarName, ElementProperty[] props, SecurityMap[] securityMaps) throws ConnectorRuntimeException {
        ConnectorRegistry _registry = ConnectorRegistry.getInstance();
        ConnectorDescriptor connectorDescriptor = _registry.getDescriptor(rarName);
        if (connectorDescriptor == null) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to get connection pool object");
            _logger.log(Level.SEVERE, "rardeployment.connector_descriptor_notfound_registry", rarName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        Set connectionDefs = connectorDescriptor.getOutboundResourceAdapter().getConnectionDefs();
        ConnectionDefDescriptor cdd = null;
        Iterator it = connectionDefs.iterator();
        while (it.hasNext() && !connectionDefinitionName.equals((cdd = (ConnectionDefDescriptor)it.next()).getConnectionFactoryIntf())) {
        }
        ConnectorDescriptorInfo cdi = new ConnectorDescriptorInfo();
        cdi.setRarName(rarName);
        cdi.setResourceAdapterClassName(connectorDescriptor.getResourceAdapterClass());
        cdi.setConnectionDefinitionName(cdd.getConnectionFactoryIntf());
        cdi.setManagedConnectionFactoryClass(cdd.getManagedConnectionFactoryImpl());
        cdi.setConnectionFactoryClass(cdd.getConnectionFactoryImpl());
        cdi.setConnectionFactoryInterface(cdd.getConnectionFactoryIntf());
        cdi.setConnectionClass(cdd.getConnectionImpl());
        cdi.setConnectionInterface(cdd.getConnectionIntf());
        Set mergedProps = this.mergeProps(props, cdd.getConfigProperties(), rarName);
        cdi.setMCFConfigProperties(mergedProps);
        cdi.setResourceAdapterConfigProperties(connectorDescriptor.getConfigProperties());
        ccp.setConnectorDescriptorInfo(cdi);
        ccp.setSecurityMaps(SecurityMapUtils.getConnectorSecurityMaps(securityMaps));
    }

    private Set mergeProps(ElementProperty[] props, Set defaultMCFProps, String rarName) {
        int i;
        HashSet<Object> mergedSet = new HashSet<Object>();
        Object[] defaultProps = defaultMCFProps == null ? new Object[]{} : defaultMCFProps.toArray();
        for (i = 0; i < defaultProps.length; ++i) {
            EnvironmentProperty ep1;
            if (rarName.trim().equals("jmsra") && (ep1 = (EnvironmentProperty)defaultProps[i]).getName().equals("AddressList") && ep1.getValue().equals("localhost")) continue;
            mergedSet.add(defaultProps[i]);
        }
        for (i = 0; i < props.length; ++i) {
            if (props[i] == null) continue;
            EnvironmentProperty ep = new EnvironmentProperty(props[i].getName(), props[i].getValue(), null);
            if (defaultMCFProps.contains(ep)) {
                mergedSet.remove(ep);
            }
            mergedSet.add(ep);
        }
        return mergedSet;
    }

    private boolean isTxSupportConfigurationSane(int txSupport, String raName) {
        int raXmlTxSupport = -1;
        try {
            raXmlTxSupport = ConnectionPoolObjectsUtils.getTransactionSupportFromRaXml(raName);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, e.getMessage() != null ? e.getMessage() : "  ");
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "isTxSupportConfigSane:: txSupport => " + txSupport + "  raXmlTxSupport => " + raXmlTxSupport);
        }
        return txSupport <= raXmlTxSupport;
    }

    private int parseTransactionSupportString(String txSupport) {
        return ConnectionPoolObjectsUtils.parseTransactionSupportString(txSupport);
    }

    public void convertElementPropertyToPoolProperty(com.sun.enterprise.connectors.ConnectorConnectionPool ccp, ConnectorConnectionPool domainCcp) {
        ElementProperty[] elemProps = domainCcp.getElementProperty();
        if (elemProps == null) {
            return;
        }
        for (ElementProperty ep : elemProps) {
            if (ep == null) continue;
            if ("MATCHCONNECTIONS".equals(ep.getName().toUpperCase())) {
                domainCcp.removeElementProperty(ep);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(" ConnectorConnectionPoolDeployer::  Setting matchConnections");
                }
                ccp.setMatchConnections(this.toBoolean(ep.getValue(), true));
                continue;
            }
            if ("LAZYCONNECTIONASSOCIATION".equals(ep.getName().toUpperCase())) {
                ConnectionPoolObjectsUtils.setLazyEnlistAndLazyAssocProperties(ep.getValue(), domainCcp, ccp);
                boolean assoc = this.toBoolean(ep.getValue(), false);
                _logger.log(Level.FINE, "ccp_deployer.lazy_con_assoc_value", new Object[]{ccp.getName(), String.valueOf(assoc)});
                continue;
            }
            if (!"LAZYCONNECTIONENLISTMENT".equals(ep.getName().toUpperCase())) continue;
            boolean enlist = this.toBoolean(ep.getValue(), false);
            ccp.setLazyConnectionEnlist(enlist);
            _logger.log(Level.FINE, "ccp_deployer.lazy_con_enlist_value", new Object[]{ccp.getName(), String.valueOf(enlist)});
        }
    }

    private boolean toBoolean(Object prop, boolean defaultVal) {
        if (prop == null) {
            return defaultVal;
        }
        return Boolean.valueOf((String)prop);
    }

    private boolean isAuthCredentialsDefinedInPool(ConnectorConnectionPool domainCcp) {
        ElementProperty[] elemProps = domainCcp.getElementProperty();
        if (elemProps == null) {
            return false;
        }
        for (int i = 0; i < elemProps.length; ++i) {
            ElementProperty ep = elemProps[i];
            if (!ep.getName().equalsIgnoreCase("UserName") && !ep.getName().equalsIgnoreCase("User") && !ep.getName().equalsIgnoreCase("Password")) continue;
            return true;
        }
        return false;
    }
}

