/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.appserv.server.ServerLifecycleException;
import com.sun.appserv.server.ServerLifecycleImpl;
import com.sun.enterprise.J2EESecurityManager;
import com.sun.enterprise.security.PolicyLoader;
import com.sun.enterprise.security.RealmConfig;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.security.audit.AuditManagerFactory;
import com.sun.enterprise.security.authorize.PolicyContextHandlerImpl;
import com.sun.enterprise.security.jmac.config.GFAuthConfigFactory;
import com.sun.enterprise.server.ServerContext;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.security.Security;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;

public class SecurityLifecycle
extends ServerLifecycleImpl {
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.security");

    public SecurityLifecycle() {
        try {
            SecurityManager secMgr = System.getSecurityManager();
            if (secMgr != null && !J2EESecurityManager.class.equals(secMgr.getClass())) {
                J2EESecurityManager mgr = new J2EESecurityManager();
                System.setSecurityManager(mgr);
            }
            if (_logger.isLoggable(Level.INFO)) {
                if (secMgr != null) {
                    _logger.info("security.secmgron");
                } else {
                    _logger.info("security.secmgroff");
                }
            }
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "java_security.init_securitylifecycle_fail", ex);
            throw new RuntimeException(ex.toString(), ex);
        }
    }

    public void onInitialization(ServerContext sc) throws ServerLifecycleException {
        try {
            SSLUtils.initStoresAtStartup();
            this.initializeJMAC();
            this.registerPolicyHandlers();
            PolicyLoader policyLoader = PolicyLoader.getInstance();
            policyLoader.loadPolicy();
            RealmConfig.createRealms();
            AuditManagerFactory amf = AuditManagerFactory.getInstance();
            amf.getAuditManagerInstance().loadAuditModules();
        }
        catch (Exception ex) {
            throw new ServerLifecycleException(ex);
        }
    }

    private void initializeJMAC() throws IOException {
        String defaultFactory = Security.getProperty("authconfigprovider.factory");
        if (defaultFactory == null) {
            Security.setProperty("authconfigprovider.factory", GFAuthConfigFactory.class.getName());
        }
    }

    private void registerPolicyHandlers() throws PolicyContextException {
        PolicyContextHandler pch = PolicyContextHandlerImpl.getInstance();
        PolicyContext.registerHandler("javax.ejb.EnterpriseBean", pch, true);
        PolicyContext.registerHandler("javax.security.auth.Subject.container", pch, true);
        PolicyContext.registerHandler("javax.ejb.arguments", pch, true);
        PolicyContext.registerHandler("javax.xml.soap.SOAPMessage", pch, true);
        PolicyContext.registerHandler("javax.servlet.http.HttpServletRequest", pch, true);
        PolicyContext.registerHandler("java.security.Policy.supportsReuse", pch, true);
    }
}

