/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.ejb.Container;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbDescriptor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;

public final class ApplicationRegistry {
    protected Hashtable appID2ClassLoader = new Hashtable();
    protected Hashtable moduleID2ClassLoader = new Hashtable();
    protected Hashtable classLoader2Application;
    protected Hashtable descriptor2Container = new Hashtable();
    private HashSet uniqueIds;
    private static ApplicationRegistry _instance = new ApplicationRegistry();

    public static ApplicationRegistry getInstance() {
        return _instance;
    }

    private ApplicationRegistry() {
        this.classLoader2Application = new Hashtable();
        this.uniqueIds = new HashSet();
    }

    public Container getContainer(EjbDescriptor desc) {
        return (Container)this.descriptor2Container.get(desc);
    }

    public Application getApplication(ClassLoader loader) {
        return (Application)this.classLoader2Application.get(loader);
    }

    public ClassLoader getClassLoaderForApplication(String appID) {
        return (ClassLoader)this.appID2ClassLoader.get(appID);
    }

    public ClassLoader getClassLoaderForModule(String moduleID) {
        return (ClassLoader)this.moduleID2ClassLoader.get(moduleID);
    }

    void addDescriptor2Container(EjbDescriptor desc, Container container) {
        this.descriptor2Container.put(desc, container);
    }

    void addAppId2ClassLoader(String appID, ClassLoader classLoader) {
        this.appID2ClassLoader.put(appID, classLoader);
    }

    void addModuleId2ClassLoader(String moduleID, ClassLoader classLoader) {
        this.moduleID2ClassLoader.put(moduleID, classLoader);
    }

    void addClassLoader2Application(ClassLoader classLoader, Application app) {
        this.classLoader2Application.put(classLoader, app);
    }

    Container removeDescriptor2Container(EjbDescriptor desc) {
        return (Container)this.descriptor2Container.remove(desc);
    }

    ClassLoader removeAppId2ClassLoader(String appID) {
        return (ClassLoader)this.appID2ClassLoader.remove(appID);
    }

    ClassLoader removeModuleId2ClassLoader(String moduleID) {
        return (ClassLoader)this.moduleID2ClassLoader.remove(moduleID);
    }

    Application removeClassLoader2Application(ClassLoader cl) {
        return (Application)this.classLoader2Application.remove(cl);
    }

    boolean isUnique(long uniqueId) {
        return this.uniqueIds.add(new Long(uniqueId));
    }

    boolean removeUniqueId(long uniqueId) {
        return this.uniqueIds.remove(new Long(uniqueId));
    }

    Collection getAllEjbContainers() {
        Collection containers = null;
        if (this.descriptor2Container != null) {
            containers = this.descriptor2Container.values();
        }
        return containers;
    }
}

