/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.appserv.server.util.ASURLClassLoader;
import com.sun.appserv.server.util.ClassLoaderChain;
import com.sun.enterprise.util.ASenvPropertyReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PELaunch {
    private static final long START_TIME_MILLIS = System.currentTimeMillis();
    public static final String USE_NEW_CLASSLOADER_PROPERTY = "com.sun.aas.useNewClassLoader";
    public static final String PROPERTIES_FILES = "processLauncher.properties";
    private static final String CLASSPATH_PREFIX_PROPERTY = "com.sun.aas.ClassPathPrefix";
    private static final String CLASSPATH_SUFFIX_PROPERTY = "com.sun.aas.ClassPathSuffix";
    private static final String SERVER_CLASSPATH_PROPERTY = "com.sun.aas.ServerClassPath";
    private static final String fileSeparator = File.separator;
    private static final String pathSeparator = File.pathSeparator;
    private static final String installRoot = System.getProperty("com.sun.aas.installRoot");
    private static final List<String> _appserverClasspath = new ArrayList<String>();
    private static final List<String> _sharedClasspath = new ArrayList<String>();
    private static final List<String> _optionalClasspath = new ArrayList<String>();
    private static volatile ASURLClassLoader _sharedClassLoader = null;
    private static volatile ClassLoaderChain _optionalChain = null;
    private static volatile ClassLoaderChain _asChain = null;
    private static final Map<String, ASURLClassLoader> addonsMap = new HashMap<String, ASURLClassLoader>();
    private static final Map<String, List<String>> addOnsManifestsMap = new HashMap<String, List<String>>();
    private static volatile ClassLoaderChain _addOnsChain = null;
    private static final boolean bDebug = new Boolean(System.getProperty("com.sun.aas.useNewClassLoader.debug", "false"));

    public static long getStartTimeMillis() {
        return START_TIME_MILLIS;
    }

    public static ClassLoader getSharedChain() {
        return _sharedClassLoader;
    }

    public static ClassLoader getOptionalChain() {
        return _optionalChain;
    }

    public static ClassLoader getAppServerChain() {
        return _asChain;
    }

    public static synchronized List<String> getAddOnsClasspath() {
        ArrayList<String> s = new ArrayList<String>();
        for (List<String> lst : addOnsManifestsMap.values()) {
            s.addAll(lst);
        }
        PELaunch.logFine("addons classpath : " + s);
        return Collections.unmodifiableList(s);
    }

    private static synchronized List<String> _getSharedClasspathInternal() {
        if (_sharedClasspath.size() == 0) {
            PELaunch.initialiseSharedClasspath();
            assert (_sharedClasspath.size() != 0);
        }
        return _sharedClasspath;
    }

    public static synchronized List<String> getSharedClasspath() {
        return Collections.unmodifiableList(_sharedClasspath);
    }

    private static void initialiseSharedClasspath() {
        String asLib = installRoot + fileSeparator + "lib" + fileSeparator;
        String sharedJarsList = System.getProperty("com.sun.aas.classloader.sharedChainJars");
        if (PELaunch.isEE()) {
            String eeSharedJarsList = System.getProperty("com.sun.aas.classloader.sharedChainJars.ee");
            sharedJarsList = sharedJarsList + "," + eeSharedJarsList;
        }
        PELaunch.logFine("shared jar list " + sharedJarsList);
        List<String> shr = PELaunch.getLibraryList(asLib, sharedJarsList);
        String prefixString = System.getProperty(CLASSPATH_PREFIX_PROPERTY);
        PELaunch.logFine(" prefixString " + prefixString);
        String[] classpathPrefix = null;
        if (!PELaunch.isEmpty(prefixString)) {
            classpathPrefix = prefixString.split("" + File.pathSeparatorChar);
        }
        String suffixString = System.getProperty(CLASSPATH_SUFFIX_PROPERTY);
        PELaunch.logFine(" suffixString " + suffixString);
        String[] classpathSuffix = null;
        if (!PELaunch.isEmpty(suffixString)) {
            classpathSuffix = suffixString.split("" + File.pathSeparatorChar);
        }
        String serverClassPathString = System.getProperty(SERVER_CLASSPATH_PROPERTY);
        PELaunch.logFine(" serverClassPathString " + serverClassPathString);
        String[] serverClassPath = null;
        if (!PELaunch.isEmpty(serverClassPathString)) {
            serverClassPath = serverClassPathString.split("" + File.pathSeparatorChar);
        }
        if (classpathPrefix != null) {
            _sharedClasspath.addAll(Arrays.asList(classpathPrefix));
        }
        _sharedClasspath.addAll(shr);
        if (serverClassPath != null) {
            _sharedClasspath.addAll(Arrays.asList(serverClassPath));
        }
        if (classpathSuffix != null) {
            _sharedClasspath.addAll(Arrays.asList(classpathSuffix));
        }
    }

    private static List<String> getAppServerClasspath() {
        return Collections.unmodifiableList(_appserverClasspath);
    }

    private static List<String> getOptionalClasspath() {
        return Collections.unmodifiableList(_optionalClasspath);
    }

    public static synchronized List<String> getServerClasspath() {
        String asLib = installRoot + fileSeparator + "lib" + fileSeparator;
        String serverJarsList = System.getProperty("com.sun.aas.classloader.serverClassPath");
        if (PELaunch.isEE()) {
            String eeServerJarsList = System.getProperty("com.sun.aas.classloader.serverClassPath.ee");
            serverJarsList = serverJarsList + "," + eeServerJarsList;
        }
        PELaunch.logFine("serverClassPathJarsList " + serverJarsList);
        List<String> serverClasspathList = PELaunch.getLibraryList(asLib, serverJarsList);
        return serverClasspathList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static List<String> getManifestAddonJars() {
        ArrayList<String> manifestJars;
        block20: {
            File libAddonDirectory;
            String addonDir;
            ZipFile file;
            block18: {
                manifestJars = new ArrayList<String>();
                file = null;
                addonDir = installRoot + fileSeparator + "lib" + fileSeparator + "addons";
                libAddonDirectory = new File(addonDir);
                if (libAddonDirectory.isDirectory()) break block18;
                ArrayList<String> arrayList = manifestJars;
                Object var16_7 = null;
                try {
                    if (file != null) {
                        file.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
                return arrayList;
            }
            File[] fileArray = libAddonDirectory.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                String classPath;
                String addonJar = fileArray[i].getName();
                String addOnName = "";
                String jarExtension = "";
                int dotLastIndex = addonJar.lastIndexOf(".");
                if (dotLastIndex != -1) {
                    jarExtension = addonJar.substring(dotLastIndex + 1);
                    addOnName = addonJar.substring(0, dotLastIndex - 1);
                }
                if (!jarExtension.equalsIgnoreCase("jar")) continue;
                manifestJars.add(fileArray[i].getAbsolutePath());
                PELaunch.updateAddOnManifests(addOnName, fileArray[i].getAbsolutePath());
                file = new JarFile(fileArray[i].getAbsolutePath());
                Manifest mf = ((JarFile)file).getManifest();
                Attributes attributes = null;
                if (mf == null) continue;
                attributes = mf.getMainAttributes();
                if (attributes != null && (classPath = attributes.getValue(Attributes.Name.CLASS_PATH)) != null && !classPath.trim().equals("")) {
                    StringTokenizer stoken = new StringTokenizer(classPath);
                    while (stoken.hasMoreTokens()) {
                        String classPathJar = addonDir + fileSeparator + stoken.nextElement();
                        manifestJars.add(classPathJar);
                        PELaunch.updateAddOnManifests(addOnName, classPathJar);
                    }
                }
                file.close();
            }
            Object var16_8 = null;
            try {
                if (file != null) {
                    file.close();
                }
                break block20;
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
            break block20;
            {
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    Object var16_9 = null;
                    try {
                        if (file != null) {
                            file.close();
                        }
                        break block20;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(System.err);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var16_10 = null;
                try {
                    if (file != null) {
                        file.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
                throw throwable;
            }
        }
        return manifestJars;
    }

    public static synchronized void uninstallAddon(String addonName) {
        PELaunch.logFine("Uninstalling addon " + addonName);
        _addOnsChain.removeFromList(addonsMap.get(addonName));
        PELaunch.logFine("removed addonclassloader " + addonsMap.get(addonName) + " for " + addonName);
    }

    private static void updateAddOnManifests(String addOnName, String addonJarPath) {
        PELaunch.logFine("updateAddOnManifests: adding " + addonJarPath + " for " + addOnName);
        ArrayList<String> al = null;
        ArrayList<String> tmp = addOnsManifestsMap.get(addOnName);
        al = tmp != null ? tmp : new ArrayList<String>();
        al.add(addonJarPath);
        addOnsManifestsMap.put(addOnName, al);
    }

    public static void main(String[] args) {
        try {
            Class<?> peMainClass = null;
            if (Boolean.getBoolean(USE_NEW_CLASSLOADER_PROPERTY)) {
                ASenvPropertyReader reader = new ASenvPropertyReader(System.getProperty("com.sun.aas.configRoot"), false);
                reader.setSystemProperties();
                PELaunch.setupClassloaders();
                peMainClass = _asChain.loadClass("com.sun.enterprise.server.PEMain", true);
                Thread.currentThread().setContextClassLoader(_asChain);
            } else {
                peMainClass = Class.forName("com.sun.enterprise.server.PEMain");
            }
            Class[] argTypes = new Class[]{String[].class};
            Method m = peMainClass.getMethod("main", argTypes);
            Object[] argListForInvokedMain = new Object[]{args};
            m.invoke(null, argListForInvokedMain);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private static synchronized void setupClassloaders() {
        PELaunch.prepareAppServerJars();
        PELaunch.initOptionalOverrideableJars();
        PELaunch.appendOtherJarsToSharedChain();
        PELaunch.setupSharedChain();
        PELaunch.setupAddOnChain();
        PELaunch.setupOptionalOverrideableChain();
        PELaunch.setupAppServerChain();
        List<String> cp = PELaunch._getSharedClasspathInternal();
        String oldcp = System.getProperty("java.class.path");
        StringBuilder classpath = null;
        classpath = oldcp != null ? new StringBuilder(oldcp + pathSeparator) : new StringBuilder();
        for (String s : cp) {
            classpath.append(s);
            classpath.append(pathSeparator);
        }
        System.setProperty("java.class.path", classpath.toString());
    }

    private static void setupAddOnChain() {
        PELaunch.logFine("setting up addon chain");
        _addOnsChain = new ClassLoaderChain(_sharedClassLoader);
        _addOnsChain.setName("Addons Chain");
        PELaunch.getManifestAddonJars();
        for (String addOnName : addOnsManifestsMap.keySet()) {
            URL[] addOnURLs = PELaunch.getURLList(addOnsManifestsMap.get(addOnName));
            PELaunch.logFine(" addon: " + addOnName + " urls: " + addOnURLs);
            ASURLClassLoader addonClassLoader = new ASURLClassLoader(addOnURLs, (ClassLoader)_sharedClassLoader);
            addonsMap.put(addOnName, addonClassLoader);
            _addOnsChain.addToList(addonClassLoader);
        }
    }

    public static List<String> getServerClassPath(String configDir, String domainDir) {
        File[] domainfls;
        File f;
        File[] fls;
        ASenvPropertyReader reader = new ASenvPropertyReader(configDir, false);
        reader.setSystemProperties();
        String asLib = installRoot + fileSeparator;
        ArrayList<String> serverClassPathList = new ArrayList<String>();
        for (File element : fls = PELaunch.getAllLibrariesInLib(asLib)) {
            serverClassPathList.add(element.getAbsolutePath());
        }
        String mqlib = System.getProperty("com.sun.aas.imqLib");
        String antlib = System.getProperty("com.sun.aas.antLib");
        String jdmklib = System.getProperty("com.sun.aas.jdmkHome");
        String hadbRoot = System.getProperty("com.sun.aas.hadbRoot");
        String[] peServerClassPath = new String[]{installRoot + "/lib/install/applications/jmsra/imqjmsra.jar", mqlib + "/jaxm-api.jar", mqlib + "/fscontext.jar", mqlib + "/imqbroker.jar", mqlib + "/imqjmx.jar", mqlib + "/imqxm.jar", antlib + "/ant.jar", jdmklib + "/lib/jdmkrt.jar"};
        String[] eeServerClassPath = new String[]{hadbRoot + "/lib/hadbjdbc4.jar", jdmklib + "/lib/jdmkrt.jar", hadbRoot + "/lib/dbstate.jar", hadbRoot + "/lib/hadbm.jar", hadbRoot + "/lib/hadbmgt.jar"};
        for (String element : peServerClassPath) {
            f = new File(element);
            if (!f.exists()) continue;
            serverClassPathList.add(f.getAbsolutePath());
        }
        for (String element : eeServerClassPath) {
            f = new File(element);
            if (!f.exists()) continue;
            serverClassPathList.add(f.getAbsolutePath());
        }
        for (File elt : domainfls = PELaunch.getAllLibrariesInLib(domainDir + fileSeparator)) {
            serverClassPathList.add(elt.getAbsolutePath());
        }
        PELaunch.logFine("Server Classpath for verifier " + serverClassPathList + "\n");
        Logger.getAnonymousLogger().log(Level.FINE, "Server Classpath for verifier " + serverClassPathList);
        return serverClassPathList;
    }

    private static void setupSharedChain() {
        List<String> sharedChainJarList = PELaunch._getSharedClasspathInternal();
        PELaunch.logFine("shared classpath jars : " + sharedChainJarList + "\n");
        URL[] urls = PELaunch.getURLList(sharedChainJarList);
        PELaunch.logFine(" SharedChain URL List " + urls);
        _sharedClassLoader = new ASURLClassLoader(urls, ClassLoader.getSystemClassLoader());
        _sharedClassLoader.setName("Shared ClassLoader Chain");
    }

    private static void setupOptionalOverrideableChain() {
        _optionalChain = new ClassLoaderChain(_addOnsChain);
        _optionalChain.setName("optionalChain");
        URL[] urls = PELaunch.getURLList(_optionalClasspath);
        ASURLClassLoader optionalJarsLoader = new ASURLClassLoader(urls, (ClassLoader)_addOnsChain);
        _optionalChain.addToList(optionalJarsLoader);
    }

    private static void initOptionalOverrideableJars() {
        String asLib = installRoot + fileSeparator + "lib" + fileSeparator;
        String optionalJarsString = System.getProperty("com.sun.aas.classloader.optionalOverrideableChain");
        if (PELaunch.isEE()) {
            String eeOptionalJarsList = System.getProperty("com.sun.aas.classloader.optionalOverrideableChain.ee");
            optionalJarsString = optionalJarsString + "," + eeOptionalJarsList;
        }
        PELaunch.logFine(" optionalOverrideableChain" + optionalJarsString);
        PELaunch.updateClasspathList(asLib, optionalJarsString, _optionalClasspath);
        PELaunch.logFine("Optional overrideable chain classpath : " + _optionalClasspath + "\n");
    }

    private static void setupAppServerChain() {
        URL[] urls = PELaunch.getURLList(_appserverClasspath);
        _asChain = new ClassLoaderChain(_addOnsChain);
        _asChain.setName("ASChain");
        ASURLClassLoader asimplloader = new ASURLClassLoader(urls, (ClassLoader)_asChain);
        asimplloader.setName("asimpl");
        _asChain.addToList(asimplloader);
        _asChain.addToList(_optionalChain);
    }

    private static void prepareAppServerJars() {
        String asLib = installRoot + fileSeparator + "lib" + fileSeparator;
        String appserverJarsStr = System.getProperty("com.sun.aas.classloader.appserverChainJars");
        if (PELaunch.isEE()) {
            String eeAppserverJarsList = System.getProperty("com.sun.aas.classloader.appserverChainJars.ee");
            appserverJarsStr = appserverJarsStr + "," + eeAppserverJarsList;
        }
        PELaunch.logFine("appserverJarsString " + appserverJarsStr);
        PELaunch.updateClasspathList(asLib, appserverJarsStr, _appserverClasspath);
        PELaunch.logFine("Application server classpath : " + _appserverClasspath + "\n");
    }

    private static boolean isEE() {
        boolean isEE = false;
        String eepffc = "com.sun.enterprise.ee.server.pluggable.EEPluggableFeatureImpl";
        String pn = "com.sun.appserv.pluggable.features";
        String pv = System.getProperty("com.sun.appserv.pluggable.features");
        if ("com.sun.enterprise.ee.server.pluggable.EEPluggableFeatureImpl".equals(pv)) {
            isEE = true;
        }
        return isEE;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    private static List<String> updateClasspathList(String libraryRoot, String librariesList, List<String> classpathAddressList) {
        String[] libList;
        for (String library : libList = librariesList.split(",")) {
            File file = new File(library = library.trim());
            if (!file.isAbsolute()) {
                classpathAddressList.add(libraryRoot + library);
                continue;
            }
            classpathAddressList.add(library);
        }
        return classpathAddressList;
    }

    private static List<String> getLibraryList(String libraryRoot, String librariesString) {
        return PELaunch.updateClasspathList(libraryRoot, librariesString, new ArrayList<String>());
    }

    private static URL[] getURLList(List<String> librariesList) {
        int i = 0;
        String[] sharedJars = librariesList.toArray(new String[0]);
        URL[] urls = new URL[sharedJars.length];
        for (String s : sharedJars) {
            try {
                URL url = new File(s).toURI().toURL();
                PELaunch.logFine(s + " exists ? " + new File(s).exists());
                urls[i++] = url;
            }
            catch (MalformedURLException e) {
                Logger.getAnonymousLogger().warning(e.getMessage());
                Logger.getAnonymousLogger().log(Level.WARNING, "Exception whilesetting up shared chain", e);
            }
        }
        return urls;
    }

    private static void logFine(String s) {
        if (bDebug) {
            System.err.println(s);
        }
    }

    private static void appendOtherJarsToSharedChain() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(PELaunch._getSharedClasspathInternal());
        list.addAll(PELaunch.getAppServerClasspath());
        list.addAll(PELaunch.getOptionalClasspath());
        File[] files = PELaunch.getAllLibrariesInLib(installRoot);
        String excludesListString = System.getProperty("com.sun.aas.classloader.excludesList", "");
        List<String> excludesList = PELaunch.getLibraryList(installRoot + fileSeparator + "lib" + fileSeparator, excludesListString);
        for (File file : files) {
            try {
                if (!list.contains(file.getCanonicalPath()) && !PELaunch.isInExcludesList(excludesList, file)) {
                    PELaunch._getSharedClasspathInternal().add(file.getCanonicalPath());
                    PELaunch.logFine("appendOtherJarsToSharedChain - added " + file.getCanonicalPath());
                    continue;
                }
                PELaunch.logFine("appendOtherJarsToSharedChain - not adding " + file.getCanonicalPath());
                PELaunch.logFine(file.getCanonicalPath() + " exists in list ? " + list.contains(file.getCanonicalPath()));
                PELaunch.logFine(file.getCanonicalPath() + "in excludes list ? " + PELaunch.isInExcludesList(excludesList, file));
            }
            catch (IOException ioe) {
                System.err.println("Error getting " + file.getAbsolutePath() + " " + ioe.getMessage());
            }
        }
        String includesListString = System.getProperty("com.sun.aas.classloader.includesList", "");
        List<String> includesList = PELaunch.getLibraryList(installRoot, includesListString);
        for (String f : includesList) {
            if (_sharedClasspath.contains(f)) continue;
            PELaunch.logFine("appendOtherJarsToSharedChain - adding " + f + " via includes");
            _sharedClasspath.add(f);
        }
    }

    private static boolean isInExcludesList(List<String> excludesList, File f) throws IOException {
        return excludesList.contains(f.getCanonicalPath());
    }

    private static File[] getAllLibrariesInLib(String asLib) {
        File installLib = new File(asLib, "lib");
        File[] files = installLib.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") || name.endsWith(".zip");
            }
        });
        return files;
    }

    static {
        if (System.getProperty(USE_NEW_CLASSLOADER_PROPERTY) == null) {
            System.setProperty(USE_NEW_CLASSLOADER_PROPERTY, "true");
        }
    }
}

