/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.loader.InstrumentableClassLoader;
import com.sun.enterprise.server.PersistenceUnitInfoImpl;
import com.sun.enterprise.server.PersistenceUnitLoader;
import com.sun.logging.LogDomains;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitLoaderImpl
implements PersistenceUnitLoader {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");
    private String applicationLocation;
    private InstrumentableClassLoader classLoader;
    private Application application;
    private static Map<String, String> integrationProperties;

    @Override
    public void load(PersistenceUnitLoader.ApplicationInfo appInfo) {
        this.application = appInfo.getApplication();
        this.applicationLocation = appInfo.getApplicationLocation();
        this.classLoader = appInfo.getClassLoader();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loading persistence units for application: " + this.applicationLocation);
        }
        for (PersistenceUnitDescriptor persistenceUnitDescriptor : appInfo.getReferencedPUs()) {
            this.load(persistenceUnitDescriptor);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Finished loading persistence units for application: " + this.applicationLocation);
        }
    }

    @Override
    public void unload(PersistenceUnitLoader.ApplicationInfo appInfo) {
        this.application = appInfo.getApplication();
        this.applicationLocation = appInfo.getApplicationLocation();
        this.classLoader = appInfo.getClassLoader();
        boolean fineMsgLoggable = logger.isLoggable(Level.FINE);
        if (fineMsgLoggable) {
            logger.fine("Unloading persistence units for application: " + this.applicationLocation);
        }
        this.closeEMFs(appInfo.getEntityManagerFactories());
        if (fineMsgLoggable) {
            logger.fine("Finished unloading persistence units for application: " + this.applicationLocation);
        }
    }

    private void load(PersistenceUnitDescriptor pud) {
        PersistenceProvider provider;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("loading pud " + pud.getPuRoot());
        }
        PersistenceUnitInfoImpl pInfo = new PersistenceUnitInfoImpl(pud, this.applicationLocation, this.classLoader);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("PersistenceInfo for this pud is :\n" + pInfo);
        }
        try {
            provider = (PersistenceProvider)PersistenceProvider.class.cast(((ClassLoader)ClassLoader.class.cast(this.classLoader)).loadClass(pInfo.getPersistenceProviderClassName()).newInstance());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        EntityManagerFactory emf = provider.createContainerEntityManagerFactory(pInfo, integrationProperties);
        logger.logp(Level.FINE, "PersistenceUnitLoaderImpl", "load", "emf = {0}", emf);
        RootDeploymentDescriptor rootDD = pud.getParent().getParent();
        if (rootDD.isApplication()) {
            ((Application)Application.class.cast(rootDD)).addEntityManagerFactory(pInfo.getPersistenceUnitName(), pud.getPuRoot(), emf);
        } else {
            ((BundleDescriptor)BundleDescriptor.class.cast(rootDD)).addEntityManagerFactory(pInfo.getPersistenceUnitName(), emf);
        }
    }

    private void closeEMFs(Collection<? extends EntityManagerFactory> entityManagerFactories) {
        logger.logp(Level.FINE, "PersistenceUnitLoaderImpl", "closeEMFs", "entityManagerFactories.size() = {0}", entityManagerFactories.size());
        for (EntityManagerFactory entityManagerFactory : entityManagerFactories) {
            try {
                logger.logp(Level.FINE, "PersistenceUnitLoaderImpl", "closeEMFs", "emf = {0}", entityManagerFactory);
                entityManagerFactory.close();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    static {
        HashMap<String, String> props = new HashMap<String, String>();
        String TOPLINK_SERVER_PLATFORM_CLASS_NAME_PROPERTY = "toplink.target-server";
        props.put("toplink.target-server", System.getProperty("toplink.target-server", "oracle.toplink.essentials.platform.server.sunas.SunAS9ServerPlatform"));
        String TOPLINK_DDL_GENERATION_MODE_PROPERTY = "toplink.ddl-generation.output-mode";
        props.put("toplink.ddl-generation.output-mode", System.getProperty("toplink.ddl-generation.output-mode", "none"));
        String HIBERNATE_TRANSACTION_MANAGER_LOOKUP_CLASS_PROPERTY = "hibernate.transaction.manager_lookup_class";
        props.put("hibernate.transaction.manager_lookup_class", System.getProperty("hibernate.transaction.manager_lookup_class", "org.hibernate.transaction.SunONETransactionManagerLookup"));
        integrationProperties = Collections.unmodifiableMap(props);
    }
}

