/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.AdminEventListenerRegistry;
import com.sun.enterprise.admin.event.DeployEventListenerHelper;
import com.sun.enterprise.admin.event.ModuleDeployEvent;
import com.sun.enterprise.admin.event.ModuleDeployEventListener;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.autodeploy.AutoDirReDeployer;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.backend.DeploymentCommand;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.instance.EjbModulesManager;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.server.AbstractLoader;
import com.sun.enterprise.server.AbstractManager;
import com.sun.enterprise.server.EJBModuleLoader;
import com.sun.enterprise.server.MonitorableEntry;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanException;

public class StandAloneEJBModulesManager
extends AbstractManager
implements ModuleDeployEventListener {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    private static StringManager localStrings = StringManager.getManager(StandAloneEJBModulesManager.class);

    StandAloneEJBModulesManager(EjbModulesManager ejbManager, ClassLoader parentClassLoader) {
        super(parentClassLoader, ejbManager);
        AdminEventListenerRegistry.addModuleDeployEventListener(this);
    }

    protected AbstractLoader getLoader(String moduleId) {
        return new EJBModuleLoader(moduleId, this.parentClassLoader, (EjbModulesManager)this.configManager);
    }

    private void holdRequest() {
    }

    private void holdRequest(String appID) {
    }

    public synchronized boolean reload(MonitorableEntry entry) {
        String moduleName = entry.getId();
        boolean status2 = false;
        try {
            DeploymentRequest req = new DeploymentRequest(this.configManager.getInstanceEnvironment(), DeployableObjectType.EJB, DeploymentCommand.DEPLOY);
            req.setFileSource(entry.getMonitoredFile().getParentFile());
            req.setName(moduleName);
            req.setForced(true);
            AutoDirReDeployer deployer = new AutoDirReDeployer(req);
            status2 = deployer.redeploy();
        }
        catch (IASDeploymentException de) {
            _logger.log(Level.WARNING, "core.error_in_reload_ejb_module", de);
            return false;
        }
        return status2;
    }

    private boolean moduleDeployed(boolean jsr77, String moduleName, ConfigContext dynamicConfigContext) {
        return this.moduleDeployed(jsr77, moduleName, true, dynamicConfigContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean moduleDeployed(boolean jsr77, String moduleName, boolean addToRM, ConfigContext dynamicConfigContext) {
        AbstractLoader modLoader;
        boolean result;
        block23: {
            result = false;
            boolean loadJSR77 = jsr77 || this.loadJSR77(moduleName, DeployableObjectType.EJB);
            modLoader = null;
            try {
                try {
                    modLoader = this.getLoader(moduleName);
                    modLoader.setConfigContext(dynamicConfigContext);
                    if (loadJSR77) {
                        try {
                            modLoader.createRootMBean();
                        }
                        catch (MBeanException mbe) {
                            _logger.log(Level.WARNING, "core.error_while_creating_jsr77_root_mbean", mbe);
                        }
                    }
                    if (this.isEnabled(dynamicConfigContext, moduleName)) {
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.log(Level.FINEST, "Loading enabled ejb module: " + moduleName);
                        }
                        if (this.id2loader.get(moduleName) != null) {
                            boolean mbe = true;
                            Object var11_14 = null;
                            if (modLoader == null) return mbe;
                            modLoader.setConfigContext(null);
                            return mbe;
                        }
                        try {
                            modLoader.setState(0);
                        }
                        catch (MBeanException mbe) {
                            _logger.log(Level.WARNING, "core.error_while_setting_jsr77_state", mbe);
                        }
                        boolean retSts = modLoader.load(jsr77);
                        if (retSts) {
                            this.id2loader.put(moduleName, modLoader);
                            if (addToRM) {
                                this.addToReloadMonitor(moduleName);
                            }
                            try {
                                modLoader.setState(1);
                            }
                            catch (MBeanException mbe) {
                                _logger.log(Level.WARNING, "core.error_while_setting_jsr77_state", mbe);
                            }
                            result = true;
                            break block23;
                        }
                        if (loadJSR77) {
                            try {
                                modLoader.deleteLeafAndRootMBeans();
                            }
                            catch (MBeanException mbe) {
                                _logger.log(Level.WARNING, "core.error_while_deleting_jsr77_root_and_leaf_mbeans", mbe);
                            }
                        } else {
                            try {
                                modLoader.setState(4);
                            }
                            catch (MBeanException mbe) {
                                _logger.log(Level.WARNING, "core.error_while_setting_jsr77_state", mbe);
                            }
                        }
                        _logger.log(Level.WARNING, "core.error_while_loading_ejb_module");
                        break block23;
                    }
                    _logger.log(Level.INFO, "core.ejb_module_disabled", moduleName);
                    result = false;
                }
                catch (ConfigException ce) {
                    _logger.log(Level.WARNING, "core.error_while_loading_ejb_module", ce);
                    result = false;
                    Object var11_16 = null;
                    if (modLoader == null) return result;
                    modLoader.setConfigContext(null);
                    return result;
                }
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                if (modLoader == null) throw throwable;
                modLoader.setConfigContext(null);
                throw throwable;
            }
        }
        Object var11_15 = null;
        if (modLoader == null) return result;
        modLoader.setConfigContext(null);
        return result;
    }

    private boolean moduleUnDeployed(String moduleName) {
        return this.moduleUnDeployed(false, moduleName);
    }

    private boolean moduleUnDeployed(boolean jsr77, String moduleName) {
        return this.moduleUnDeployed(jsr77, moduleName, true);
    }

    private boolean moduleUnDeployed(boolean jsr77, String moduleName, boolean clearRM) {
        EJBModuleLoader modLoader = (EJBModuleLoader)this.id2loader.remove(moduleName);
        if (clearRM) {
            this.removeFromReloadMonitor(moduleName);
        }
        if (modLoader == null) {
            return true;
        }
        try {
            modLoader.setState(2);
        }
        catch (MBeanException mbe) {
            _logger.log(Level.WARNING, "core.error_while_setting_jsr77_state", mbe);
        }
        Application app = modLoader.getApplication();
        RoleMapper.removeRoleMapper(app.getRoleMapper().getName());
        if (jsr77) {
            try {
                modLoader.deleteRootMBean();
            }
            catch (MBeanException mbe) {
                _logger.log(Level.WARNING, "core.error_while_deleting_jsr77_root_mbean", mbe);
            }
        } else {
            try {
                modLoader.setState(3);
            }
            catch (MBeanException mbe) {
                _logger.log(Level.WARNING, "core.error_while_setting_jsr77_state", mbe);
            }
        }
        boolean undeployed = modLoader.unload(jsr77);
        if (undeployed) {
            _logger.log(Level.INFO, "core.ejb_module_unload_successful", moduleName);
        } else {
            _logger.log(Level.INFO, "core.ejb_module_not_unloaded", moduleName);
        }
        return undeployed;
    }

    public synchronized void moduleDeployed(ModuleDeployEvent event) throws AdminEventListenerException {
        boolean jsr77 = false;
        if (event.getModuleTypeCode() == 2) {
            DeployEventListenerHelper.getDeployEventListenerHelper().synchronize(event);
            String modID = event.getModuleName();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "Deploying EJB Module: " + modID);
            }
            try {
                this.configManager.refreshConfigContext(event.getConfigContext());
                String action = event.getAction();
                if (action.equals("deploy") || action.equals("redeploy")) {
                    jsr77 = true;
                }
                if (this.isEnabled(event.getConfigContext(), modID) && !this.moduleDeployed(jsr77, modID, event.getConfigContext())) {
                    String msg = localStrings.getString("standaloneejbmodulesmgr.ejbmodule_deployed_failed", modID);
                    this.registerException(event, msg);
                }
            }
            catch (ConfigException ce) {
                throw new AdminEventListenerException(ce.getMessage());
            }
        }
    }

    public synchronized void moduleUndeployed(ModuleDeployEvent event) throws AdminEventListenerException {
        boolean jsr77 = false;
        String action = event.getAction();
        if (action.equals("undeploy") || action.equals("redeploy")) {
            jsr77 = true;
        }
        try {
            if (event.getModuleTypeCode() == 2) {
                String modID = event.getModuleName();
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "Undeploying EJB Module: " + modID);
                }
                this.configManager.refreshConfigContext(event.getOldConfigContext());
                boolean undeployed = this.moduleUnDeployed(jsr77, modID);
                if (!undeployed) {
                    String msg = localStrings.getString("standaloneejbmodulesmgr.ejbmodule_undeployed_failed", modID);
                    this.registerException(event, msg);
                }
            }
        }
        catch (ConfigException ce) {
            throw new AdminEventListenerException(ce.getMessage());
        }
    }

    public synchronized void moduleRedeployed(ModuleDeployEvent event) throws AdminEventListenerException {
        if (event.getModuleTypeCode() == 2) {
            String modID = event.getModuleName();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "Redeploying EJB Module: " + modID);
            }
            this.moduleUndeployed(event);
            this.moduleDeployed(event);
        }
    }

    public synchronized void moduleEnabled(ModuleDeployEvent event) throws AdminEventListenerException {
        if (event.getModuleTypeCode() == 2) {
            String modID = event.getModuleName();
            if (!this.isEnabled(event.getConfigContext(), modID)) {
                return;
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "Enabling EJB Module: " + modID);
            }
            this.moduleDeployed(event);
        }
    }

    public synchronized void moduleDisabled(ModuleDeployEvent event) throws AdminEventListenerException {
        if (event.getModuleTypeCode() == 2) {
            String modID = event.getModuleName();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "Disabling EJB Module: " + modID);
            }
            this.moduleUndeployed(event);
        }
    }

    public void moduleReferenceAdded(ModuleDeployEvent event) throws AdminEventListenerException {
    }

    public void moduleReferenceRemoved(ModuleDeployEvent event) throws AdminEventListenerException {
    }
}

