/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.deployment.autodeploy.AutoDirReDeployer;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.backend.DeploymentCommand;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.MonitorListener;
import com.sun.enterprise.server.MonitorableEntry;
import com.sun.enterprise.server.ReloadMonitor;
import com.sun.enterprise.server.StandAloneEJBModulesManager;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class StandaloneWebModulesManager
implements MonitorListener {
    ReloadMonitor reloadMonitor;
    private String _id = null;
    private String _modulesRoot = null;
    private ArrayList _reloadables = new ArrayList();
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    private static StringManager localStrings = StringManager.getManager(StandAloneEJBModulesManager.class);

    public StandaloneWebModulesManager(String id, String modulesRoot, long pollInterval) {
        this._id = id;
        this._modulesRoot = modulesRoot;
        this.start(pollInterval);
    }

    public void start(long pollInterval) {
        this.reloadMonitor = ReloadMonitor.getInstance(pollInterval * 1000L);
    }

    public void stop() {
        ReloadMonitor reloadMonitor = ReloadMonitor.getInstance(1L);
        for (int i = 0; i < this._reloadables.size(); ++i) {
            String id = (String)this._reloadables.get(i);
            reloadMonitor.removeMonitoredEntry(id);
        }
        this._reloadables.clear();
        this._reloadables = null;
    }

    public boolean reload(MonitorableEntry entry) {
        InstanceEnvironment ienv = ApplicationServer.getServerContext().getInstanceEnvironment();
        String moduleName = entry.getDisplayName();
        boolean status2 = false;
        try {
            DeploymentRequest req = new DeploymentRequest(ienv, DeployableObjectType.WEB, DeploymentCommand.DEPLOY);
            req.setFileSource(entry.getMonitoredFile().getParentFile());
            req.setName(moduleName);
            req.setForced(true);
            AutoDirReDeployer deployer = new AutoDirReDeployer(req);
            status2 = deployer.redeploy();
        }
        catch (IASDeploymentException de) {
            _logger.log(Level.WARNING, "core.error_in_reload_war_module", de);
            return false;
        }
        return status2;
    }

    public boolean deploy(MonitorableEntry entry, File archive) {
        return false;
    }

    public void addWebModule(WebModule wm) {
        if (wm != null && this.isEnabled(wm.getConfigContext(), wm.getName())) {
            String name = wm.getName();
            String id = name + "[" + this._id + "]";
            String fileName = this.getReloadFilename(wm);
            MonitorableEntry entry = new MonitorableEntry(id, name, new File(fileName), this);
            this._reloadables.add(id);
            this.reloadMonitor.addMonitorableEntry(entry);
        }
    }

    protected boolean isEnabled(ConfigContext config, String moduleName) {
        try {
            if (config == null) {
                config = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            }
            ConfigBean app = ApplicationHelper.findApplication(config, moduleName);
            Server server = ServerBeansFactory.getServerBean(config);
            ApplicationRef appRef = server.getApplicationRefByRef(moduleName);
            return app != null && app.isEnabled() && appRef != null && appRef.isEnabled();
        }
        catch (ConfigException e) {
            _logger.log(Level.FINE, "Error in finding " + moduleName, e);
            return false;
        }
    }

    public void addWebModules(WebModule[] modules) {
        if (modules != null && modules.length > 0) {
            for (int i = 0; i < modules.length; ++i) {
                this.addWebModule(modules[i]);
            }
        }
    }

    private String getReloadFilename(WebModule wm) {
        String path = wm.getLocation();
        File dir = new File(path);
        if (!dir.isAbsolute()) {
            path = this._modulesRoot + "/" + path;
        }
        return path + "/" + ".reload";
    }
}

