/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.ss.provider;

import com.sun.enterprise.server.ss.provider.ASChannel;
import com.sun.enterprise.server.ss.provider.ASServerSocket;
import com.sun.enterprise.server.ss.spi.ASSocketFacadeUtils;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.logging.Level;
import java.util.logging.Logger;

class ASServerSocketChannel
extends ServerSocketChannel
implements ASChannel {
    private static final Logger logger = LogDomains.getLogger("javax.enterprise.system.core");
    private ServerSocketChannel ssc = null;
    private ServerSocket ssocket = null;
    private int port = 0;

    ASServerSocketChannel(ServerSocketChannel ssc, SelectorProvider p) {
        super(p);
        this.ssc = ssc;
        this.port = ssc.socket().getLocalPort();
    }

    public ServerSocket socket() {
        try {
            if (this.ssocket == null) {
                ServerSocket ss = this.ssc.socket();
                this.ssocket = new ASServerSocket(ss, this);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.ssocket;
    }

    public SocketChannel accept() throws IOException {
        SocketChannel sc = this.ssc.accept();
        if (logger.isLoggable(Level.FINE)) {
            Socket s = sc.socket();
            logger.fine("In ASServerSocketChannel.accept got connection, s.port=" + s.getPort() + " s.localPort=" + s.getLocalPort());
        }
        ASSocketFacadeUtils.getASSocketService().waitOnAccept(sc);
        return sc;
    }

    public void implConfigureBlocking(boolean b) throws IOException {
        this.ssc.configureBlocking(b);
    }

    public void implCloseSelectableChannel() throws IOException {
        ASSocketFacadeUtils.getASSocketService().close(this.port, null, this.ssc);
    }

    public SelectableChannel getActualChannel() {
        return this.ssc;
    }

    void setPortNumber(int port) {
        this.port = port;
    }

    int getPortNumber() {
        return this.port;
    }

    void setServerSocketChannel(ServerSocketChannel ssc) {
        this.ssc = ssc;
    }

    public String toString() {
        return "ASServerSocketChannel[" + this.ssc.toString() + "]";
    }
}

