/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.stats;

import com.sun.enterprise.admin.monitor.stats.BoundedRangeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.MutableBoundedRangeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.util.i18n.StringManager;
import javax.management.j2ee.statistics.BoundedRangeStatistic;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.JVMStats;
import javax.management.j2ee.statistics.Statistic;

public class JVMStatsImpl
implements JVMStats {
    private final long initTime = System.currentTimeMillis();
    private GenericStatsImpl baseStatsImpl;
    private MutableCountStatistic uptime;
    private MutableBoundedRangeStatisticImpl heapSize;
    private static final String STATS_INTERFACE_NAME = "javax.management.j2ee.statistics.JVMStats";
    private static StringManager sm = StringManager.getManager(JVMStatsImpl.class);

    public JVMStatsImpl() {
        try {
            this.baseStatsImpl = new GenericStatsImpl(STATS_INTERFACE_NAME, (Object)this);
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        CountStatisticImpl u = new CountStatisticImpl(sm.getString("jvmstats.jvm_uptime"), sm.getString("jvmstats.milli_seconds"), sm.getString("jvmstats.jvm_uptime_desc"));
        this.uptime = new MutableCountStatisticImpl(u);
        long upper = Runtime.getRuntime().maxMemory();
        BoundedRangeStatisticImpl h = new BoundedRangeStatisticImpl(sm.getString("jvmstats.jvm_heapsize"), sm.getString("jvmstats.bytes"), sm.getString("jvmstats.jvm_heapsize_desc"), 0L, upper, 0L);
        this.heapSize = new MutableBoundedRangeStatisticImpl(h);
    }

    public BoundedRangeStatistic getHeapSize() {
        long heap = Runtime.getRuntime().totalMemory();
        this.heapSize.setCount(heap);
        return (BoundedRangeStatistic)this.heapSize.unmodifiableView();
    }

    public CountStatistic getUpTime() {
        long curTime = System.currentTimeMillis();
        long upTime = curTime - this.initTime;
        this.uptime.setCount(upTime);
        return (CountStatistic)this.uptime.unmodifiableView();
    }

    public Statistic[] getStatistics() {
        return this.baseStatsImpl.getStatistics();
    }

    public Statistic getStatistic(String str) {
        return this.baseStatsImpl.getStatistic(str);
    }

    public String[] getStatisticNames() {
        return this.baseStatsImpl.getStatisticNames();
    }
}

