/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.common;

import com.sun.appserv.management.ext.wsmgmt.WebServiceEndpointInfoImpl;
import com.sun.enterprise.admin.mbeans.J2EEModule;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.wsmgmt.repository.spi.RepositoryException;
import com.sun.enterprise.admin.wsmgmt.repository.spi.WebServiceInfoProvider;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.tools.common.dd.WebserviceEndpoint;
import com.sun.enterprise.tools.common.dd.ejb.Ejb;
import com.sun.enterprise.tools.common.dd.ejb.EnterpriseBeans;
import com.sun.enterprise.tools.common.dd.ejb.SunEjbJar;
import com.sun.enterprise.tools.common.dd.webapp.Servlet;
import com.sun.enterprise.tools.common.dd.webapp.SunWebApp;
import com.sun.enterprise.tools.common.dd.webservice.PortComponentType;
import com.sun.enterprise.tools.common.dd.webservice.ServiceImplBeanType;
import com.sun.enterprise.tools.common.dd.webservice.WebserviceDescriptionType;
import com.sun.enterprise.tools.common.dd.webservice.Webservices;
import com.sun.enterprise.webservice.monitoring.NamespaceContextImpl;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class AppServWebServiceInfoProvider
implements WebServiceInfoProvider {
    public static final String PROVIDER_ID = "com.sun.enterprise.tools.common.AppServWebServiceInfoProvider";

    public String getProviderID() {
        return PROVIDER_ID;
    }

    public List getWebServiceInfo(String moduleInfo, Map propMap) throws RepositoryException {
        String moduleType = null;
        String appId = null;
        String bundleName = null;
        String webservices = null;
        String bundleRoot = null;
        if (propMap != null) {
            moduleType = (String)propMap.get("module.type");
            appId = (String)propMap.get("application.id");
            bundleName = (String)propMap.get("bundle.name");
            webservices = (String)propMap.get("ws.xml.location");
            bundleRoot = (String)propMap.get("bundle.root.location");
        }
        if (moduleType == null || appId == null || webservices == null || bundleRoot == null) {
            throw new IllegalArgumentException();
        }
        return this.getWebServiceInfoInternal(moduleInfo, appId, bundleName, webservices, bundleRoot, propMap);
    }

    private List getWebServiceInfoInternal(String moduleInfo, String appId, String bundleName, String webservices, String bundleRoot, Map propMap) throws RepositoryException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(webservices);
        }
        catch (FileNotFoundException fne) {
            throw new RepositoryException(fne);
        }
        Webservices webServices = null;
        webServices = Webservices.createGraph(in);
        boolean isAppStandAloneModule = bundleName == null;
        WebserviceDescriptionType[] wsdts = webServices.getWebserviceDescription();
        ArrayList<WebServiceEndpointInfoImpl> aList = new ArrayList<WebServiceEndpointInfoImpl>();
        String uri = null;
        String implName = null;
        String implType = null;
        String implClass = null;
        Map wsWebMap = null;
        Map wsEjbMap = null;
        for (int wsCnt = 0; wsCnt < wsdts.length; ++wsCnt) {
            WebserviceDescriptionType wsdt = wsdts[wsCnt];
            String wsdl = null;
            String wsdlFile = null;
            String mappingFileName = null;
            String mapping = null;
            if (wsdt != null) {
                wsdl = bundleRoot + File.separator + wsdt.getWsdlFile();
                String mapFile = wsdt.getJaxrpcMappingFile();
                mappingFileName = mapFile == null ? null : bundleRoot + File.separator + mapFile;
            }
            J2EEModule j2eeModule = new J2EEModule();
            try {
                if (mappingFileName != null) {
                    mapping = j2eeModule.getStringForDDxml(mappingFileName);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (wsdl != null) {
                    wsdlFile = j2eeModule.getStringForDDxml(wsdl);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            PortComponentType[] pts = wsdt.getPortComponent();
            for (int portCnt = 0; portCnt < pts.length; ++portCnt) {
                PortComponentType pt = pts[portCnt];
                ServiceImplBeanType beanType = pt.getServiceImplBean();
                WebServiceDescrInfo wsDescrInfo = null;
                implName = beanType.getServletLink();
                if (implName != null) {
                    implType = "SERVLET";
                    if (wsWebMap == null) {
                        wsWebMap = this.getWebServiceInfoForWebModule(moduleInfo, appId, bundleName, webservices);
                    }
                    if (wsWebMap != null) {
                        wsDescrInfo = (WebServiceDescrInfo)wsWebMap.get(pt.getPortComponentName());
                    }
                } else {
                    implName = beanType.getEjbLink();
                    if (implName != null) {
                        implType = "EJB";
                        if (wsEjbMap == null) {
                            wsEjbMap = this.getWebServiceInfoForEjbModule(moduleInfo, appId, bundleName, webservices);
                        }
                        if (wsEjbMap != null) {
                            wsDescrInfo = (WebServiceDescrInfo)wsEjbMap.get(pt.getPortComponentName());
                        }
                    }
                }
                if (wsDescrInfo != null) {
                    uri = wsDescrInfo.getUri();
                    implClass = wsDescrInfo.getImplClass();
                }
                String wsFile = (String)propMap.get("ws.xml");
                String port = null;
                StringTokenizer st = new StringTokenizer(pt.getWsdlPort().getLocalPart(), ":");
                while (st.hasMoreTokens()) {
                    port = st.nextToken();
                }
                String serviceUrl = this.getServiceURL(wsdl, port);
                WebServiceEndpointInfoImpl wsInfo = new WebServiceEndpointInfoImpl(pt.getPortComponentName(), uri, appId, bundleName, isAppStandAloneModule, wsdlFile, mapping, wsFile, implType, implName, implClass, serviceUrl, wsDescrInfo.isSecure());
                wsInfo.putField("SunWebXML", (Serializable)propMap.get("sun.web.xml"));
                wsInfo.putField("WebXML", (Serializable)propMap.get("web.xml.location"));
                wsInfo.putField("SunEJBXML", (Serializable)propMap.get("sun.ejb.jar.xml"));
                wsInfo.putField("EJBXML", (Serializable)propMap.get("ejb.jar.xml.location"));
                wsInfo.putField("ApplicationXML", (Serializable)propMap.get("application.xml"));
                wsInfo.putField("MappingFileLocation", (Serializable)((Object)mappingFileName));
                wsInfo.putField("WSDLFileLocation", (Serializable)((Object)wsdl));
                aList.add(wsInfo);
            }
        }
        return aList;
    }

    private String getServiceURL(String wsdlFile, String localPart) {
        String endpointURL = null;
        try {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            InputSource inputSource = new InputSource(new BufferedInputStream(new FileInputStream(wsdlFile)));
            Document wsdlDoc = dFactory.newDocumentBuilder().parse(new BufferedInputStream(new FileInputStream(wsdlFile)));
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            NamespaceContextImpl context = new NamespaceContextImpl(wsdlDoc);
            xPath.setNamespaceContext(context);
            String xpathExpression = "/:definitions/:service/:port[@name='" + localPart + "']/soap:address/@location";
            endpointURL = xPath.evaluate(xpathExpression, inputSource);
            return endpointURL;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Map getWebServiceInfoForWebModule(String moduleInfo, String appId, String bundleName, String webservices) throws RepositoryException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(moduleInfo);
        }
        catch (FileNotFoundException fne) {
            throw new RepositoryException(fne);
        }
        SunWebApp sunWebApp = null;
        try {
            sunWebApp = SunWebApp.createGraph(in);
        }
        catch (Schema2BeansException sce) {
            throw new RepositoryException(sce);
        }
        boolean isAppStandAloneModule = bundleName == null;
        Servlet[] sLets = sunWebApp.getServlet();
        HashMap<String, WebServiceDescrInfo> wsMap = new HashMap<String, WebServiceDescrInfo>();
        for (int sCnt = 0; sCnt < sLets.length; ++sCnt) {
            Servlet sLet = sLets[sCnt];
            WebserviceEndpoint[] webSvcEps = sLet.getWebserviceEndpoint();
            for (int wsCnt = 0; wsCnt < webSvcEps.length; ++wsCnt) {
                String wsUri;
                WebserviceEndpoint webSvc = webSvcEps[wsCnt];
                String ctxRoot = sunWebApp.getContextRoot();
                String uriInConfig = this.getUriInDomainConfig(appId);
                if (uriInConfig != null) {
                    ctxRoot = uriInConfig;
                }
                if ((wsUri = webSvc.getEndpointAddressUri()) != null && wsUri.length() > 0 && wsUri.charAt(0) != '/') {
                    wsUri = "/" + wsUri;
                }
                String uri = ctxRoot != null ? ctxRoot + wsUri : wsUri;
                boolean isSec = false;
                String trans = webSvc.getTransportGuarantee();
                if (trans != null && !"NONE".equals(trans)) {
                    isSec = true;
                } else if (webSvc.getLoginConfig() != null || webSvc.getMessageSecurityBinding() != null) {
                    isSec = true;
                }
                WebServiceDescrInfo wsdInfo = new WebServiceDescrInfo(webSvc.getPortComponentName(), uri, webSvc.getServletImplClass(), isSec);
                wsMap.put(wsdInfo.getName(), wsdInfo);
            }
        }
        return wsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebserviceDescriptionType getWSDT(String webservicesXML, String pcName) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(webservicesXML));
            Webservices ws = Webservices.createGraph(fis);
            WebserviceDescriptionType[] wsdt = ws.getWebserviceDescription();
            for (int i = 0; i < wsdt.length; ++i) {
                PortComponentType[] pct = wsdt[i].getPortComponent();
                for (int j = 0; j < pct.length; ++j) {
                    String name = pct[j].getPortComponentName();
                    if (!pcName.equals(name)) continue;
                    WebserviceDescriptionType webserviceDescriptionType = wsdt[i];
                    return webserviceDescriptionType;
                }
            }
        }
        catch (Exception e) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
        return null;
    }

    private Map getWebServiceInfoForEjbModule(String moduleInfo, String appId, String bundleName, String webservices) throws RepositoryException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(moduleInfo);
        }
        catch (FileNotFoundException fne) {
            throw new RepositoryException(fne);
        }
        SunEjbJar sunEjbJar = null;
        try {
            sunEjbJar = SunEjbJar.createGraph(in);
        }
        catch (Schema2BeansException sce) {
            throw new RepositoryException(sce);
        }
        boolean isAppStandAloneModule = bundleName == null;
        EnterpriseBeans eBeans = sunEjbJar.getEnterpriseBeans();
        Ejb[] ejbs = eBeans.getEjb();
        HashMap<String, WebServiceDescrInfo> wsMap = new HashMap<String, WebServiceDescrInfo>();
        for (int ejbCnt = 0; ejbCnt < ejbs.length; ++ejbCnt) {
            Ejb ejb = ejbs[ejbCnt];
            WebserviceEndpoint[] webSvcEps = ejb.getWebserviceEndpoint();
            for (int wsCnt = 0; wsCnt < webSvcEps.length; ++wsCnt) {
                WebserviceEndpoint webSvc = webSvcEps[wsCnt];
                boolean isSec = false;
                String trans = webSvc.getTransportGuarantee();
                if (trans != null && !"NONE".equals(trans)) {
                    isSec = true;
                } else if (webSvc.getLoginConfig() != null || webSvc.getMessageSecurityBinding() != null) {
                    isSec = true;
                }
                WebServiceDescrInfo wsdInfo = new WebServiceDescrInfo(webSvc.getPortComponentName(), webSvc.getEndpointAddressUri(), webSvc.getTieClass(), isSec);
                wsMap.put(wsdInfo.getName(), wsdInfo);
            }
        }
        return wsMap;
    }

    private String getUriInDomainConfig(String appId) {
        ConfigContext configCtx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        ConfigBean cb = null;
        try {
            cb = ApplicationHelper.findApplication(configCtx, appId);
        }
        catch (Exception e) {
            return null;
        }
        if (cb instanceof WebModule) {
            return ((WebModule)cb).getContextRoot();
        }
        return null;
    }

    class WebServiceDescrInfo {
        private String compName;
        private String uri;
        private String implClass;
        private boolean isSecure;

        WebServiceDescrInfo(String cName, String URI2, String iClass, boolean isSec) {
            this.compName = cName;
            this.uri = URI2;
            this.implClass = iClass;
            this.isSecure = isSec;
        }

        String getName() {
            return this.compName;
        }

        String getUri() {
            return this.uri;
        }

        String getImplClass() {
            return this.implClass;
        }

        boolean isSecure() {
            return this.isSecure;
        }
    }
}

