/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.common.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.modules.schema2beans.BaseBean;

public abstract class BasicIasBean {
    protected static final VetoableChangeListener greaterThanNegOne = new PositiveValueListener();
    protected static final VetoableChangeListener notNull = new NotEmptyValueListener();
    private PropertyChangeSupport pcs;
    private VetoableChangeSupport vcs;
    protected static final ResourceBundle bundle = ResourceBundle.getBundle("com.sun.enterprise.tools.common.beans.Bundle");

    protected BasicIasBean() {
    }

    public PropertyChangeSupport getPCS() {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    public VetoableChangeSupport getVCS() {
        if (null == this.vcs) {
            this.vcs = new VetoableChangeSupport(this);
        }
        return this.vcs;
    }

    protected void doAttrSetProcessing(BaseBean bean, String newVal, String attrName, String propName) throws PropertyVetoException {
        String oldName = bean.getAttributeValue(attrName);
        this.fireMyVetoableChange(propName, oldName, newVal);
        bean.setAttributeValue(attrName, newVal);
        this.fireMyPropertyChange(propName, oldName, newVal);
    }

    protected void doElementSetProcessing(BaseBean bean, String newVal, String subElement, String propName) throws PropertyVetoException {
        String oldName = (String)bean.getValue(subElement);
        this.fireMyVetoableChange(propName, oldName, newVal);
        bean.setValue(subElement, newVal);
        this.fireMyPropertyChange(propName, oldName, newVal);
    }

    protected void doAttrSetProcessing(BaseBean bean, int newVal, String attrName, String propName) throws PropertyVetoException {
        int oldVal = Integer.parseInt(bean.getAttributeValue(attrName));
        this.fireMyVetoableChange(propName, oldVal, newVal);
        bean.setAttributeValue(attrName, "" + newVal);
        this.fireMyPropertyChange(propName, oldVal, newVal);
    }

    protected void fireMyVetoableChange(String name, Object oldV, Object newV) throws PropertyVetoException {
        if (null == this.vcs) {
            this.vcs = new VetoableChangeSupport(this);
        }
        this.vcs.fireVetoableChange(name, oldV, newV);
    }

    protected void fireMyVetoableChange(String name, int oldV, int newV) throws PropertyVetoException {
        if (null == this.vcs) {
            this.vcs = new VetoableChangeSupport(this);
        }
        this.vcs.fireVetoableChange(name, oldV, newV);
    }

    protected void fireMyPropertyChange(String name, Object oldV, Object newV) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.firePropertyChange(name, oldV, newV);
    }

    protected void fireMyPropertyChange(String name, int oldV, int newV) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.firePropertyChange(name, oldV, newV);
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (null != this.pcs) {
            this.pcs.removePropertyChangeListener(pcl);
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener pcl) {
        if (null == this.vcs) {
            this.vcs = new VetoableChangeSupport(this);
        }
        this.vcs.addVetoableChangeListener(pcl);
    }

    public void removeVetoableChangeListener(VetoableChangeListener pcl) {
        if (null != this.vcs) {
            this.vcs.removeVetoableChangeListener(pcl);
        }
    }

    public abstract void outTo(OutputStream var1) throws IOException;

    static class NotEmptyValueListener
    implements VetoableChangeListener {
        NotEmptyValueListener() {
        }

        public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
            try {
                String val = (String)pce.getNewValue();
                if (null == val || val.trim().length() == 0) {
                    String messFormat = bundle.getString("ERROR_MUST_HAVE_VALUE");
                    String mess = MessageFormat.format(messFormat, pce.getPropertyName());
                    throw new PropertyVetoException(mess, pce);
                }
            }
            catch (Throwable t) {
                throw new PropertyVetoException(t.getLocalizedMessage(), pce);
            }
        }
    }

    static class PositiveValueListener
    implements VetoableChangeListener {
        PositiveValueListener() {
        }

        public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
            try {
                Integer valI = (Integer)pce.getNewValue();
                int val = valI;
                if (0 > val) {
                    String messFormat = bundle.getString("ERROR_MUST_BE_POSITIVE");
                    String mess = MessageFormat.format(messFormat, pce.getPropertyName());
                    throw new PropertyVetoException(mess, pce);
                }
            }
            catch (Throwable t) {
                throw new PropertyVetoException(t.getLocalizedMessage(), pce);
            }
        }
    }
}

