/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.common.dd.connector;

import com.sun.enterprise.tools.common.dd.SunBaseBean;
import com.sun.enterprise.tools.common.dd.connector.ResourceAdapter;
import com.sun.enterprise.tools.common.dd.connector.RoleMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GraphManager;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.ValidateException;
import org.netbeans.modules.schema2beans.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SunConnector
extends SunBaseBean {
    static Vector comparators = new Vector();
    public static final String RESOURCE_ADAPTER = "ResourceAdapter";
    public static final String ROLE_MAP = "RoleMap";

    public SunConnector() throws Schema2BeansException {
        this(null, 1);
    }

    public SunConnector(Node doc, int options) throws Schema2BeansException {
        this(2);
        this.initFromNode(doc, options);
    }

    protected void initFromNode(Node doc, int options) throws Schema2BeansException {
        if (doc == null && (doc = GraphManager.createRootElementNode("sun-connector")) == null) {
            throw new Schema2BeansException(Common.getMessage("CantCreateDOMRoot_msg", "sun-connector"));
        }
        Node n = GraphManager.getElementNode("sun-connector", doc);
        if (n == null) {
            throw new Schema2BeansException(Common.getMessage("DocRootNotInDOMGraph_msg", "sun-connector", doc.getFirstChild().getNodeName()));
        }
        this.graphManager.setXmlDocument(doc);
        this.createBean(n, this.graphManager());
        this.initialize(options);
    }

    public SunConnector(int options) {
        super(comparators, new Version(1, 2, 0));
        this.initOptions(options);
    }

    protected void initOptions(int options) {
        this.graphManager = new GraphManager(this);
        this.createRoot("sun-connector", "SunConnector", 544, SunConnector.class);
        this.createProperty("resource-adapter", RESOURCE_ADAPTER, 66080, ResourceAdapter.class);
        this.createAttribute(RESOURCE_ADAPTER, "jndi-name", "JndiName", 257, null, null);
        this.createAttribute(RESOURCE_ADAPTER, "max-pool-size", "MaxPoolSize", 1, null, "32");
        this.createAttribute(RESOURCE_ADAPTER, "steady-pool-size", "SteadyPoolSize", 1, null, "4");
        this.createAttribute(RESOURCE_ADAPTER, "max-wait-time-in-millis", "MaxWaitTimeInMillis", 1, null, "10000");
        this.createAttribute(RESOURCE_ADAPTER, "idle-timeout-in-seconds", "IdleTimeoutInSeconds", 1, null, "1000");
        this.createProperty("role-map", ROLE_MAP, 66064, RoleMap.class);
        this.createAttribute(ROLE_MAP, "map-id", "MapId", 257, null, null);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setResourceAdapter(ResourceAdapter value) {
        this.setValue(RESOURCE_ADAPTER, value);
    }

    public ResourceAdapter getResourceAdapter() {
        return (ResourceAdapter)this.getValue(RESOURCE_ADAPTER);
    }

    public void setRoleMap(RoleMap value) {
        this.setValue(ROLE_MAP, value);
    }

    public RoleMap getRoleMap() {
        return (RoleMap)this.getValue(ROLE_MAP);
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public static SunConnector createGraph(Node doc) throws Schema2BeansException {
        return new SunConnector(doc, 2);
    }

    public static SunConnector createGraph(InputStream in) throws Schema2BeansException {
        return SunConnector.createGraph(in, false);
    }

    public static SunConnector createGraph(InputStream in, boolean validate) throws Schema2BeansException {
        Document doc = GraphManager.createXmlDocument(in, validate);
        return SunConnector.createGraph(doc);
    }

    public static SunConnector createGraph() {
        try {
            return new SunConnector();
        }
        catch (Schema2BeansException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void validate() throws ValidateException {
        boolean restrictionFailure = false;
        if (this.getResourceAdapter() == null) {
            throw new ValidateException("getResourceAdapter() == null", "resourceAdapter", this);
        }
        this.getResourceAdapter().validate();
        if (this.getRoleMap() != null) {
            this.getRoleMap().validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.write(baos);
        String str = baos.toString();
        out.writeUTF(str);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.init(comparators, new Version(1, 2, 0));
            String strDocument = in.readUTF();
            ByteArrayInputStream bais = new ByteArrayInputStream(strDocument.getBytes());
            Document doc = GraphManager.createXmlDocument(bais, false);
            this.initOptions(2);
            this.initFromNode(doc, 2);
        }
        catch (Schema2BeansException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public void dump(StringBuffer str, String indent) {
        str.append(indent);
        str.append(RESOURCE_ADAPTER);
        SunBaseBean n = this.getResourceAdapter();
        if (n != null) {
            ((BaseBean)n).dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(RESOURCE_ADAPTER, 0, str, indent);
        str.append(indent);
        str.append(ROLE_MAP);
        n = this.getRoleMap();
        if (n != null) {
            ((BaseBean)n).dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(ROLE_MAP, 0, str, indent);
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("SunConnector\n");
        this.dump(str, "\n  ");
        return str.toString();
    }
}

