/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JWhich {
    private String[] classpath = null;
    private String classpathArg = null;
    private String classname = null;
    private String jarClassname = null;
    private boolean doReflect = false;
    private boolean doExhaustive = true;
    private boolean debug_ = false;
    private String result = new String();

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            JWhich.usage();
            return;
        }
        boolean argNum = false;
        if (args[0].toLowerCase().equals("-classpath")) {
            if (args.length != 3) {
                JWhich.usage();
                return;
            }
            new JWhich(args[2], args[1]);
        } else {
            new JWhich(args[0]);
        }
    }

    public JWhich(String classname, String classpathArgIn) {
        this.classpathArg = classpathArgIn;
        this.ctor(classname);
    }

    public JWhich(String classname) {
        this.ctor(classname);
    }

    public String getResult() {
        return this.result;
    }

    private void ctor(String classname) {
        this.classname = classname;
        this.initClasspath();
        this.fixClassname();
        String[] locations = this.findClass();
        this.pr("");
        if (locations == null || locations.length <= 0) {
            this.pr("Can't find class");
            return;
        }
        for (int i = 0; i < locations.length; ++i) {
            this.pr(classname + " located in " + locations[i]);
        }
    }

    private static void usage() {
        System.out.println("Usage:  java  " + JWhich.class.getName() + " [-classpath a_classpath] classname");
    }

    private void initClasspath() {
        String cp = this.classpathArg == null ? System.getProperty("java.class.path") : this.classpathArg;
        StringTokenizer tokens = new StringTokenizer(cp, ";", false);
        int nTokens = tokens.countTokens();
        this.classpath = new String[nTokens];
        this.debug("" + nTokens + " tokens.");
        int i = 0;
        while (tokens.hasMoreTokens()) {
            String s = tokens.nextToken();
            this.debug(s);
            this.classpath[i] = s;
            ++i;
        }
    }

    private void fixClassname() {
        this.debug("old classname: " + this.classname);
        this.jarClassname = this.classname;
        this.classname = this.classname.replace('.', File.separatorChar);
        if (File.separatorChar != '/') {
            this.classname = this.classname.replace('/', File.separatorChar);
        }
        if (File.separatorChar != '\\') {
            this.classname = this.classname.replace('\\', File.separatorChar);
        }
        this.jarClassname = this.jarClassname.replace('.', '/');
        this.jarClassname = this.jarClassname.replace('\\', '/');
        this.classname = this.classname + ".class";
        this.jarClassname = this.jarClassname + ".class";
        this.debug("new classname: " + this.classname);
        this.debug("new jarClassname: " + this.jarClassname);
    }

    private String[] findClass() {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this.classpath.length; ++i) {
            String path = this.classpath[i];
            if (!this.findClass(path)) continue;
            names.add(path);
            this.debug("FOUND IT:  " + path);
        }
        int num = names.size();
        this.debug("Found it in " + num + " places");
        if (num <= 0) {
            return null;
        }
        String[] ss = new String[num];
        ss = names.toArray(ss);
        return ss;
    }

    private boolean findClass(String path) {
        if (path.toLowerCase().endsWith(".jar")) {
            return this.findClassInJar(path);
        }
        File f = new File(path + File.separator + this.classname);
        this.debug("Looking for " + f);
        return f.exists();
    }

    private boolean findClassInJar(String path) {
        ZipInputStream zin = null;
        try {
            ZipEntry entry;
            zin = new ZipInputStream(new FileInputStream(path));
            while ((entry = zin.getNextEntry()) != null) {
                String name = entry.getName();
                zin.closeEntry();
                if (!name.equals(this.jarClassname)) continue;
                zin.close();
                return true;
            }
            zin.close();
        }
        catch (IOException e) {
            this.debug("" + e + "  " + path);
        }
        return false;
    }

    private void debug(String s) {
        if (this.debug_) {
            this.pr(s);
        }
    }

    private void pr(String s) {
        System.out.println(s);
        this.result = this.result + s;
    }
}

