/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.gui;

import com.sun.enterprise.tools.verifier.CheckMgr;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.VerifierEventsListener;
import com.sun.enterprise.tools.verifier.gui.ControlPanel;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import java.util.logging.LogRecord;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class ResultsPanel
extends JPanel
implements VerifierEventsListener {
    JTable table;
    DefaultTableModel tableModel;
    JScrollPane tableScrollPane;
    JScrollPane textScrollPane;
    JTextArea detailText;
    Vector<String> details = new Vector();
    private static Vector<Result> passResults = new Vector();
    private static Vector<Result> failResults = new Vector();
    private static Vector<LogRecord> errorResults = new Vector();
    private static Vector<Result> warnResults = new Vector();
    private static Vector<Result> naResults = new Vector();
    private static Vector<Result> notImplementedResults = new Vector();
    private static Vector<Result> notRunResults = new Vector();
    private static Vector<Result> defaultResults = new Vector();
    static LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    final String[] columnNames = new String[]{smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName1", "Item"), smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName2", "Test Name"), smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName3", "Result")};
    final String errStr = smh.getLocalString(this.getClass().getName() + ".errStr", "Error during verification");
    final String errStr1 = smh.getLocalString(this.getClass().getName() + ".errStr1", "ERROR");

    public ResultsPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.ResultsPanelLabel", "Results: (Click on Item to show test Details below)")));
        this.getAccessibleContext().setAccessibleName(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.panelName", "Panel"));
        this.getAccessibleContext().setAccessibleDescription(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.PanelDesc", "This is a panel"));
        CheckMgr.addVerifierEventsListener(this);
        this.tableModel = new DefaultTableModel(this.columnNames, 0);
        this.table = new JTable(this.tableModel);
        this.table.getAccessibleContext().setAccessibleName(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.tableName", "Table"));
        this.table.getAccessibleContext().setAccessibleDescription(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.tableDesc", "This is a table of items"));
        this.table.setSelectionMode(0);
        this.tableScrollPane = new JScrollPane(this.table);
        this.tableScrollPane.getAccessibleContext().setAccessibleName(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.scrName1", "Scroll Pane"));
        this.tableScrollPane.getAccessibleContext().setAccessibleDescription(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.scrDesc1", "This is a scroll pane that helps to scroll the list"));
        this.sizeTableColumns();
        JTextField field = new JTextField();
        field.getAccessibleContext().setAccessibleName(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.fielsName", "Text Field"));
        field.getAccessibleContext().setAccessibleDescription(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.fieldDesc", "This is a text field"));
        this.table.setDefaultEditor(Object.class, new DefaultCellEditor(field){

            public boolean isCellEditable(EventObject anEvent) {
                return false;
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (ResultsPanel.this.table.getSelectionModel().isSelectedIndex(e.getLastIndex())) {
                        ResultsPanel.this.setDetailText(ResultsPanel.this.details.elementAt(e.getLastIndex()));
                    } else if (ResultsPanel.this.table.getSelectionModel().isSelectedIndex(e.getFirstIndex())) {
                        ResultsPanel.this.setDetailText(ResultsPanel.this.details.elementAt(e.getFirstIndex()));
                    }
                }
            }
        });
        this.detailText = new JTextArea(4, 50);
        this.detailText.getAccessibleContext().setAccessibleName(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.areaName", "Text Area"));
        this.detailText.getAccessibleContext().setAccessibleDescription(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.areaDesc", "This is a text area"));
        this.detailText.setEditable(false);
        this.textScrollPane = new JScrollPane(this.detailText);
        this.textScrollPane.getAccessibleContext().setAccessibleName(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.scrName2", "Scroll Pane"));
        this.textScrollPane.getAccessibleContext().setAccessibleDescription(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.scrDesc2", "This is a scroll pane that helps to scroll the list"));
        this.textScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.DetailsPanelLabel", "Details:")));
        this.add("Center", this.tableScrollPane);
        this.add("South", this.textScrollPane);
        RadioListener myListener = new RadioListener();
        ControlPanel.addRadioButtonListener(myListener);
    }

    public void setDetailText(String details) {
        this.detailText.setText(details);
        JScrollBar scrollBar = this.textScrollPane.getVerticalScrollBar();
        if (scrollBar != null) {
            scrollBar.setValue(0);
        }
    }

    public void addDetailText(String details) {
        this.detailText.append(details);
    }

    public void clearResults() {
        this.tableModel = new DefaultTableModel(this.columnNames, 0);
        this.table.setModel(this.tableModel);
        this.sizeTableColumns();
        this.setDetailText("");
        this.details = new Vector();
    }

    void sizeTableColumns() {
        this.table.getColumn(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName1", "Item")).setMinWidth(150);
        this.table.getColumn(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName1", "Item")).setMaxWidth(200);
        this.table.getColumn(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName1", "Item")).setPreferredWidth(180);
        this.table.getColumn(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName2", "Test Name")).setMinWidth(150);
        this.table.getColumn(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName2", "Test Name")).setPreferredWidth(180);
        this.table.getColumn(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName3", "Result")).setMinWidth(120);
        this.table.getColumn(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName3", "Result")).setMaxWidth(200);
        this.table.getColumn(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.columnName3", "Result")).setPreferredWidth(160);
        this.table.setAutoResizeMode(4);
        this.table.sizeColumnsToFit(0);
    }

    private void upDateDisplayAll() {
        this.upDateDisplayFail();
        this.upDateDisplayWarn();
        this.upDateDisplayPass();
        this.upDateDisplayNa();
        this.upDateDisplayNotImplemented();
        this.upDateDisplayNotRun();
        this.upDateDisplayDefault();
        this.upDateDisplayError();
    }

    private void updateTableRows(Vector results) {
        for (int i = 0; i < results.size(); ++i) {
            String status2;
            Result r = (Result)results.elementAt(i);
            StringBuffer s = new StringBuffer("Assertion:" + r.getAssertion() + "\n");
            switch (r.getStatus()) {
                case 0: {
                    status2 = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_Passed", "Passed");
                    Enumeration e = r.getGoodDetails().elements();
                    while (e.hasMoreElements()) {
                        s.append((String)e.nextElement());
                        s.append("\n");
                    }
                    break;
                }
                case 1: {
                    status2 = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_Failed", "FAILED");
                    Enumeration e = r.getErrorDetails().elements();
                    while (e.hasMoreElements()) {
                        s.append((String)e.nextElement());
                        s.append("\n");
                    }
                    break;
                }
                case 2: {
                    status2 = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_Warning", "WARNING");
                    Enumeration e = r.getWarningDetails().elements();
                    while (e.hasMoreElements()) {
                        s.append((String)e.nextElement());
                        s.append("\n");
                    }
                    break;
                }
                case 3: {
                    status2 = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_NotApplicable", "Not Applicable");
                    Enumeration e = r.getNaDetails().elements();
                    while (e.hasMoreElements()) {
                        s.append((String)e.nextElement());
                        s.append("\n");
                    }
                    break;
                }
                case 5: {
                    status2 = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_NotImplemented", "Not Implemented");
                    break;
                }
                case 4: {
                    status2 = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_NotRun", "Not Run");
                    break;
                }
                default: {
                    status2 = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_Unknown", "Unknown");
                }
            }
            this.details.add(s.toString());
            Object[] row = new Object[]{r.getComponentName(), r.getTestName(), status2};
            this.tableModel.addRow(row);
        }
        this.table.sizeColumnsToFit(0);
    }

    private void upDateDisplayPass() {
        this.updateTableRows(this.getPassResultsForDisplay());
    }

    private void upDateDisplayFail() {
        this.updateTableRows(this.getFailResultsForDisplay());
    }

    private void upDateDisplayError() {
        Vector errors = this.getErrorResultsForDisplay();
        for (int i = 0; i < errors.size(); ++i) {
            LogRecord r = (LogRecord)errors.elementAt(i);
            this.details.add(r.getMessage() + "\n" + r.getThrown().getMessage());
            Object[] row = new Object[]{r.getLoggerName(), this.errStr, this.errStr1};
            this.tableModel.addRow(row);
        }
        this.table.sizeColumnsToFit(0);
    }

    private void upDateDisplayWarn() {
        this.updateTableRows(this.getWarnResultsForDisplay());
    }

    private void upDateDisplayNa() {
        this.updateTableRows(this.getNaResultsForDisplay());
    }

    private void upDateDisplayNotImplemented() {
        this.updateTableRows(this.getNotImplementedResultsForDisplay());
    }

    private void upDateDisplayNotRun() {
        this.updateTableRows(this.getNotRunResultsForDisplay());
    }

    private void upDateDisplayDefault() {
        this.updateTableRows(this.getDefaultResultsForDisplay());
    }

    void addError(LogRecord r) {
        this.saveErrorResultsForDisplay(r);
        this.details.add(r.getMessage() + "\n" + r.getThrown().getMessage());
        Object[] row = new Object[]{r.getLoggerName(), this.errStr, this.errStr1};
        this.tableModel.addRow(row);
        this.table.sizeColumnsToFit(0);
    }

    public void upDateDisplay(int status2) {
        this.clearResults();
        if (status2 == 2) {
            this.upDateDisplayAll();
        }
        if (status2 == 0) {
            this.upDateDisplayError();
            this.upDateDisplayFail();
        }
        if (status2 == 1) {
            this.upDateDisplayError();
            this.upDateDisplayFail();
            this.upDateDisplayWarn();
        }
    }

    private void savePassResultsForDisplay(Result r) {
        passResults.addElement(r);
    }

    private void saveWarnResultsForDisplay(Result r) {
        warnResults.addElement(r);
    }

    private void saveFailResultsForDisplay(Result r) {
        failResults.addElement(r);
    }

    private void saveErrorResultsForDisplay(LogRecord r) {
        errorResults.addElement(r);
    }

    private void saveNaResultsForDisplay(Result r) {
        naResults.addElement(r);
    }

    private void saveNotRunResultsForDisplay(Result r) {
        notRunResults.addElement(r);
    }

    private void saveNotImplementedResultsForDisplay(Result r) {
        notImplementedResults.addElement(r);
    }

    private void saveDefaultResultsForDisplay(Result r) {
        defaultResults.addElement(r);
    }

    private Vector getPassResultsForDisplay() {
        return passResults;
    }

    private Vector getWarnResultsForDisplay() {
        return warnResults;
    }

    private Vector getFailResultsForDisplay() {
        return failResults;
    }

    private Vector getErrorResultsForDisplay() {
        return errorResults;
    }

    private Vector getNaResultsForDisplay() {
        return naResults;
    }

    private Vector getNotImplementedResultsForDisplay() {
        return notImplementedResults;
    }

    private Vector getNotRunResultsForDisplay() {
        return notRunResults;
    }

    private Vector getDefaultResultsForDisplay() {
        return defaultResults;
    }

    public void clearOldResults() {
        passResults = new Vector();
        failResults = new Vector();
        errorResults = new Vector();
        warnResults = new Vector();
        naResults = new Vector();
        notImplementedResults = new Vector();
        notRunResults = new Vector();
        defaultResults = new Vector();
    }

    public void testFinished(EventObject evt) {
        String status2;
        Result r = (Result)evt.getSource();
        StringBuffer s = new StringBuffer("Assertion:" + r.getAssertion() + "\n");
        switch (r.getStatus()) {
            case 0: {
                status2 = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_Passed", "Passed");
                this.savePassResultsForDisplay(r);
                Enumeration e = r.getGoodDetails().elements();
                while (e.hasMoreElements()) {
                    s.append((String)e.nextElement());
                    s.append("\n");
                }
                break;
            }
            case 1: {
                status2 = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_Failed", "FAILED");
                this.saveFailResultsForDisplay(r);
                Enumeration e = r.getErrorDetails().elements();
                while (e.hasMoreElements()) {
                    s.append((String)e.nextElement());
                    s.append("\n");
                }
                break;
            }
            case 2: {
                status2 = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_Warning", "WARNING");
                this.saveWarnResultsForDisplay(r);
                Enumeration e = r.getWarningDetails().elements();
                while (e.hasMoreElements()) {
                    s.append((String)e.nextElement());
                    s.append("\n");
                }
                break;
            }
            case 3: {
                status2 = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_NotApplicable", "Not Applicable");
                this.saveNaResultsForDisplay(r);
                Enumeration e = r.getNaDetails().elements();
                while (e.hasMoreElements()) {
                    s.append((String)e.nextElement());
                    s.append("\n");
                }
                break;
            }
            case 5: {
                status2 = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_NotImplemented", "Not Implemented");
                this.saveNotImplementedResultsForDisplay(r);
                break;
            }
            case 4: {
                status2 = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_NotRun", "Not Run");
                this.saveNotRunResultsForDisplay(r);
                break;
            }
            default: {
                status2 = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ResultsPanel.Status_Unknown", "Unknown");
                this.saveDefaultResultsForDisplay(r);
            }
        }
        Object[] row = new Object[]{r.getComponentName(), r.getTestName(), status2};
        if (ControlPanel.getReportLevel() == 0 && r.getStatus() == 1) {
            this.details.add(s.toString());
            this.tableModel.addRow(row);
        }
        if (ControlPanel.getReportLevel() == 1 && (r.getStatus() == 1 || r.getStatus() == 2)) {
            this.details.add(s.toString());
            this.tableModel.addRow(row);
        }
        if (ControlPanel.getReportLevel() == 2) {
            this.details.add(s.toString());
            this.tableModel.addRow(row);
        }
    }

    public void allTestsFinished(EventObject e) {
    }

    class RadioListener
    implements ActionListener {
        RadioListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ControlPanel.allButton) {
                if (ResultsPanel.this.getPassResultsForDisplay().size() > 0 || ResultsPanel.this.getFailResultsForDisplay().size() > 0 || ResultsPanel.this.getErrorResultsForDisplay().size() > 0 || ResultsPanel.this.getWarnResultsForDisplay().size() > 0 || ResultsPanel.this.getNaResultsForDisplay().size() > 0 || ResultsPanel.this.getNotImplementedResultsForDisplay().size() > 0 || ResultsPanel.this.getNotRunResultsForDisplay().size() > 0 || ResultsPanel.this.getDefaultResultsForDisplay().size() > 0) {
                    ResultsPanel.this.upDateDisplay(2);
                } else {
                    ResultsPanel.this.clearResults();
                }
            }
            if (e.getSource() == ControlPanel.failButton) {
                if (ResultsPanel.this.getFailResultsForDisplay().size() > 0 || ResultsPanel.this.getErrorResultsForDisplay().size() > 0) {
                    ResultsPanel.this.upDateDisplay(0);
                } else {
                    ResultsPanel.this.clearResults();
                }
            }
            if (e.getSource() == ControlPanel.warnButton) {
                if (ResultsPanel.this.getFailResultsForDisplay().size() > 0 || ResultsPanel.this.getErrorResultsForDisplay().size() > 0 || ResultsPanel.this.getWarnResultsForDisplay().size() > 0) {
                    ResultsPanel.this.upDateDisplay(1);
                } else {
                    ResultsPanel.this.clearResults();
                }
            }
        }
    }
}

