/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.Enumeration;

public class TransactionDemarcationBeanManaged
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        try {
            if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
                String transactionType = descriptor.getTransactionType();
                if ("Bean".equals(transactionType)) {
                    ContainerTransaction containerTransaction = null;
                    if (!descriptor.getMethodContainerTransactions().isEmpty()) {
                        Enumeration ee = descriptor.getMethodContainerTransactions().keys();
                        while (ee.hasMoreElements()) {
                            MethodDescriptor methodDescriptor = (MethodDescriptor)ee.nextElement();
                            containerTransaction = (ContainerTransaction)descriptor.getMethodContainerTransactions().get(methodDescriptor);
                            try {
                                String transactionAttribute = containerTransaction.getTransactionAttribute();
                                if ("NotSupported".equals(transactionAttribute) || "Supports".equals(transactionAttribute) || "Required".equals(transactionAttribute) || "RequiresNew".equals(transactionAttribute) || "Mandatory".equals(transactionAttribute) || "Never".equals(transactionAttribute) || !transactionAttribute.equals("")) {
                                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: TransactionAttribute [ {0} ] for method [ {1} ] is not valid.   The Application Assembler must not define transaction attributes for an enterprise bean [ {2} ] with bean-managed transaction demarcation.", new Object[]{transactionAttribute, methodDescriptor.getName(), descriptor.getName()}));
                                    continue;
                                }
                                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Valid: TransactionAttribute [ {0} ] for method [ {1} ] is not defined for an enterprise bean [ {2} ] with bean-managed transaction demarcation.", new Object[]{transactionAttribute, methodDescriptor.getName(), descriptor.getName()}));
                            }
                            catch (NullPointerException e) {
                                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                                result.passed(smh.getLocalString(this.getClass().getName() + ".passed1", "Valid: TransactionAttribute is null for method [ {0} ] in bean [ {1} ]", new Object[]{methodDescriptor.getName(), descriptor.getName()}));
                                return result;
                            }
                        }
                    } else {
                        result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.passed(smh.getLocalString(this.getClass().getName() + ".passed2", "Valid: There are no method permissions within this bean [ {0} ]", new Object[]{descriptor.getName()}));
                    }
                    return result;
                }
                result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Bean [ {0} ] is not [ {1} ] managed, it is [ {2} ] managed.", new Object[]{descriptor.getName(), "Bean", transactionType}));
                return result;
            }
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] not called \n with a Session or Entity bean.", new Object[]{this.getClass()}));
            return result;
        }
        catch (Throwable t) {
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: [ {0} ] does not contain class [ {1} ] within bean [ {2} ]", new Object[]{descriptor.getName(), t.getMessage(), descriptor.getName()}));
            return result;
        }
    }
}

