/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.persistence;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.loader.InstrumentableClassLoader;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.persistence.AVKPersistenceUnitInfoImpl;
import com.sun.enterprise.tools.verifier.tests.VerifierCheck;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import java.util.Properties;
import java.util.logging.Level;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.IntegrityException;
import oracle.toplink.essentials.exceptions.ValidationException;

public class DefaultProviderVerification
extends VerifierTest
implements VerifierCheck {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result check(Descriptor descriptor) {
        PersistenceUnitDescriptor pu = (PersistenceUnitDescriptor)PersistenceUnitDescriptor.class.cast(descriptor);
        Result result = this.getInitializedResult();
        result.setStatus(0);
        String appLocation = this.getVerifierContext().getAbstractArchive().getArchiveUri();
        InstrumentableClassLoader cl = (InstrumentableClassLoader)InstrumentableClassLoader.class.cast(pu.getClassLoader());
        AVKPersistenceUnitInfoImpl pi = new AVKPersistenceUnitInfoImpl(pu, appLocation, cl);
        this.logger.fine("PersistenceInfo for PU is :\n" + pi);
        Properties props = new Properties();
        props.put("toplink.validation-only", "TRUE");
        props.put("toplink.orm.throw.exceptions", "TRUE");
        props.put("toplink.target-server", "oracle.toplink.essentials.platform.server.sunas.SunAS9ServerPlatform");
        props.put("toplink.weaving", "FALSE");
        EntityManagerFactoryProvider provider = new EntityManagerFactoryProvider();
        EntityManagerFactory emf = null;
        try {
            emf = provider.createContainerEntityManagerFactory(pi, props);
            this.logger.logp(Level.FINE, "DefaultProviderVerification", "check", "emf = {0}", emf);
        }
        catch (IntegrityException ie) {
            result.setStatus(1);
            this.addErrorDetails(result, this.getVerifierContext().getComponentNameConstructor());
            for (Object o : ie.getIntegrityChecker().getCaughtExceptions()) {
                Exception e = (Exception)Exception.class.cast(o);
                result.addErrorDetails(e.getMessage());
            }
        }
        catch (ValidationException ve) {
            this.addErrorDetails(result, this.getVerifierContext().getComponentNameConstructor());
            result.failed(ve.getMessage());
        }
        catch (DatabaseException de) {
            this.addErrorDetails(result, this.getVerifierContext().getComponentNameConstructor());
            result.failed(de.getMessage());
        }
        catch (PersistenceException pe) {
            this.addErrorDetails(result, this.getVerifierContext().getComponentNameConstructor());
            result.failed(pe.getMessage());
        }
        finally {
            if (emf != null) {
                emf.close();
            }
        }
        return result;
    }
}

