/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction.monitor;

import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.JTAStats;
import com.sun.enterprise.admin.monitor.stats.StringStatistic;
import com.sun.enterprise.admin.monitor.stats.StringStatisticImpl;
import com.sun.enterprise.transaction.monitor.JTSMonitorMBean;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.logging.LogDomains;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTAStatsImpl
implements JTAStats,
MonitoringLevelListener {
    private JTSMonitorMBean mBean = null;
    private GenericStatsImpl gStatsDelegate = null;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.jta");
    private static JTAStatsImpl instance = null;

    private JTAStatsImpl(JTSMonitorMBean mBean) {
        this.mBean = mBean;
        try {
            this.gStatsDelegate = new GenericStatsImpl("com.sun.enterprise.admin.monitor.stats.JTAStats", (Object)this);
        }
        catch (ClassNotFoundException clex) {
            _logger.log(Level.WARNING, "transaction.monitor.error_creating_jtastatsimpl", clex);
        }
    }

    public static synchronized void createInstance(JTSMonitorMBean mBean) {
        if (instance == null) {
            instance = new JTAStatsImpl(mBean);
        }
    }

    public static synchronized JTAStatsImpl getInstance() {
        if (instance == null) {
            throw new UnsupportedOperationException();
        }
        return instance;
    }

    @Override
    public void setLevel(MonitoringLevel level) {
        if (level == MonitoringLevel.OFF) {
            this.mBean.stopMonitoring();
        } else if (level == MonitoringLevel.LOW || level == MonitoringLevel.HIGH) {
            this.mBean.startMonitoring();
        }
    }

    @Override
    public void changeLevel(MonitoringLevel from, MonitoringLevel to, Stats handback) {
        if (from != to) {
            _logger.log(Level.FINE, "JTAStats Monitoring level changed from " + from + "  to  " + to);
            if (to == MonitoringLevel.OFF) {
                this.mBean.stopMonitoring();
            } else if (to == MonitoringLevel.LOW || to == MonitoringLevel.HIGH) {
                this.mBean.startMonitoring();
            }
        }
    }

    @Override
    public StringStatistic getActiveIds() {
        String activeStr = null;
        try {
            activeStr = (String)this.mBean.getAttribute("inflight-tx");
        }
        catch (AttributeNotFoundException jmxex) {
            _logger.log(Level.WARNING, "transaction.monitor.attribute_not_found", jmxex);
        }
        return new StringStatisticImpl(activeStr, "ActiveIds", "List", "List of inflight transactions", this.mBean.getStartTime(), System.currentTimeMillis());
    }

    @Override
    public StringStatistic getState() {
        String str = null;
        try {
            str = (String)this.mBean.getAttribute("isFrozen");
        }
        catch (AttributeNotFoundException jmxex) {
            _logger.log(Level.WARNING, "transaction.monitor.attribute_not_found", jmxex);
        }
        return new StringStatisticImpl(str, "State", "String", "Transaction system state: frozen?", this.mBean.getStartTime(), System.currentTimeMillis());
    }

    @Override
    public CountStatistic getActiveCount() {
        Integer count = null;
        try {
            count = (Integer)this.mBean.getAttribute("total-tx-inflight");
        }
        catch (AttributeNotFoundException jmxex) {
            _logger.log(Level.WARNING, "transaction.monitor.attribute_not_found", jmxex);
        }
        return new CountStatisticImpl(count.longValue(), "ActiveCount", CountStatisticImpl.DEFAULT_UNIT, "number of active transactions", System.currentTimeMillis(), this.mBean.getStartTime());
    }

    @Override
    public CountStatistic getCommittedCount() {
        Integer count = null;
        try {
            count = (Integer)this.mBean.getAttribute("total-tx-completed");
        }
        catch (AttributeNotFoundException jmxex) {
            _logger.log(Level.WARNING, "transaction.monitor.attribute_not_found", jmxex);
        }
        return new CountStatisticImpl(count.longValue(), "CommittedCount", CountStatisticImpl.DEFAULT_UNIT, "number of committed transactions", System.currentTimeMillis(), this.mBean.getStartTime());
    }

    @Override
    public CountStatistic getRolledbackCount() {
        Integer count = null;
        try {
            count = (Integer)this.mBean.getAttribute("total-tx-rolled-back");
        }
        catch (AttributeNotFoundException jmxex) {
            _logger.log(Level.WARNING, "transaction.monitor.attribute_not_found", jmxex);
        }
        return new CountStatisticImpl(count.longValue(), "RolledbackCount", CountStatisticImpl.DEFAULT_UNIT, "number of rolled-back transactions", System.currentTimeMillis(), this.mBean.getStartTime());
    }

    @Override
    public void freeze() {
        this.mBean.freeze();
    }

    @Override
    public void unfreeze() {
        this.mBean.unfreeze();
    }

    @Override
    public String rollback(String txnId) {
        String result = (String)this.mBean.setRollback(txnId);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, result);
        }
        return result;
    }

    @Override
    public Statistic getStatistic(String statisticName) {
        return this.gStatsDelegate.getStatistic(statisticName);
    }

    @Override
    public String[] getStatisticNames() {
        return this.gStatsDelegate.getStatisticNames();
    }

    @Override
    public Statistic[] getStatistics() {
        return this.gStatsDelegate.getStatistics();
    }

    @Override
    public void changeLevel(MonitoringLevel from, MonitoringLevel to, MonitoredObjectType type) {
        if (from != to) {
            _logger.log(Level.FINE, "JTAStats Monitoring level changed from " + from + "  to  " + to);
            if (to == MonitoringLevel.OFF) {
                this.mBean.stopMonitoring();
            } else if (to == MonitoringLevel.LOW || to == MonitoringLevel.HIGH) {
                this.mBean.startMonitoring();
            }
        }
    }

    @Override
    public List<Map<String, String>> listActiveTransactions() {
        return this.mBean.listActiveTransactions();
    }

    @Override
    public Boolean isRecoveryRequired() {
        return RecoveryManager.isIncompleteTxRecoveryRequired();
    }
}

