/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.ara;

import com.sun.enterprise.web.ara.IsolatedTask;
import com.sun.enterprise.web.ara.RulesExecutor;
import com.sun.enterprise.web.ara.rules.PathRule;
import com.sun.enterprise.web.connector.grizzly.HtmlHelper;
import com.sun.enterprise.web.connector.grizzly.ReadTask;
import com.sun.enterprise.web.connector.grizzly.Rule;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsolationRulesExecutor
implements RulesExecutor<IsolatedTask> {
    public static final int RULE_OK = 0;
    public static final int RULE_DELAY = 1;
    public static final int RULE_BLOCKED = 2;
    public static final int RULE_OK_NOCACHE = 3;
    public static final int RULE_CONTINUE = 4;
    private static final String RULE_CLASS = "com.sun.enterprise.web.ara.rules";
    private static final String DELAY_VALUE = "com.sun.enterprise.web.ara.delay";
    private static final int INITIAL_RULE_COUNT = 5;
    protected ArrayList<Rule> rules = new ArrayList();
    private static int currentThreadCount;
    private static long delayValue;
    private boolean isCachingAllowed = true;

    public IsolationRulesExecutor() {
        this.loadRules();
        if (System.getProperty(DELAY_VALUE) != null) {
            delayValue = Long.valueOf(System.getProperty(DELAY_VALUE));
        }
    }

    protected void loadRules() {
        if (System.getProperty(RULE_CLASS) != null) {
            StringTokenizer st = new StringTokenizer(System.getProperty(RULE_CLASS), ",");
            while (st.hasMoreTokens()) {
                this.rules.add(this.loadInstance(st.nextToken()));
            }
        }
        if (this.rules.size() == 0) {
            this.rules.add(new PathRule());
        }
    }

    @Override
    public boolean execute(IsolatedTask isolatedTask) {
        ReadTask task = (ReadTask)isolatedTask.getWrappedTask();
        Integer status2 = 0;
        int i = 0;
        this.isCachingAllowed = true;
        while (true) {
            this.rules.get(i).attach(task);
            try {
                status2 = (Integer)this.rules.get(i).call();
            }
            catch (Exception ex) {
                SelectorThread.logger().log(Level.SEVERE, "Rule exception", ex);
                return true;
            }
            boolean bl = this.isCachingAllowed = status2 != 3;
            if (status2 == 1) {
                try {
                    Thread.sleep(delayValue);
                }
                catch (InterruptedException ex) {
                    SelectorThread.logger().log(Level.SEVERE, "Rule delay exception", ex);
                }
                i = 0;
                continue;
            }
            if (status2 == 2) {
                task.cancelTask("No resources available.", HtmlHelper.OK);
                return true;
            }
            if (++i == this.rules.size()) break;
        }
        return status2 == 0 || status2 == 3;
    }

    @Override
    public boolean isCachingAllowed() {
        return this.isCachingAllowed;
    }

    private Rule loadInstance(String property) {
        Class<?> className = null;
        try {
            className = Class.forName(property);
            return (Rule)className.newInstance();
        }
        catch (ClassNotFoundException ex) {
        }
        catch (InstantiationException ex) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return new PathRule();
    }

    static {
        delayValue = 5000L;
    }
}

