/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.stats;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.PWCFileCacheStats;
import com.sun.enterprise.web.stats.StatsUtil;
import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;

public class PWCFileCacheStatsImpl
implements PWCFileCacheStats {
    private static final Logger logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private GenericStatsImpl baseStatsImpl = new GenericStatsImpl(PWCFileCacheStats.class, (Object)this);
    private ObjectName fileCacheName;
    private MBeanServer server;
    private MutableCountStatistic flagEnabled;
    private MutableCountStatistic secondsMaxAge;
    private MutableCountStatistic countEntries;
    private MutableCountStatistic maxEntries;
    private MutableCountStatistic countOpenEntries;
    private MutableCountStatistic maxOpenEntries;
    private MutableCountStatistic sizeHeapCache;
    private MutableCountStatistic maxHeapCacheSize;
    private MutableCountStatistic sizeMmapCache;
    private MutableCountStatistic maxMmapCacheSize;
    private MutableCountStatistic countHits;
    private MutableCountStatistic countMisses;
    private MutableCountStatistic countInfoHits;
    private MutableCountStatistic countInfoMisses;
    private MutableCountStatistic countContentHits;
    private MutableCountStatistic countContentMisses;

    public PWCFileCacheStatsImpl(String domain) {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        this.server = !servers.isEmpty() ? servers.get(0) : MBeanServerFactory.createMBeanServer();
        String objNameStr = domain + ":type=PWCFileCache,*";
        try {
            this.fileCacheName = new ObjectName(objNameStr);
        }
        catch (Throwable t) {
            String msg = logger.getResourceBundle().getString("webcontainer.objectNameCreationError");
            msg = MessageFormat.format(msg, objNameStr);
            logger.log(Level.SEVERE, msg, t);
        }
        this.initializeStatistics();
    }

    public CountStatistic getFlagEnabled() {
        this.flagEnabled.setCount(StatsUtil.getMaxStatistic(this.server, this.fileCacheName, "flagEnabled"));
        return (CountStatistic)this.flagEnabled.unmodifiableView();
    }

    public CountStatistic getSecondsMaxAge() {
        this.secondsMaxAge.setCount(StatsUtil.getMaxStatistic(this.server, this.fileCacheName, "secondsMaxAge"));
        return (CountStatistic)this.secondsMaxAge.unmodifiableView();
    }

    public CountStatistic getCountEntries() {
        this.countEntries.setCount(this.getAggregateLong("countEntries"));
        return (CountStatistic)this.countEntries.unmodifiableView();
    }

    public CountStatistic getMaxEntries() {
        this.maxEntries.setCount(StatsUtil.getMaxStatistic(this.server, this.fileCacheName, "maxEntries"));
        return (CountStatistic)this.maxEntries.unmodifiableView();
    }

    public CountStatistic getCountOpenEntries() {
        this.countOpenEntries.setCount(this.getAggregateLong("countOpenEntries"));
        return (CountStatistic)this.countOpenEntries.unmodifiableView();
    }

    public CountStatistic getMaxOpenEntries() {
        this.maxOpenEntries.setCount(StatsUtil.getMaxStatistic(this.server, this.fileCacheName, "maxOpenEntries"));
        return (CountStatistic)this.maxOpenEntries.unmodifiableView();
    }

    public CountStatistic getSizeHeapCache() {
        this.sizeHeapCache.setCount(StatsUtil.getMaxLongStatistic(this.server, this.fileCacheName, "sizeHeapCache"));
        return (CountStatistic)this.sizeHeapCache.unmodifiableView();
    }

    public CountStatistic getMaxHeapCacheSize() {
        this.maxHeapCacheSize.setCount(StatsUtil.getMaxLongStatistic(this.server, this.fileCacheName, "maxHeapCacheSize"));
        return (CountStatistic)this.maxHeapCacheSize.unmodifiableView();
    }

    public CountStatistic getSizeMmapCache() {
        this.sizeMmapCache.setCount(StatsUtil.getMaxLongStatistic(this.server, this.fileCacheName, "sizeMmapCache"));
        return (CountStatistic)this.sizeMmapCache.unmodifiableView();
    }

    public CountStatistic getMaxMmapCacheSize() {
        this.maxMmapCacheSize.setCount(StatsUtil.getMaxLongStatistic(this.server, this.fileCacheName, "maxMmapCacheSize"));
        return (CountStatistic)this.maxMmapCacheSize.unmodifiableView();
    }

    public CountStatistic getCountHits() {
        this.countHits.setCount(this.getAggregateLong("countHits"));
        return (CountStatistic)this.countHits.unmodifiableView();
    }

    public CountStatistic getCountMisses() {
        this.countMisses.setCount(this.getAggregateLong("countMisses"));
        return (CountStatistic)this.countMisses.unmodifiableView();
    }

    public CountStatistic getCountInfoHits() {
        this.countInfoHits.setCount(this.getAggregateLong("countInfoHits"));
        return (CountStatistic)this.countInfoHits.unmodifiableView();
    }

    public CountStatistic getCountInfoMisses() {
        this.countInfoMisses.setCount(this.getAggregateLong("countInfoMisses"));
        return (CountStatistic)this.countInfoMisses.unmodifiableView();
    }

    public CountStatistic getCountContentHits() {
        this.countContentHits.setCount(this.getAggregateLong("countContentHits"));
        return (CountStatistic)this.countContentHits.unmodifiableView();
    }

    public CountStatistic getCountContentMisses() {
        this.countContentMisses.setCount(this.getAggregateLong("countContentMisses"));
        return (CountStatistic)this.countContentMisses.unmodifiableView();
    }

    public Statistic[] getStatistics() {
        return this.baseStatsImpl.getStatistics();
    }

    public Statistic getStatistic(String str) {
        return this.baseStatsImpl.getStatistic(str);
    }

    public String[] getStatisticNames() {
        return this.baseStatsImpl.getStatisticNames();
    }

    private void initializeStatistics() {
        CountStatisticImpl cs = null;
        cs = new CountStatisticImpl("FlagEnabled");
        this.flagEnabled = new MutableCountStatisticImpl(cs);
        cs = new CountStatisticImpl("SecondsMaxAge");
        this.secondsMaxAge = new MutableCountStatisticImpl(cs);
        cs = new CountStatisticImpl("CountEntries");
        this.countEntries = new MutableCountStatisticImpl(cs);
        cs = new CountStatisticImpl("MaxEntries");
        this.maxEntries = new MutableCountStatisticImpl(cs);
        cs = new CountStatisticImpl("CountOpenEntries");
        this.countOpenEntries = new MutableCountStatisticImpl(cs);
        cs = new CountStatisticImpl("MaxOpenEntries");
        this.maxOpenEntries = new MutableCountStatisticImpl(cs);
        cs = new CountStatisticImpl("SizeHeapCache");
        this.sizeHeapCache = new MutableCountStatisticImpl(cs);
        cs = new CountStatisticImpl("MaxHeapCacheSize");
        this.maxHeapCacheSize = new MutableCountStatisticImpl(cs);
        cs = new CountStatisticImpl("SizeMmapCache");
        this.sizeMmapCache = new MutableCountStatisticImpl(cs);
        cs = new CountStatisticImpl("MaxMmapCacheSize");
        this.maxMmapCacheSize = new MutableCountStatisticImpl(cs);
        cs = new CountStatisticImpl("CountHits");
        this.countHits = new MutableCountStatisticImpl(cs);
        cs = new CountStatisticImpl("CountMisses");
        this.countMisses = new MutableCountStatisticImpl(cs);
        cs = new CountStatisticImpl("CountInfoHits");
        this.countInfoHits = new MutableCountStatisticImpl(cs);
        cs = new CountStatisticImpl("CountInfoMisses");
        this.countInfoMisses = new MutableCountStatisticImpl(cs);
        cs = new CountStatisticImpl("CountContentHits");
        this.countContentHits = new MutableCountStatisticImpl(cs);
        cs = new CountStatisticImpl("CountContentMisses");
        this.countContentMisses = new MutableCountStatisticImpl(cs);
    }

    private final int getAggregateInt(String attribute) {
        return StatsUtil.getAggregateStatistic(this.server, this.fileCacheName, attribute);
    }

    private final long getAggregateLong(String attribute) {
        return StatsUtil.getAggregateLongStatistic(this.server, this.fileCacheName, attribute);
    }
}

