/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.server.event.ApplicationEvent;
import com.sun.enterprise.server.event.ApplicationLoaderEventListener;
import com.sun.enterprise.server.event.EjbContainerEvent;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationLoaderEventListenerImpl
implements ApplicationLoaderEventListener {
    private final Logger logger = LogDomains.getLogger("javax.enterprise.system");
    private Map<String, List<WebServiceEndpoint>> endpoints = new HashMap<String, List<WebServiceEndpoint>>();

    @Override
    public void handleApplicationEvent(ApplicationEvent event) {
        Application application = event.getApplication();
        if (event.getEventType() == 1) {
            ArrayList<WebServiceEndpoint> list = new ArrayList<WebServiceEndpoint>();
            for (Object bundle : application.getWebBundleDescriptors()) {
                WebServicesDescriptor webServices = ((WebBundleDescriptor)bundle).getWebServices();
                list.addAll(webServices.getEndpoints());
            }
            if (!list.isEmpty()) {
                String appName = application.getRegistrationName();
                this.endpoints.put(appName, list);
                this.logger.log(Level.FINE, "serviceengine.websvc_endpoints_added", new Object[]{appName});
            }
        }
        if (event.getEventType() == 3) {
            this.endpoints.remove(application.getRegistrationName());
        }
    }

    @Override
    public void handleEjbContainerEvent(EjbContainerEvent event) {
    }

    public List<WebServiceEndpoint> getEndpoints(String appName) {
        return this.endpoints.get(appName);
    }

    public void mergeEndpointRegistry(Map<String, List<WebServiceEndpoint>> ws_endpoints) {
        ws_endpoints.putAll(this.endpoints);
        this.endpoints = ws_endpoints;
    }
}

