/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.security.jmac.PacketMapMessageInfo;
import com.sun.enterprise.security.jmac.PacketMessageInfo;
import com.sun.enterprise.security.jmac.config.PipeHelper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterPipeImpl;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ServerAuthContext;
import javax.xml.ws.WebServiceException;

public class CommonServerSecurityPipe
extends AbstractFilterPipeImpl {
    protected static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CommonServerSecurityPipe.class);
    private final boolean isHttpBinding;
    private PipeHelper helper;

    CommonServerSecurityPipe(Map props, Pipe next, boolean isHttpBinding) {
        super(next);
        props.put("SECURITY_PIPE", this);
        this.helper = new PipeHelper("SOAP", props, null);
        this.isHttpBinding = isHttpBinding;
    }

    protected CommonServerSecurityPipe(CommonServerSecurityPipe that, PipeCloner cloner) {
        super((AbstractFilterPipeImpl)that, cloner);
        this.helper = that.helper;
        this.isHttpBinding = that.isHttpBinding;
    }

    public void preDestroy() {
        this.helper.disable();
    }

    public Pipe copy(PipeCloner cloner) {
        return new CommonServerSecurityPipe(this, cloner);
    }

    public Packet process(Packet request) {
        if (this.isHttpBinding) {
            return this.next.process(request);
        }
        Packet response = null;
        try {
            response = this.processRequest(request);
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Failure in security pipe process", e);
            }
            response = this.helper.makeFaultResponse(response, e);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private Packet processRequest(Packet request) throws Exception {
        AuthStatus status2 = AuthStatus.SUCCESS;
        PacketMapMessageInfo info = new PacketMapMessageInfo(request, new Packet());
        Subject serverSubject = (Subject)request.invocationProperties.get("SERVER_SUBJECT");
        ServerAuthContext sAC = this.helper.getServerAuthContext(info, serverSubject);
        Subject clientSubject = CommonServerSecurityPipe.getClientSubject(request);
        try {
            block20: {
                try {
                    if (sAC == null) break block20;
                    status2 = sAC.validateRequest((MessageInfo)info, clientSubject, serverSubject);
                }
                catch (Exception e) {
                    _logger.log(Level.SEVERE, "ws.error_validate_request", e);
                    WebServiceException wse = new WebServiceException(localStrings.getLocalString("enterprise.webservice.cantValidateRequest", "Cannot validate request for {0}", new Object[]{this.helper.getModelName()}), e);
                    status2 = AuthStatus.SEND_FAILURE;
                    Packet packet = this.helper.getFaultResponse(info.getRequestPacket(), info.getResponsePacket(), wse);
                    Object var12_8 = null;
                    Packet validatedRequest = info.getRequestPacket();
                    this.helper.auditInvocation(validatedRequest, status2);
                    return packet;
                }
            }
            Object var12_7 = null;
            Packet validatedRequest = info.getRequestPacket();
            this.helper.auditInvocation(validatedRequest, status2);
        }
        catch (Throwable throwable) {
            Object var12_9 = null;
            Packet validatedRequest = info.getRequestPacket();
            this.helper.auditInvocation(validatedRequest, status2);
            throw throwable;
        }
        Packet response = null;
        if (status2 == AuthStatus.SUCCESS) {
            void var7_10;
            boolean authorized = false;
            try {
                this.helper.authorize((Packet)var7_10);
                authorized = true;
            }
            catch (Exception e) {
                response = this.helper.getFaultResponse((Packet)var7_10, info.getResponsePacket(), e);
            }
            if (authorized) {
                if (System.getSecurityManager() == null) {
                    try {
                        response = this.next.process((Packet)var7_10);
                    }
                    catch (Exception e) {
                        if (e instanceof AuthException) {
                            _logger.log(Level.SEVERE, "ws.error_next_pipe", e);
                        }
                        response = this.helper.getFaultResponse((Packet)var7_10, info.getResponsePacket(), e);
                    }
                } else {
                    try {
                        response = (Packet)Subject.doAsPrivileged(clientSubject, new PrivilegedExceptionAction((Packet)var7_10){
                            final /* synthetic */ Packet val$validatedRequest;
                            {
                                this.val$validatedRequest = packet;
                            }

                            public Object run() throws Exception {
                                return CommonServerSecurityPipe.this.next.process(this.val$validatedRequest);
                            }
                        }, null);
                    }
                    catch (PrivilegedActionException pae) {
                        Throwable cause = pae.getCause();
                        if (cause instanceof AuthException) {
                            _logger.log(Level.SEVERE, "ws.error_next_pipe", cause);
                        }
                        response = this.helper.getFaultResponse((Packet)var7_10, info.getResponsePacket(), cause);
                    }
                }
            }
            if (response == null) {
                WebServiceException wse = new WebServiceException(localStrings.getLocalString("enterprise.webservice.nullResponsePacket", "Invocation of Service {0} returned null response packet", new Object[]{this.helper.getModelName()}));
                response = this.helper.getFaultResponse((Packet)var7_10, info.getResponsePacket(), wse);
                _logger.log(Level.SEVERE, "", wse);
            }
            if (sAC != null && response.getMessage() != null) {
                info.setResponsePacket(response);
                response = this.processResponse(info, sAC, serverSubject);
            }
        } else {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "ws.status_validate_request", status2);
            }
            response = info.getResponsePacket();
        }
        return response;
    }

    private Packet processResponse(PacketMessageInfo info, ServerAuthContext sAC, Subject serverSubject) throws Exception {
        AuthStatus status2;
        try {
            status2 = sAC.secureResponse((MessageInfo)info, serverSubject);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                if (_logger.isLoggable(Level.INFO)) {
                    _logger.log(Level.INFO, "ws.error_secure_response", e);
                }
            } else {
                _logger.log(Level.SEVERE, "ws.error_secure_response", e);
            }
            return this.helper.makeFaultResponse(info.getResponsePacket(), e);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ws.status_secure_response", status2);
        }
        return info.getResponsePacket();
    }

    private static Subject getClientSubject(Packet p) {
        Subject s = null;
        if (p != null) {
            s = (Subject)p.invocationProperties.get("CLIENT_SUBJECT");
        }
        if (s == null) {
            s = PipeHelper.getClientSubject();
            if (p != null) {
                p.invocationProperties.put("CLIENT_SUBJECT", s);
            }
        }
        return s;
    }
}

