/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.InstanceResolver;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.ResourceInjector;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WSWebServiceContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.ws.Provider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InstanceResolverImpl<T>
extends InstanceResolver<T> {
    private final InstanceResolver<T> resolver;
    private final T instance;

    public InstanceResolverImpl(@NotNull Class<T> clasz) {
        this.instance = InstanceResolver.createNewInstance(clasz);
        this.resolver = InstanceResolver.createSingleton(this.instance);
    }

    @NotNull
    public T resolve(Packet request) {
        return (T)this.resolver.resolve(request);
    }

    public void start(WSWebServiceContext wsc, WSEndpoint endpoint) {
        this.getResourceInjector(endpoint).inject(wsc, this.instance);
    }

    public void dispose() {
        this.resolver.dispose();
    }

    private ResourceInjector getResourceInjector(WSEndpoint endpoint) {
        ResourceInjector ri = (ResourceInjector)endpoint.getContainer().getSPI(ResourceInjector.class);
        if (ri == null) {
            ri = ResourceInjector.STANDALONE;
        }
        return ri;
    }

    @NotNull
    public Invoker createInvoker() {
        return new Invoker(){

            public void start(@NotNull WSWebServiceContext wsc, @NotNull WSEndpoint endpoint) {
                InstanceResolverImpl.this.start(wsc, endpoint);
            }

            public void dispose() {
                InstanceResolverImpl.this.dispose();
            }

            public Object invoke(Packet p, Method m, Object ... args) throws InvocationTargetException, IllegalAccessException {
                return m.invoke(InstanceResolverImpl.this.resolve(p), args);
            }

            public <T> T invokeProvider(@NotNull Packet p, T arg) {
                return ((Provider)InstanceResolverImpl.this.resolve(p)).invoke(arg);
            }

            public String toString() {
                return "Default Invoker over " + ((Object)((Object)InstanceResolverImpl.this)).toString();
            }
        };
    }
}

