/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.webservice.WsUtil;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.handler.HandlerResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSServiceDelegate
extends Service {
    private ServiceReferenceDescriptor serviceRef;
    private Service serviceDelegate;
    private ClassLoader classLoader;
    private URL wsdlLocation;
    private boolean fullWsdl = false;
    private boolean noWsdl = false;
    private static final int ADD_PORT = 1;
    private static final int CREATE_DISPATCH_CLASS = 2;
    private static final int CREATE_DISPATCH_CONTEXT = 3;
    private static final int GET_EXECUTOR = 4;
    private static final int SET_EXECUTOR = 5;
    private static final int GET_HANDLER_RESOLVER = 6;
    private static final int GET_PORT_CONTAINER_MANAGED = 7;
    private static final int GET_PORT_CLIENT_MANAGED = 8;
    private static final int GET_PORTS = 9;
    private static final int GET_SERVICE_NAME = 10;
    private static final int SET_HANDLER_RESOLVER = 11;
    private static final int GET_WSDL_LOCATION = 12;
    private static final int GENERATED_SERVICE_METHOD = 13;
    private static Map serviceMethodTypes;
    private static Set fullWsdlIllegalMethods;
    private static Set noWsdlIllegalMethods;

    public JAXWSServiceDelegate(ServiceReferenceDescriptor descriptor, Service delegate, ClassLoader loader) throws Exception {
        super(new WsUtil().privilegedGetServiceRefWsdl(descriptor), descriptor.getServiceName());
        this.serviceRef = descriptor;
        this.serviceDelegate = delegate;
        this.classLoader = loader;
        if (this.serviceRef.hasWsdlFile()) {
            this.wsdlLocation = new WsUtil().privilegedGetServiceRefWsdl(this.serviceRef);
            this.fullWsdl = true;
        } else {
            this.noWsdl = true;
        }
    }

    @Override
    public void addPort(QName q, String id, String addr) {
        this.checkUnsupportedMethods(1);
        this.serviceDelegate.addPort(q, id, addr);
    }

    @Override
    public <T> Dispatch<T> createDispatch(QName qName, Class<T> aClass, Service.Mode mode) {
        this.checkUnsupportedMethods(2);
        return null;
    }

    @Override
    public Dispatch<Object> createDispatch(QName qName, JAXBContext jaxbContext, Service.Mode mode) {
        this.checkUnsupportedMethods(3);
        return null;
    }

    @Override
    public Executor getExecutor() {
        this.checkUnsupportedMethods(4);
        return this.serviceDelegate.getExecutor();
    }

    @Override
    public void setExecutor(Executor obj) {
        this.checkUnsupportedMethods(5);
        this.serviceDelegate.setExecutor(obj);
    }

    @Override
    public HandlerResolver getHandlerResolver() {
        this.checkUnsupportedMethods(6);
        return this.serviceDelegate.getHandlerResolver();
    }

    public Object getPort(QName q, Class sei) {
        this.checkUnsupportedMethods(8);
        return this.serviceDelegate.getPort(q, sei);
    }

    public Object getPort(Class sei) {
        this.checkUnsupportedMethods(7);
        String serviceEndpointInterface = sei.getName();
        ServiceRefPortInfo portInfo = this.serviceRef.getPortInfo(serviceEndpointInterface);
        Object retVal = portInfo != null && portInfo.hasWsdlPort() ? this.getPort(portInfo.getWsdlPort(), sei) : this.serviceDelegate.getPort(sei);
        return retVal;
    }

    public Iterator getPorts() {
        this.checkUnsupportedMethods(9);
        return this.serviceDelegate.getPorts();
    }

    @Override
    public QName getServiceName() {
        this.checkUnsupportedMethods(10);
        return this.serviceRef.getServiceName();
    }

    @Override
    public void setHandlerResolver(HandlerResolver resolver) {
        this.checkUnsupportedMethods(11);
        this.serviceDelegate.setHandlerResolver(resolver);
    }

    @Override
    public URL getWSDLDocumentLocation() {
        this.checkUnsupportedMethods(11);
        return this.wsdlLocation;
    }

    private static void Init() {
        serviceMethodTypes = new HashMap();
        fullWsdlIllegalMethods = new HashSet();
        noWsdlIllegalMethods = new HashSet();
        try {
            Class[] noParams = new Class[]{};
            Class<Service> serviceClass = Service.class;
            Method addPort = serviceClass.getDeclaredMethod("addPort", QName.class, URI.class, String.class);
            serviceMethodTypes.put(addPort, new Integer(1));
            Method createDispatchClass = serviceClass.getDeclaredMethod("createDispatch", QName.class, Class.class, Service.Mode.class);
            serviceMethodTypes.put(createDispatchClass, new Integer(2));
            Method createDispatchContext = serviceClass.getDeclaredMethod("createDispatch", QName.class, JAXBContext.class, Service.Mode.class);
            serviceMethodTypes.put(createDispatchContext, new Integer(3));
            Method getExecutor = serviceClass.getDeclaredMethod("getExecutor", noParams);
            serviceMethodTypes.put(getExecutor, new Integer(4));
            Method setExecutor = serviceClass.getDeclaredMethod("setExecutor", Executor.class);
            serviceMethodTypes.put(setExecutor, new Integer(5));
            Method getHandlerResolver = serviceClass.getDeclaredMethod("getHandlerResolver", noParams);
            serviceMethodTypes.put(getHandlerResolver, new Integer(6));
            Method getPortContainerManaged = serviceClass.getDeclaredMethod("getPort", Class.class);
            serviceMethodTypes.put(getPortContainerManaged, new Integer(7));
            Method getPortClientManaged = serviceClass.getDeclaredMethod("getPort", QName.class, Class.class);
            serviceMethodTypes.put(getPortClientManaged, new Integer(8));
            Method getPorts = serviceClass.getDeclaredMethod("getPorts", noParams);
            serviceMethodTypes.put(getPorts, new Integer(9));
            Method getServiceName = serviceClass.getDeclaredMethod("getServiceName", noParams);
            serviceMethodTypes.put(getServiceName, new Integer(10));
            Method setHandlerResolver = serviceClass.getDeclaredMethod("setHandlerResolver", HandlerResolver.class);
            serviceMethodTypes.put(setHandlerResolver, new Integer(11));
            Method getWsdlLocation = serviceClass.getDeclaredMethod("getWSDLDocumentLocation", noParams);
            serviceMethodTypes.put(getWsdlLocation, new Integer(12));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        noWsdlIllegalMethods.add(new Integer(7));
        noWsdlIllegalMethods.add(new Integer(8));
        noWsdlIllegalMethods.add(new Integer(9));
        noWsdlIllegalMethods.add(new Integer(10));
        noWsdlIllegalMethods.add(new Integer(12));
        noWsdlIllegalMethods.add(new Integer(13));
    }

    private void checkUnsupportedMethods(int methodType) throws UnsupportedOperationException {
        Set illegalMethods;
        Set set = illegalMethods = this.fullWsdl ? fullWsdlIllegalMethods : noWsdlIllegalMethods;
        if (illegalMethods.contains(new Integer(methodType))) {
            throw new UnsupportedOperationException();
        }
    }

    static {
        JAXWSServiceDelegate.Init();
    }
}

