/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.server.BoundEndpoint;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.http.servlet.ServletModule;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSServletModule
extends ServletModule {
    private static final Hashtable<String, JAXWSServletModule> modules = new Hashtable();
    private final Hashtable<String, BoundEndpoint> endpoints = new Hashtable();
    private final String contextPath;

    public static synchronized JAXWSServletModule getServletModule(String contextPath) {
        JAXWSServletModule ret = modules.get(contextPath);
        if (ret == null) {
            ret = new JAXWSServletModule(contextPath);
            modules.put(contextPath, ret);
        }
        return ret;
    }

    private JAXWSServletModule(String contextPath) {
        this.contextPath = contextPath;
    }

    public void addEndpoint(String uri, WSEndpoint endpoint) {
        this.endpoints.put(uri, new JAXWSBoundEndpoint(uri, endpoint));
    }

    @NotNull
    public List<BoundEndpoint> getBoundEndpoints() {
        return new ArrayList<BoundEndpoint>(this.endpoints.values());
    }

    @NotNull
    public String getContextPath() {
        return this.contextPath;
    }

    private static class JAXWSBoundEndpoint
    implements BoundEndpoint {
        private final String address;
        private final WSEndpoint endpoint;

        public JAXWSBoundEndpoint(String address, WSEndpoint endpoint) {
            this.address = address;
            this.endpoint = endpoint;
        }

        @NotNull
        public WSEndpoint getEndpoint() {
            return this.endpoint;
        }

        @NotNull
        public URI getAddress() {
            return this.stringToURI(this.address);
        }

        @NotNull
        public URI getAddress(String baseAddress) {
            return this.stringToURI(this.address);
        }

        private final URI stringToURI(String s) {
            try {
                return new URI(s);
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
    }
}

