/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice.monitoring;

import com.sun.enterprise.webservice.monitoring.EndpointImpl;
import com.sun.enterprise.webservice.monitoring.EndpointType;
import com.sun.enterprise.webservice.monitoring.HttpRequestInfoImpl;
import com.sun.enterprise.webservice.monitoring.MessageListener;
import com.sun.enterprise.webservice.monitoring.MessageTraceImpl;
import com.sun.enterprise.webservice.monitoring.ThreadLocalInfo;
import com.sun.enterprise.webservice.monitoring.TransportInfo;
import com.sun.enterprise.webservice.monitoring.WebServiceEngineImpl;
import com.sun.xml.rpc.spi.runtime.SOAPMessageContext;
import com.sun.xml.rpc.spi.runtime.SystemHandlerDelegate;

public class JAXRPCEndpointImpl
extends EndpointImpl
implements SystemHandlerDelegate {
    SystemHandlerDelegate parent = null;

    JAXRPCEndpointImpl(String endpointSelector, EndpointType type) {
        super(endpointSelector, type);
    }

    public boolean processRequest(SOAPMessageContext messageContext) {
        boolean status2 = true;
        if (this.parent != null) {
            status2 = this.parent.processRequest(messageContext);
        }
        WebServiceEngineImpl wsEngine = WebServiceEngineImpl.getInstance();
        try {
            if (!this.listeners.isEmpty() || wsEngine.hasGlobalMessageListener()) {
                ThreadLocalInfo config = (ThreadLocalInfo)wsEngine.getThreadLocal().get();
                if (config != null && config.getMessageId() != null) {
                    HttpRequestInfoImpl info = new HttpRequestInfoImpl(config.getRequest());
                    wsEngine.processRequest(config.getMessageId(), messageContext, (TransportInfo)info);
                }
                if (!this.listeners.isEmpty()) {
                    if (config == null) {
                        config = new ThreadLocalInfo(null, null);
                    }
                    MessageTraceImpl request = new MessageTraceImpl();
                    request.setEndpoint(this);
                    request.setMessageContext(messageContext);
                    if (config.getRequest() != null) {
                        request.setTransportInfo(new HttpRequestInfoImpl(config.getRequest()));
                    }
                    config.setRequestMessageTrace(request);
                }
            }
        }
        catch (Throwable t) {
            WebServiceEngineImpl.sLogger.warning("Exception while tracing request : " + t.getMessage());
            RuntimeException re = t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
            throw re;
        }
        return status2;
    }

    public void processResponse(SOAPMessageContext messageContext) {
        WebServiceEngineImpl wsEngine = WebServiceEngineImpl.getInstance();
        try {
            ThreadLocalInfo config;
            if ((wsEngine.hasGlobalMessageListener() || !this.listeners.isEmpty()) && (config = (ThreadLocalInfo)wsEngine.getThreadLocal().get()) != null) {
                if (config.getMessageId() != null) {
                    wsEngine.processResponse(config.getMessageId(), messageContext);
                }
                if (!this.listeners.isEmpty()) {
                    MessageTraceImpl response = new MessageTraceImpl();
                    response.setEndpoint(this);
                    response.setMessageContext(messageContext);
                    for (MessageListener listener : this.listeners) {
                        listener.invocationProcessed(config.getRequestMessageTrace(), response);
                    }
                }
            }
            wsEngine.getThreadLocal().remove();
            if (this.parent != null) {
                this.parent.processResponse(messageContext);
            }
        }
        catch (Throwable t) {
            WebServiceEngineImpl.sLogger.warning("Exception while tracing response : " + t.getMessage());
            RuntimeException re = t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
            throw re;
        }
    }

    public void setParent(SystemHandlerDelegate parent) {
        this.parent = parent;
    }
}

