/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.cometd;

import com.sun.enterprise.web.connector.grizzly.comet.CometContext;
import com.sun.enterprise.web.connector.grizzly.comet.CometEvent;
import com.sun.grizzly.cometd.BayeuxCometHandlerBase;
import com.sun.grizzly.cometd.CometdContext;
import com.sun.grizzly.cometd.CometdRequest;
import com.sun.grizzly.cometd.CometdResponse;
import com.sun.grizzly.cometd.DataHandler;
import com.sun.grizzly.cometd.bayeux.Connect;
import com.sun.grizzly.cometd.bayeux.Data;
import com.sun.grizzly.cometd.bayeux.Disconnect;
import com.sun.grizzly.cometd.bayeux.Handshake;
import com.sun.grizzly.cometd.bayeux.Reconnect;
import com.sun.grizzly.cometd.bayeux.Subscribe;
import com.sun.grizzly.cometd.bayeux.Unsubscribe;
import com.sun.grizzly.cometd.bayeux.Verb;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public class BayeuxCometHandler
extends BayeuxCometHandlerBase {
    public static final String DEFAULT_CONTENT_TYPE = "application/json-comment-filtered";
    public static final String BAYEUX_COMET_HANDLER = "bayeuxCometHandler";
    private ConcurrentHashMap<String, String> activeChannels = new ConcurrentHashMap();
    private Random random = new Random();
    private ConcurrentHashMap<String, DataHandler> activeCometHandlers = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHandshake(CometEvent event) throws IOException {
        CometdContext cometdContext = (CometdContext)event.attachment();
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        Handshake handshake = (Handshake)cometdContext.getVerb();
        boolean handshakeOK = true;
        String clientId = "";
        Random random = this.random;
        synchronized (random) {
            clientId = String.valueOf(Long.toHexString(this.random.nextLong()));
        }
        if (handshakeOK) {
            handshake.setClientId(clientId);
        }
        res.setContentType(DEFAULT_CONTENT_TYPE);
        res.write(handshake.toJSON());
        res.flush();
    }

    public void onConnect(CometEvent event) throws IOException {
        CometdContext cometdContext = (CometdContext)event.attachment();
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        Connect connect = (Connect)cometdContext.getVerb();
        String subscribedChannel = this.activeChannels.get(connect.getClientId());
        if (subscribedChannel != null) {
            CometContext cometContext = event.getCometContext();
            DataHandler dataHandler = new DataHandler();
            dataHandler.attach(new Object[]{req, res});
            dataHandler.setChannel(this.activeChannels.get(connect.getClientId()));
            dataHandler.setClientId(connect.getClientId());
            this.activeCometHandlers.put(connect.getClientId(), dataHandler);
            event.getCometContext().addCometHandler(dataHandler);
            connect.setAdvice(null);
        }
        String jsonMessage = subscribedChannel != null ? connect.toLongPolledJSON() : connect.toJSON();
        res.setContentType(DEFAULT_CONTENT_TYPE);
        res.write(jsonMessage);
        res.flush();
    }

    public void onDisconnect(CometEvent event) throws IOException {
        CometdContext cometdContext = (CometdContext)event.attachment();
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        Disconnect disconnect = (Disconnect)cometdContext.getVerb();
        DataHandler dataHandler = this.activeCometHandlers.remove(disconnect.getClientId());
        if (dataHandler != null) {
            event.getCometContext().notify("disconnecting", 3, dataHandler.hashCode());
        }
        res.setContentType(DEFAULT_CONTENT_TYPE);
        res.write(disconnect.toJSON());
        res.flush();
    }

    public void onReconnect(CometEvent event) throws IOException {
        CometdContext cometdContext = (CometdContext)event.attachment();
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        Reconnect reconnect = (Reconnect)cometdContext.getVerb();
        res.setContentType(DEFAULT_CONTENT_TYPE);
        res.write(reconnect.toJSON());
        res.flush();
    }

    public void onSubscribe(CometEvent event) throws IOException {
        CometdContext cometdContext = (CometdContext)event.attachment();
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        Subscribe subscribe = (Subscribe)cometdContext.getVerb();
        Data data = subscribe.getData();
        if (data != null) {
            subscribe.setDataId(data.getId());
            this.activeChannels.put(subscribe.getClientId(), data.getChannel());
            event.getCometContext().notify(data);
        }
        res.setContentType(DEFAULT_CONTENT_TYPE);
        res.write(subscribe.toJSON());
        res.flush();
    }

    public void onUnsubscribe(CometEvent event) throws IOException {
        CometdContext cometdContext = (CometdContext)event.attachment();
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        Unsubscribe unsubscribe = (Unsubscribe)cometdContext.getVerb();
        Data data = unsubscribe.getData();
        if (data != null) {
            unsubscribe.setDataId(data.getId());
            this.activeChannels.remove(unsubscribe.getClientId());
            event.getCometContext().notify(data);
        }
        res.setContentType(DEFAULT_CONTENT_TYPE);
        res.write(unsubscribe.toJSON());
        res.flush();
    }

    public void onData(CometEvent event) throws IOException {
        CometdContext cometdContext = (CometdContext)event.attachment();
        CometdRequest req = cometdContext.getRequest();
        CometdResponse res = cometdContext.getResponse();
        Data data = (Data)cometdContext.getVerb();
        res.setContentType(DEFAULT_CONTENT_TYPE);
        res.write(data.toJSON());
        res.flush();
        event.getCometContext().notify(data);
    }

    public static final CometdContext newCometdContext(final CometdRequest req, final CometdResponse res, final Verb verb) {
        return new CometdContext(){

            public Verb getVerb() {
                return verb;
            }

            public CometdRequest getRequest() {
                return req;
            }

            public CometdResponse getResponse() {
                return res;
            }
        };
    }

    public void onTerminate(CometEvent event) throws IOException {
        this.onInterrupt(event);
    }

    public void onInterrupt(CometEvent event) throws IOException {
    }

    public void onPing(CometEvent event) throws IOException {
    }

    public void onStatus(CometEvent event) throws IOException {
    }

    public String getChannel() {
        return BAYEUX_COMET_HANDLER;
    }

    public void setChannel(String channel) {
    }
}

