/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.cometd.bayeux;

import com.sun.grizzly.cometd.bayeux.Advice;
import com.sun.grizzly.cometd.bayeux.Connect;
import com.sun.grizzly.cometd.bayeux.Data;
import com.sun.grizzly.cometd.bayeux.Disconnect;
import com.sun.grizzly.cometd.bayeux.Ext;
import com.sun.grizzly.cometd.bayeux.Handshake;
import com.sun.grizzly.cometd.bayeux.Ping;
import com.sun.grizzly.cometd.bayeux.Reconnect;
import com.sun.grizzly.cometd.bayeux.Status;
import com.sun.grizzly.cometd.bayeux.Subscribe;
import com.sun.grizzly.cometd.bayeux.Unsubscribe;
import com.sun.grizzly.cometd.bayeux.Verb;
import com.sun.grizzly.cometd.bayeux.VerbBase;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

public class VerbUtils {
    private static final String META = "/meta";
    private static final String HANDSHAKE = "/handshake";
    private static final String CONNECT = "/connect";
    private static final String DISCONNECT = "/disconnect";
    private static final String RECONNECT = "/reconnect";
    private static final String SUBSCRIBE = "/subscribe";
    private static final String UNSUBSCRIBE = "/unsubscribe";
    private static final String STATUS = "/status";
    private static final String PING = "/ping";
    private static final String DATA = "data";

    public static Verb parse(Object verb) {
        VerbBase wellFormedVerb = null;
        if (verb.getClass().isArray()) {
            int length = Array.getLength(verb);
            for (int i = 0; i < length; ++i) {
                wellFormedVerb = VerbUtils.parseMap((Map)Array.get(verb, i), wellFormedVerb);
            }
        }
        if (wellFormedVerb == null) {
            throw new RuntimeException("Wrong type");
        }
        return wellFormedVerb;
    }

    protected static VerbBase parseMap(Map map, VerbBase wellFormedVerb) {
        String channel = (String)map.get("channel");
        if (map.get(DATA) != null) {
            Data data = VerbUtils.newData(map);
            if (wellFormedVerb != null) {
                wellFormedVerb.setData(data);
                return wellFormedVerb;
            }
            return data;
        }
        VerbBase vb = null;
        if (channel.indexOf(HANDSHAKE) != -1) {
            vb = VerbUtils.newHandshake(map);
        } else if (channel.indexOf(CONNECT) != -1) {
            vb = VerbUtils.newConnect(map);
        } else if (channel.indexOf(DISCONNECT) != -1) {
            vb = VerbUtils.newDisconnect(map);
        } else if (channel.indexOf(RECONNECT) != -1) {
            vb = VerbUtils.newReconnect(map);
        } else if (channel.indexOf(SUBSCRIBE) != -1) {
            vb = VerbUtils.newSubscribe(map);
        } else if (channel.indexOf(UNSUBSCRIBE) != -1) {
            vb = VerbUtils.newUnsubscribe(map);
        } else if (channel.indexOf(PING) != -1) {
            vb = VerbUtils.newPing(map);
        } else if (channel.indexOf(STATUS) != -1) {
            vb = VerbUtils.newStatus(map);
        }
        VerbUtils.configureExt(vb, map);
        return vb;
    }

    private static final Handshake newHandshake(Map map) {
        Handshake handshake = new Handshake();
        handshake.setAuthScheme((String)map.get("authScheme"));
        handshake.setAuthUser((String)map.get("authUser"));
        handshake.setAuthToken((String)map.get("authToken"));
        handshake.setChannel((String)map.get("channel"));
        handshake.setVersion((String)map.get("version"));
        handshake.setMinimumVersion((String)map.get("minimumVersion"));
        handshake.setId((String)map.get("id"));
        handshake.setAdvice(new Advice());
        return handshake;
    }

    private static final Connect newConnect(Map map) {
        Connect connect = new Connect();
        connect.setAuthToken((String)map.get("authToken"));
        connect.setChannel((String)map.get("channel"));
        connect.setClientId((String)map.get("clientId"));
        connect.setConnectionType((String)map.get("connectionType"));
        connect.setId((String)map.get("id"));
        connect.setAdvice(new Advice());
        return connect;
    }

    private static final Disconnect newDisconnect(Map map) {
        Disconnect disconnect = new Disconnect();
        disconnect.setAuthToken((String)map.get("authToken"));
        disconnect.setChannel((String)map.get("channel"));
        disconnect.setClientId((String)map.get("clientId"));
        disconnect.setId((String)map.get("id"));
        disconnect.setConnectionType((String)map.get("connectionType"));
        return disconnect;
    }

    private static final Reconnect newReconnect(Map map) {
        Reconnect reconnect = new Reconnect();
        reconnect.setAuthToken((String)map.get("authToken"));
        reconnect.setChannel((String)map.get("channel"));
        reconnect.setClientId((String)map.get("clientId"));
        reconnect.setId((String)map.get("id"));
        reconnect.setConnectionType((String)map.get("connectionType"));
        return reconnect;
    }

    private static final Data newData(Map map) {
        Data data = new Data();
        data.setChannel((String)map.get("channel"));
        data.setClientId((String)map.get("clientId"));
        data.setMapData((HashMap)map.get(DATA));
        data.setId((String)map.get("id"));
        return data;
    }

    private static final Subscribe newSubscribe(Map map) {
        Subscribe subscribe = new Subscribe();
        subscribe.setChannel((String)map.get("channel"));
        subscribe.setAuthToken((String)map.get("authToken"));
        subscribe.setSubscription((String)map.get("subscription"));
        subscribe.setClientId((String)map.get("clientId"));
        subscribe.setId((String)map.get("id"));
        return subscribe;
    }

    private static final Unsubscribe newUnsubscribe(Map map) {
        Unsubscribe unsubscribe = new Unsubscribe();
        unsubscribe.setChannel((String)map.get("channel"));
        unsubscribe.setAuthToken((String)map.get("authToken"));
        unsubscribe.setSubscription((String)map.get("subscription"));
        unsubscribe.setClientId((String)map.get("clientId"));
        unsubscribe.setId((String)map.get("id"));
        return unsubscribe;
    }

    private static final Ping newPing(Map map) {
        Ping ping = new Ping();
        ping.setChannel((String)map.get("channel"));
        return ping;
    }

    private static final Status newStatus(Map map) {
        Status status2 = new Status();
        status2.setChannel((String)map.get("channel"));
        return status2;
    }

    private static void configureExt(VerbBase vb, Map map) {
        Map extMap = (Map)map.get("ext");
        if (extMap == null) {
            return;
        }
        Ext ext = new Ext();
        ext.setExtensionMap(extMap);
        vb.setExt(ext);
    }
}

