/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.CompletionHandler;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.ControlImpl;
import com.sun.jts.CosTransactions.CoordinatorImpl;
import com.sun.jts.CosTransactions.CoordinatorLog;
import com.sun.jts.CosTransactions.CoordinatorLogPool;
import com.sun.jts.CosTransactions.CoordinatorResourceImpl;
import com.sun.jts.CosTransactions.CoordinatorSynchronizationImpl;
import com.sun.jts.CosTransactions.DelegatedRecoveryManager;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.CosTransactions.LogDBHelper;
import com.sun.jts.CosTransactions.LogicErrorException;
import com.sun.jts.CosTransactions.NestingInfo;
import com.sun.jts.CosTransactions.RecoveryCoordinatorImpl;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.jts.CosTransactions.RegisteredResources;
import com.sun.jts.CosTransactions.RegisteredSyncs;
import com.sun.jts.CosTransactions.SubCoordinator;
import com.sun.jts.CosTransactions.SuperiorInfo;
import com.sun.jts.CosTransactions.TerminatorImpl;
import com.sun.jts.CosTransactions.TimeoutManager;
import com.sun.jts.CosTransactions.TransactionState;
import com.sun.jts.CosTransactions.TxInflowRecoveryCoordinator;
import com.sun.jts.jta.SynchronizationImpl;
import com.sun.jts.jtsxa.OTSResourceImpl;
import com.sun.jts.otsidl.CoordinatorResource;
import com.sun.jts.otsidl.JCoordinator;
import com.sun.jts.otsidl.JCoordinatorHelper;
import com.sun.jts.utils.LogFormatter;
import com.sun.logging.LogDomains;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.CoordinatorHelper;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.NotSubtransaction;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.SynchronizationUnavailable;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.Unavailable;
import org.omg.CosTransactions.Vote;
import org.omg.CosTransactions.otid_t;

public class TopCoordinator
extends CoordinatorImpl {
    String name = null;
    RegisteredResources participants = null;
    RegisteredSyncs synchronizations = null;
    SuperiorInfo superInfo = null;
    NestingInfo nestingInfo = null;
    TransactionState tranState = null;
    CoordinatorLog logRecord = null;
    CompletionHandler terminator = null;
    boolean registered = false;
    boolean registeredSync = false;
    boolean root = true;
    boolean rollbackOnly = false;
    boolean dying = false;
    boolean temporary = false;
    int hash = 0;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.transaction");
    Vector recoveryCoordinatorList = null;
    CoordinatorSynchronizationImpl coordSyncImpl = null;
    boolean delegated = false;
    String logPath = null;
    static String[] resultName = new String[]{"Commit", "Rollback", "Read-only"};
    private static Any emptyData = null;

    TopCoordinator() {
    }

    TopCoordinator(int timeOut) throws LogicErrorException {
        this.logRecord = Configuration.isRecoverable() ? CoordinatorLogPool.getCoordinatorLog() : null;
        this.tranState = new TransactionState(this.logRecord);
        this.superInfo = new SuperiorInfo(this.tranState.localTID, this.tranState.globalTID, null, this.logRecord);
        this.hash = this.superInfo.globalTID.hashCode();
        this.nestingInfo = null;
        this.participants = null;
        this.synchronizations = null;
        this.root = true;
        this.registered = true;
        this.registeredSync = true;
        this.rollbackOnly = false;
        this.dying = false;
        this.temporary = false;
        this.terminator = null;
        if (!this.tranState.setState(1)) {
            LogicErrorException exc = new LogicErrorException(LogFormatter.getLocalizedMessage(_logger, "jts.invalid_state_change"));
            throw exc;
        }
        if (!RecoveryManager.addCoordinator(this.tranState.globalTID, this.tranState.localTID, this, timeOut)) {
            LogicErrorException exc = new LogicErrorException(LogFormatter.getLocalizedMessage(_logger, "jts.transaction_id_already_in_use"));
            throw exc;
        }
    }

    TopCoordinator(int timeOut, GlobalTID globalTID, Coordinator superior, boolean temporary) throws LogicErrorException {
        this.logRecord = Configuration.isRecoverable() ? CoordinatorLogPool.getCoordinatorLog() : null;
        this.tranState = new TransactionState(globalTID, this.logRecord);
        this.superInfo = new SuperiorInfo(this.tranState.localTID, this.tranState.globalTID, superior, this.logRecord);
        this.hash = this.superInfo.globalTID.hashCode();
        this.nestingInfo = null;
        this.participants = null;
        this.synchronizations = null;
        this.root = false;
        this.registered = false;
        this.registeredSync = false;
        this.rollbackOnly = false;
        this.dying = false;
        this.temporary = temporary;
        this.terminator = null;
        if (!this.tranState.setState(1)) {
            LogicErrorException exc = new LogicErrorException(LogFormatter.getLocalizedMessage(_logger, "jts.invalid_state_change"));
            throw exc;
        }
        if (!RecoveryManager.addCoordinator(globalTID, this.tranState.localTID, this, timeOut)) {
            LogicErrorException exc = new LogicErrorException(LogFormatter.getLocalizedMessage(_logger, "jts.transaction_id_already_in_use"));
            throw exc;
        }
    }

    public synchronized void doFinalize() {
        this.dying = true;
        int state = 9;
        if (this.tranState != null && !this.temporary) {
            state = this.tranState.state;
        }
        switch (state) {
            case 1: {
                try {
                    this.rollback(true);
                }
                catch (Throwable throwable) {}
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                if (this.superInfo != null) {
                    this.superInfo.doFinalize();
                }
                this.tranState = null;
                this.superInfo = null;
                this.nestingInfo = null;
                this.participants = null;
                this.synchronizations = null;
                this.logRecord = null;
                this.terminator = null;
                this.name = null;
                break;
            }
        }
    }

    synchronized void reconstruct(CoordinatorLog log) {
        this.rollbackOnly = false;
        this.registered = false;
        this.registeredSync = false;
        this.root = false;
        this.dying = false;
        this.temporary = false;
        this.terminator = null;
        this.logRecord = log;
        this.name = null;
        this.nestingInfo = null;
        this.synchronizations = null;
        this.tranState = new TransactionState();
        int state = this.tranState.reconstruct(log);
        if (state == 0 || state == 7 || state == 9) {
            CoordinatorLog.removeLog(log.localTID);
            this.destroy();
        } else {
            this.participants = new RegisteredResources(this);
            this.participants.reconstruct(log);
            this.superInfo = new SuperiorInfo();
            this.superInfo.reconstruct(log, this);
            this.name = this.superInfo.globalTID.toString();
            this.hash = this.superInfo.globalTID.hashCode();
        }
    }

    synchronized void delegated_reconstruct(CoordinatorLog log, String logPath) {
        this.rollbackOnly = false;
        this.registered = false;
        this.registeredSync = false;
        this.root = false;
        this.dying = false;
        this.temporary = false;
        this.terminator = null;
        this.logRecord = log;
        this.name = null;
        this.nestingInfo = null;
        this.synchronizations = null;
        this.delegated = true;
        this.logPath = logPath;
        this.tranState = new TransactionState();
        int state = this.tranState.reconstruct(log);
        if (state == 0 || state == 7 || state == 9) {
            CoordinatorLog.removeLog(log.localTID, logPath);
            this.destroy();
        } else {
            this.participants = new RegisteredResources(this);
            this.participants.reconstruct(log);
            this.superInfo = new SuperiorInfo();
            this.superInfo.delegated_reconstruct(log, this, logPath);
            this.name = this.superInfo.globalTID.toString();
            this.hash = this.superInfo.globalTID.hashCode();
        }
    }

    synchronized Status recover(boolean[] isRoot) {
        Status result;
        if (this.superInfo.recovery != null) {
            switch (this.tranState.state) {
                case 6: 
                case 7: 
                case 10: 
                case 11: 
                case 12: {
                    result = Status.StatusCommitted;
                    break;
                }
                case 8: 
                case 9: {
                    result = Status.StatusRolledBack;
                    break;
                }
                default: {
                    boolean attemptRetry = true;
                    int commitRetries = Configuration.getRetries();
                    if (commitRetries >= 0 && this.superInfo.resyncRetries() >= commitRetries) {
                        attemptRetry = false;
                    }
                    if (!attemptRetry) {
                        boolean commitTransaction = false;
                        result = Status.StatusRolledBack;
                        String heuristicVar = Configuration.getPropertyValue("com.sun.jts.heuristicDirection");
                        if (heuristicVar != null) {
                            boolean bl = commitTransaction = heuristicVar.charAt(0) == '1';
                        }
                        if (!commitTransaction) break;
                        result = Status.StatusCommitted;
                        break;
                    }
                    try {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.logp(Level.FINE, "TopCoordinator", "recover", "Before invoking replay_completion on Superior Coordinator");
                        }
                        if ((result = !this.delegated ? this.superInfo.recovery.replay_completion(this.superInfo.resource) : ((RecoveryCoordinatorImpl)((java.lang.Object)this.superInfo.recovery)).replay_completion(this.superInfo.resource, this.logPath)) != Status.StatusCommitting) break;
                        result = Status.StatusCommitted;
                        break;
                    }
                    catch (Throwable exc) {
                        result = !(exc instanceof COMM_FAILURE) && !(exc instanceof TRANSIENT) ? Status.StatusRolledBack : Status.StatusUnknown;
                    }
                }
            }
            this.root = false;
        } else {
            result = this.tranState.state == 3 ? Status.StatusCommitted : Status.StatusRolledBack;
            this.root = true;
        }
        isRoot[0] = this.root;
        return result;
    }

    public Status get_status() {
        Status result = Status.StatusUnknown;
        if (this.tranState != null) {
            switch (this.tranState.state) {
                case 1: {
                    if (this.rollbackOnly) {
                        result = Status.StatusMarkedRollback;
                        break;
                    }
                    result = Status.StatusActive;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    result = Status.StatusPrepared;
                    break;
                }
                case 0: {
                    result = Status.StatusNoTransaction;
                    break;
                }
                case 2: 
                case 10: {
                    result = Status.StatusPreparing;
                    break;
                }
                case 6: {
                    result = Status.StatusCommitting;
                    break;
                }
                case 7: 
                case 11: 
                case 13: 
                case 14: {
                    result = Status.StatusCommitted;
                    break;
                }
                case 8: 
                case 12: {
                    result = Status.StatusRollingBack;
                    break;
                }
                case 9: {
                    result = Status.StatusRolledBack;
                    break;
                }
                default: {
                    result = Status.StatusUnknown;
                    break;
                }
            }
        } else {
            INVALID_TRANSACTION exc = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        return result;
    }

    public Status get_parent_status() {
        Status result = this.get_status();
        return result;
    }

    public Status get_top_level_status() {
        Status result = this.get_status();
        return result;
    }

    public boolean is_same_transaction(Coordinator other) throws SystemException {
        boolean result = false;
        if (this.tranState != null) {
            if (this.name == null) {
                this.name = this.superInfo.globalTID.toString();
            }
        } else {
            INVALID_TRANSACTION exc = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        result = this.name.equals(other.get_transaction_name());
        return result;
    }

    public boolean is_related_transaction(Coordinator other) throws SystemException {
        boolean result = false;
        if (this.tranState == null) {
            INVALID_TRANSACTION exc = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        result = other.is_descendant_transaction(this.object());
        return result;
    }

    public boolean is_root_transaction() {
        boolean result = this.root;
        return result;
    }

    public boolean is_ancestor_transaction(Coordinator other) throws SystemException {
        boolean result = false;
        if (this.tranState == null) {
            INVALID_TRANSACTION exc = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        result = other.is_descendant_transaction(this.object());
        return result;
    }

    public boolean is_descendant_transaction(Coordinator other) throws SystemException {
        boolean result = false;
        if (this.tranState == null) {
            INVALID_TRANSACTION exc = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        result = this.is_same_transaction(other);
        return result;
    }

    public boolean is_top_level_transaction() {
        boolean result = true;
        return result;
    }

    public int hash_transaction() {
        int result = this.hash;
        if (this.tranState == null) {
            INVALID_TRANSACTION exc = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        return result;
    }

    public synchronized int hash_top_level_tran() {
        int result = this.hash;
        if (this.tranState == null) {
            INVALID_TRANSACTION exc = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        return result;
    }

    public synchronized RecoveryCoordinator register_resource(Resource res) throws Inactive, TRANSACTION_ROLLEDBACK {
        RecoveryCoordinator result = null;
        if (this.tranState == null || this.tranState.state != 1) {
            Inactive exc = new Inactive();
            throw exc;
        }
        if (this.rollbackOnly) {
            TRANSACTION_ROLLEDBACK exc = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        if (!this.registered) {
            CoordinatorResourceImpl cImpl = new CoordinatorResourceImpl(this.superInfo.globalTID, this, false);
            try {
                CoordinatorResource cRes = cImpl.object();
                RecoveryCoordinator superRecovery = this.superInfo.superior.register_resource(cRes);
                if (!(superRecovery instanceof TxInflowRecoveryCoordinator)) {
                    this.superInfo.setRecovery(superRecovery);
                }
                this.superInfo.setResource(cRes);
                this.registered = true;
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.logp(Level.FINEST, "TopCoordinator", "register_resource()", "CoordinatorResource " + cImpl + " has been registered with (Root)TopCoordinator" + this.superInfo.globalTID.toString());
                }
            }
            catch (Exception exc) {
                cImpl.destroy();
                if (exc instanceof OBJECT_NOT_EXIST) {
                    TRANSACTION_ROLLEDBACK ex2 = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
                    ex2.initCause((Throwable)exc);
                    throw ex2;
                }
                if (exc instanceof Inactive) {
                    throw (Inactive)((java.lang.Object)exc);
                }
                if (exc instanceof SystemException) {
                    throw (SystemException)((java.lang.Object)exc);
                }
                INTERNAL ex2 = new INTERNAL(263, CompletionStatus.COMPLETED_NO);
                ex2.initCause((Throwable)exc);
                throw ex2;
            }
        }
        if (this.participants == null) {
            this.participants = new RegisteredResources(this.logRecord, this);
        }
        int numRes = 0;
        if (res instanceof OTSResourceImpl) {
            numRes = this.participants.addRes(res);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.logp(Level.FINEST, "TopCoordinator", "register_resource()", "OTSResource " + res + " has been registered" + "GTID is:" + this.superInfo.globalTID.toString());
            }
        } else {
            numRes = this.participants.addRes((Resource)res._duplicate());
        }
        this.temporary = false;
        if (!(res instanceof OTSResourceImpl)) {
            RecoveryCoordinatorImpl rcImpl = null;
            try {
                rcImpl = new RecoveryCoordinatorImpl(this.superInfo.globalTID, numRes);
                result = rcImpl.object();
            }
            catch (Exception exc) {
                INTERNAL ex2 = new INTERNAL(264, CompletionStatus.COMPLETED_NO);
                throw ex2;
            }
            if (this.recoveryCoordinatorList == null) {
                this.recoveryCoordinatorList = new Vector();
            }
            this.recoveryCoordinatorList.add(rcImpl);
        }
        return result;
    }

    public synchronized void register_subtran_aware(SubtransactionAwareResource sares) throws NotSubtransaction {
        NotSubtransaction exc = new NotSubtransaction();
        throw exc;
    }

    public void rollback_only() throws Inactive {
        if (this.tranState == null || this.tranState.state != 1) {
            Inactive exc = new Inactive();
            throw exc;
        }
        this.rollbackOnly = true;
    }

    public String get_transaction_name() {
        String result = null;
        if (this.tranState != null) {
            if (this.name == null) {
                this.name = this.superInfo.globalTID.toString();
            }
        } else {
            INVALID_TRANSACTION exc = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        result = new String(this.name);
        return result;
    }

    public synchronized Control create_subtransaction() throws Inactive {
        Control result = null;
        if (this.tranState == null || this.tranState.state != 1) {
            Inactive exc = new Inactive();
            throw exc;
        }
        CoordinatorImpl[] ancestors = new CoordinatorImpl[]{this};
        SubCoordinator child = null;
        TerminatorImpl terminator = null;
        try {
            child = new SubCoordinator(this.superInfo.globalTID, this.superInfo.localTID, ancestors);
            terminator = new TerminatorImpl(child, true);
            result = new ControlImpl(terminator, child, new GlobalTID(child.getGlobalTID()), new Long(child.getLocalTID())).object();
        }
        catch (Throwable exc) {
            Inactive ex2 = new Inactive();
            throw ex2;
        }
        if (this.nestingInfo == null) {
            this.nestingInfo = new NestingInfo();
        }
        this.nestingInfo.addChild(child);
        return result;
    }

    public otid_t getGlobalTID() {
        otid_t result = this.superInfo.globalTID.realTID;
        return result;
    }

    public GlobalTID getGlobalTid() {
        return this.superInfo.globalTID;
    }

    public int getParticipantCount() {
        if (this.participants == null) {
            return 0;
        }
        return this.participants.numRegistered();
    }

    public long getLocalTID() {
        long result = this.superInfo.localTID;
        return result;
    }

    synchronized CoordinatorImpl replyAction(int[] action) throws SystemException {
        CoordinatorImpl result = null;
        action[0] = 1;
        if (!this.root && this.nestingInfo != null && this.nestingInfo.replyCheck()) {
            action[0] = 3;
        } else {
            if (!this.registered) {
                if (this.participants != null && this.participants.involved()) {
                    INTERNAL ex2 = new INTERNAL(263, CompletionStatus.COMPLETED_NO);
                    throw ex2;
                }
                if (!this.registeredSync) {
                    action[0] = 2;
                }
            }
            if (!this.registeredSync) {
                if (this.synchronizations != null && this.synchronizations.involved()) {
                    INTERNAL ex2 = new INTERNAL(263, CompletionStatus.COMPLETED_NO);
                    throw ex2;
                }
                if (action[0] == 1 && !this.registered) {
                    action[0] = 2;
                }
            }
        }
        result = null;
        return result;
    }

    synchronized Long setPermanent() {
        Long result = this.superInfo.localTID;
        this.temporary = false;
        return result;
    }

    public synchronized boolean isRollbackOnly() {
        boolean result = this.rollbackOnly;
        return result;
    }

    synchronized boolean isActive() {
        boolean result = this.tranState.state == 1;
        return result;
    }

    synchronized boolean hasRegistered() {
        boolean result = this.registered || this.registeredSync;
        return result;
    }

    public synchronized TransIdentity[] getAncestors() {
        return null;
    }

    synchronized boolean addChild(CoordinatorImpl child) {
        if (this.nestingInfo == null) {
            this.nestingInfo = new NestingInfo();
        }
        boolean result = this.nestingInfo.addChild(child);
        return result;
    }

    synchronized boolean removeChild(CoordinatorImpl child) {
        boolean result = false;
        if (this.nestingInfo != null) {
            result = this.nestingInfo.removeChild(child);
        }
        if (!(!this.temporary || this.registered || this.participants != null && this.participants.involved() || this.synchronizations != null && this.synchronizations.involved() || this.nestingInfo != null && this.nestingInfo.numChildren() > 0)) {
            this.cleanUpEmpty(null);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Vote prepare() throws INVALID_TRANSACTION, HeuristicMixed, HeuristicHazard {
        Vote result = Vote.VoteRollback;
        TopCoordinator topCoordinator = this;
        synchronized (topCoordinator) {
            if (this.root && this.nestingInfo != null && this.nestingInfo.numChildren() != 0) {
                INVALID_TRANSACTION exc = new INVALID_TRANSACTION(1, CompletionStatus.COMPLETED_NO);
                throw exc;
            }
            if (!this.tranState.setState(2)) {
                return Vote.VoteRollback;
            }
            if (this.rollbackOnly) {
                if (!this.tranState.setState(4)) {
                    // empty if block
                }
                return Vote.VoteRollback;
            }
        }
        Vote overallResult = Vote.VoteReadOnly;
        java.lang.Object heuristicExc = null;
        if (this.participants != null) {
            try {
                overallResult = this.participants.distributePrepare();
                if ((overallResult == Vote.VoteCommit || overallResult == Vote.VoteReadOnly) && this.participants.getLAOResource() != null) {
                    if (this.logRecord == null && Configuration.isDBLoggingEnabled() && !LogDBHelper.getInstance().addRecord(this.tranState.localTID, this.tranState.globalTID.toTidBytes())) {
                        overallResult = Vote.VoteRollback;
                    }
                    if (overallResult != Vote.VoteRollback) {
                        this.participants.getLAOResource().commit();
                    }
                }
            }
            catch (Throwable exc) {
                if (exc instanceof HeuristicMixed || exc instanceof HeuristicHazard) {
                    if (!this.tranState.setState(9)) {
                        // empty if block
                    }
                    if (!this.root) {
                        this.afterCompletion(Status.StatusRolledBack);
                    }
                    if (heuristicExc instanceof HeuristicMixed) {
                        throw (HeuristicMixed)heuristicExc;
                    }
                    throw (HeuristicHazard)heuristicExc;
                }
                overallResult = Vote.VoteRollback;
            }
        }
        TopCoordinator topCoordinator2 = this;
        synchronized (topCoordinator2) {
            if (this.rollbackOnly) {
                overallResult = Vote.VoteRollback;
            }
            if (overallResult == Vote.VoteReadOnly) {
                if (!this.tranState.setState(5)) {
                    overallResult = Vote.VoteRollback;
                }
                if (!this.root) {
                    this.afterCompletion(Status.StatusUnknown);
                }
            } else if (overallResult == Vote.VoteCommit) {
                int timeoutType = 0;
                if (!this.root) {
                    timeoutType = 2;
                }
                TimeoutManager.setTimeout(this.superInfo.localTID, timeoutType, 60);
                if (!this.tranState.setState(3)) {
                    overallResult = Vote.VoteRollback;
                }
            } else if (!this.tranState.setState(4)) {
                overallResult = Vote.VoteRollback;
            }
        }
        return overallResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit() throws HeuristicMixed, HeuristicHazard, NotPrepared {
        Throwable heuristicExc;
        block19: {
            TopCoordinator topCoordinator = this;
            synchronized (topCoordinator) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.logp(Level.FINE, "TopCoordinator", "commit()", "Within TopCoordinator.commit()GTID is :" + this.superInfo.globalTID.toString());
                }
                if (this.tranState.state == 5) {
                    return;
                }
                if (this.tranState.state == 7) {
                    return;
                }
                if (!this.tranState.setState(6)) {
                    _logger.log(Level.SEVERE, "jts.transaction_wrong_state", "commit");
                    String msg = LogFormatter.getLocalizedMessage(_logger, "jts.transaction_wrong_state", new java.lang.Object[]{"commit"});
                    throw new INTERNAL(msg);
                }
            }
            heuristicExc = null;
            if (this.participants != null) {
                try {
                    this.participants.distributeCommit();
                }
                catch (Throwable exc) {
                    if (exc instanceof HeuristicMixed || exc instanceof HeuristicHazard) {
                        heuristicExc = exc;
                    }
                    if (!(exc instanceof INTERNAL)) break block19;
                    throw (INTERNAL)exc;
                }
            }
        }
        TopCoordinator topCoordinator = this;
        synchronized (topCoordinator) {
            if (!this.tranState.setState(7)) {
                _logger.log(Level.SEVERE, "jts.transaction_wrong_state", "commit");
                String msg = LogFormatter.getLocalizedMessage(_logger, "jts.transaction_wrong_state", new java.lang.Object[]{"commit"});
                throw new INTERNAL(msg);
            }
            if (this.terminator != null) {
                this.terminator.setCompleted(false, heuristicExc != null);
            }
            if (!this.root) {
                this.afterCompletion(Status.StatusCommitted);
            }
            if (heuristicExc != null) {
                if (heuristicExc instanceof HeuristicMixed) {
                    throw (HeuristicMixed)((java.lang.Object)heuristicExc);
                }
                throw (HeuristicHazard)((java.lang.Object)heuristicExc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollback(boolean force) throws HeuristicMixed, HeuristicHazard {
        Throwable heuristicExc;
        block22: {
            TopCoordinator topCoordinator = this;
            synchronized (topCoordinator) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.logp(Level.FINE, "TopCoordinator", "rollback()", "Within TopCoordinator.rollback() :GTID is : " + this.superInfo.globalTID.toString());
                }
                if (this.tranState == null) {
                    return;
                }
                if (this.tranState.state == 9) {
                    return;
                }
                if (this.tranState.state == 7) {
                    return;
                }
                if (!(force || this.tranState.state != 3 && this.tranState.setState(8))) {
                    return;
                }
                if (this.temporary || !this.tranState.setState(8)) {
                    // empty if block
                }
                if (this.nestingInfo != null) {
                    this.nestingInfo.rollbackFamily();
                }
            }
            heuristicExc = null;
            if (this.participants != null) {
                try {
                    this.participants.distributeRollback(false);
                }
                catch (Throwable exc) {
                    if (exc instanceof HeuristicMixed || exc instanceof HeuristicHazard) {
                        heuristicExc = exc;
                    }
                    if (!(exc instanceof INTERNAL)) break block22;
                    throw (INTERNAL)exc;
                }
            }
        }
        TopCoordinator topCoordinator = this;
        synchronized (topCoordinator) {
            if (this.temporary || !this.tranState.setState(9)) {
                // empty if block
            }
            if (this.terminator != null) {
                this.terminator.setCompleted(true, heuristicExc != null);
            }
            if (!this.root) {
                this.afterCompletion(Status.StatusRolledBack);
            }
            if (heuristicExc != null) {
                if (heuristicExc instanceof HeuristicMixed) {
                    throw (HeuristicMixed)((java.lang.Object)heuristicExc);
                }
                throw (HeuristicHazard)((java.lang.Object)heuristicExc);
            }
        }
    }

    public synchronized void register_synchronization(Synchronization sync) throws SystemException, Inactive, SynchronizationUnavailable {
        if (this.tranState == null || this.tranState.state != 1) {
            Inactive exc = new Inactive();
            throw exc;
        }
        if (!this.registeredSync) {
            CoordinatorSynchronizationImpl sImpl = new CoordinatorSynchronizationImpl(this);
            try {
                Synchronization subSync = sImpl.object();
                this.superInfo.superior.register_synchronization(subSync);
                this.registeredSync = true;
                this.coordSyncImpl = sImpl;
                if (_logger.isLoggable(Level.FINER)) {
                    _logger.logp(Level.FINER, "TopCoordinator", "register_synchronization()", "CoordinatorSynchronizationImpl :" + sImpl + " has been registered with (Root)TopCoordinator" + "GTID is: " + this.superInfo.globalTID.toString());
                }
            }
            catch (Exception exc) {
                sImpl.destroy();
                if (exc instanceof OBJECT_NOT_EXIST) {
                    TRANSACTION_ROLLEDBACK ex2 = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
                    throw ex2;
                }
                if (exc instanceof Inactive) {
                    throw (Inactive)((java.lang.Object)exc);
                }
                if (exc instanceof SystemException) {
                    throw (SystemException)((java.lang.Object)exc);
                }
                INTERNAL ex2 = new INTERNAL(263, CompletionStatus.COMPLETED_NO);
                throw ex2;
            }
        }
        if (this.synchronizations == null) {
            this.synchronizations = new RegisteredSyncs();
        }
        if (sync instanceof SynchronizationImpl) {
            this.synchronizations.addSync(sync);
            if (_logger.isLoggable(Level.FINER)) {
                _logger.logp(Level.FINER, "TopCoordinator", "register_synchronization()", "SynchronizationImpl :" + sync + " has been registeredwith TopCoordinator :" + "GTID is : " + this.superInfo.globalTID.toString().toString());
            }
        } else {
            this.synchronizations.addSync((Synchronization)sync._duplicate());
        }
        this.temporary = false;
    }

    synchronized void beforeCompletion() throws INVALID_TRANSACTION {
        if (this.root && this.nestingInfo != null && this.nestingInfo.numChildren() != 0) {
            INVALID_TRANSACTION exc = new INVALID_TRANSACTION(1, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        if (this.synchronizations != null && !this.synchronizations.distributeBefore()) {
            this.rollbackOnly = true;
        }
    }

    synchronized void afterCompletion(Status status2) {
        if (this.tranState.state == 1) {
            this.tranState.setState(2);
            this.tranState.setState(5);
        }
        if (this.synchronizations != null) {
            this.synchronizations.distributeAfter(status2);
        }
        boolean aborted = true;
        if (status2 == Status.StatusCommitted) {
            aborted = false;
        }
        if (!this.delegated) {
            RecoveryManager.removeCoordinator(this.superInfo.globalTID, this.superInfo.localTID, aborted);
        } else {
            DelegatedRecoveryManager.removeCoordinator(this.superInfo.globalTID, this.superInfo.localTID, aborted, this.logPath);
        }
        if (this.recoveryCoordinatorList != null) {
            for (int i = 0; i < this.recoveryCoordinatorList.size(); ++i) {
                RecoveryCoordinatorImpl rcImpl = (RecoveryCoordinatorImpl)this.recoveryCoordinatorList.elementAt(i);
                rcImpl.destroy();
            }
            this.recoveryCoordinatorList = null;
        }
        if (this.coordSyncImpl != null) {
            this.coordSyncImpl.destroy();
        }
        this.synchronizations = null;
        this.destroy();
    }

    synchronized void setTerminator(CompletionHandler term) {
        this.terminator = term;
    }

    Coordinator getParent() {
        Coordinator result = null;
        return result;
    }

    Coordinator getSuperior() {
        Coordinator result = this.superInfo.superior;
        return result;
    }

    CompletionHandler getTerminator() {
        CompletionHandler result = this.terminator;
        return result;
    }

    void directRegisterResource(Resource res) {
        if (this.participants == null) {
            this.participants = new RegisteredResources(null, this);
        }
        this.participants.addRes(res);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.logp(Level.FINE, "TopCoordinator", "directRegisterResource()", "Registered resource :" + res);
        }
    }

    public synchronized PropagationContext get_txcontext() throws Unavailable {
        if (this.tranState == null || this.tranState.state != 1 || this.rollbackOnly) {
            Unavailable exc = new Unavailable();
            throw exc;
        }
        long timeLeft = TimeoutManager.timeLeft(this.superInfo.localTID);
        int timeout = 0;
        if (timeLeft > 0L) {
            timeout = (int)timeLeft / 1000;
        } else if (timeLeft == 0L) {
            TimeoutManager.timeoutCoordinator(this.superInfo.localTID, 1);
            TRANSACTION_ROLLEDBACK exc = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        TransIdentity current = new TransIdentity(this.object(), null, this.superInfo.globalTID.realTID);
        if (emptyData == null) {
            emptyData = Configuration.getORB().create_any();
            emptyData.insert_boolean(false);
        }
        PropagationContext result = new PropagationContext(timeout, current, new TransIdentity[0], emptyData);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.logp(Level.FINEST, "TopCoordinator", "get_txcontext()", "Obtained PropagationContextGTID is: " + this.superInfo.globalTID.toString());
        }
        return result;
    }

    void cleanUpEmpty(CoordinatorImpl parent) {
        try {
            this.rollback(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean commitOnePhase() throws HeuristicMixed, HeuristicHazard {
        TopCoordinator topCoordinator = this;
        synchronized (topCoordinator) {
            if (this.root && this.nestingInfo != null && this.nestingInfo.numChildren() != 0) {
                INVALID_TRANSACTION exc = new INVALID_TRANSACTION(1, CompletionStatus.COMPLETED_NO);
                throw exc;
            }
            if (this.participants != null && this.participants.numRegistered() > 1) {
                return false;
            }
            if (!this.tranState.setState(10)) {
                return false;
            }
            if (this.rollbackOnly) {
                return false;
            }
            boolean timeoutType = false;
            if (this.root) {
                TimeoutManager.setTimeout(this.superInfo.localTID, 0, 60);
            } else {
                TimeoutManager.setTimeout(this.superInfo.localTID, 2, 60);
            }
        }
        if (this.participants != null && this.participants.numRegistered() == 1) {
            boolean rolled_back;
            java.lang.Object heuristicExc;
            block30: {
                heuristicExc = null;
                rolled_back = false;
                try {
                    this.participants.commitOnePhase();
                }
                catch (Throwable exc) {
                    if (exc instanceof HeuristicMixed) {
                        if (!this.tranState.setState(14)) {
                            _logger.log(Level.SEVERE, "jts.transaction_wrong_state", "COMMIT_ONE_PHASE (1)");
                            String msg = LogFormatter.getLocalizedMessage(_logger, "jts.transaction_wrong_state", new java.lang.Object[]{"COMMIT_ONE_PHASE (1)"});
                            throw new INTERNAL(msg);
                        }
                        throw (HeuristicMixed)((java.lang.Object)exc);
                    }
                    if (exc instanceof HeuristicHazard) {
                        if (!this.tranState.setState(13)) {
                            _logger.log(Level.SEVERE, "jts.transaction_wrong_state", "COMMIT_ONE_PHASE (2)");
                            String msg = LogFormatter.getLocalizedMessage(_logger, "jts.transaction_wrong_state", new java.lang.Object[]{"COMMIT_ONE_PHASE (2)"});
                            throw new INTERNAL(msg);
                        }
                        throw (HeuristicHazard)((java.lang.Object)exc);
                    }
                    if (exc instanceof TRANSACTION_ROLLEDBACK) {
                        rolled_back = true;
                    }
                    if (!(exc instanceof INTERNAL)) break block30;
                    throw (INTERNAL)exc;
                }
            }
            if (rolled_back) {
                if (!this.tranState.setState(12)) {
                    _logger.log(Level.SEVERE, "jts.transaction_wrong_state", "COMMIT_ONE_PHASE (4)");
                    String msg = LogFormatter.getLocalizedMessage(_logger, "jts.transaction_wrong_state", new java.lang.Object[]{"COMMIT_ONE_PHASE (4)"});
                    throw new INTERNAL(msg);
                }
            } else if (!this.tranState.setState(11)) {
                _logger.log(Level.SEVERE, "jts.transaction_wrong_state", "COMMIT_ONE_PHASE (6)");
                String msg = LogFormatter.getLocalizedMessage(_logger, "jts.transaction_wrong_state", new java.lang.Object[]{"COMMIT_ONE_PHASE (6)"});
                throw new INTERNAL(msg);
            }
            TopCoordinator topCoordinator2 = this;
            synchronized (topCoordinator2) {
                if (this.terminator != null) {
                    this.terminator.setCompleted(false, heuristicExc != null);
                }
                if (!this.root) {
                    this.afterCompletion(Status.StatusCommitted);
                }
                if (heuristicExc != null) {
                    if (heuristicExc instanceof HeuristicMixed) {
                        throw (HeuristicMixed)heuristicExc;
                    }
                    throw (HeuristicHazard)heuristicExc;
                }
                if (rolled_back) {
                    TRANSACTION_ROLLEDBACK exc = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_YES);
                    throw exc;
                }
            }
            return true;
        }
        if (!this.tranState.setState(11)) {
            _logger.log(Level.SEVERE, "jts.transaction_wrong_state", "COMMIT_ONE_PHASE (8)");
            String msg = LogFormatter.getLocalizedMessage(_logger, "jts.transaction_wrong_state", new java.lang.Object[]{"COMMIT_ONE_PHASE (8)"});
            throw new INTERNAL(msg);
        }
        return true;
    }

    public int hashCode() {
        if (this.hash == 0 && this.superInfo != null && this.superInfo.globalTID != null) {
            this.hash = this.superInfo.globalTID.hashCode();
        }
        return this.hash;
    }

    public boolean equals(java.lang.Object other) {
        if (this == other) {
            return true;
        }
        otid_t otherTID = null;
        if (other instanceof CoordinatorImpl) {
            if (other instanceof TopCoordinator) {
                otherTID = ((TopCoordinator)other).superInfo.globalTID.realTID;
            }
        } else if (other instanceof Object) {
            try {
                JCoordinator jcoord = JCoordinatorHelper.narrow((Object)other);
                otherTID = jcoord.getGlobalTID();
            }
            catch (BAD_PARAM exc) {
                try {
                    Coordinator coord = CoordinatorHelper.narrow((Object)other);
                    PropagationContext pc = coord.get_txcontext();
                    otherTID = pc.current.otid;
                }
                catch (BAD_PARAM ex2) {
                }
                catch (Unavailable ex2) {
                    INVALID_TRANSACTION ex3 = new INVALID_TRANSACTION(7, CompletionStatus.COMPLETED_NO);
                    throw ex3;
                }
            }
        }
        if (otherTID != null) {
            return this.superInfo.globalTID.equals(otherTID);
        }
        return false;
    }
}

