/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.trace;

import com.sun.jts.trace.TraceUtil;
import java.util.Enumeration;
import java.util.Properties;
import javax.transaction.xa.Xid;
import org.omg.CosTransactions.otid_t;

public class TraceRecordFormatter {
    public static String createTraceRecord(Object tid, Object origin, String message) {
        StringBuffer strBuf = new StringBuffer(TraceUtil.getTraceRecordTag());
        strBuf.append(TraceUtil.getCurrentTraceLevel()).append(TraceUtil.getFieldDelimiter());
        if (tid == null) {
            strBuf.append("<unknown-tid>");
        } else if (tid instanceof String) {
            strBuf.append(tid);
        } else if (tid instanceof otid_t) {
            strBuf.append(TraceRecordFormatter.convertToString(((otid_t)tid).tid));
        }
        strBuf.append(TraceUtil.getFieldDelimiter()).append(System.currentTimeMillis()).append(TraceUtil.getFieldDelimiter());
        if (origin == null) {
            strBuf.append("<unknown-origin>");
        } else {
            strBuf.append(origin);
        }
        strBuf.append(TraceUtil.getFieldDelimiter()).append(message).append("\n");
        return strBuf.toString();
    }

    public static String getTraceRecordScheme() {
        String traceRecordScheme = "<trace-record-tag><level><separator><omg-tid><separator><current-time-in-milliseconds><separator><originator><separator><message>";
        return traceRecordScheme;
    }

    public static String convertToString(byte[] byteArray) {
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < byteArray.length; ++i) {
            strBuf.append(byteArray[i]);
        }
        return strBuf.toString();
    }

    public static String convertXidArrayToString(Xid[] xidArray) {
        if (xidArray.length != 0) {
            StringBuffer strBuf = new StringBuffer("[ ");
            for (int i = 0; i < xidArray.length - 1; ++i) {
                strBuf.append(xidArray[i].getGlobalTransactionId()).append(", ");
            }
            strBuf.append(xidArray[xidArray.length - 1]).append(" ]");
            return strBuf.toString();
        }
        return " null ";
    }

    public static String convertPropsToString(Properties prop) {
        if (prop == null) {
            return "{null}";
        }
        StringBuffer strBuf = new StringBuffer("{ ");
        Enumeration<?> e = prop.propertyNames();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            strBuf.append("[ ").append(obj).append("->");
            String val = prop.getProperty((String)obj);
            if (val == null) {
                strBuf.append("null");
            } else {
                strBuf.append(val);
            }
            strBuf.append(" ] ");
        }
        strBuf.append("}");
        return strBuf.toString();
    }
}

