/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.monitor.callflow.RequestInfo;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.security.jmac.config.HttpServletHelper;
import com.sun.enterprise.webservice.monitoring.AuthenticationListener;
import com.sun.enterprise.webservice.monitoring.WebServiceEngineImpl;
import com.sun.logging.LogDomains;
import com.sun.web.security.HttpRequestWrapper;
import com.sun.web.security.HttpResponseWrapper;
import com.sun.web.security.WebPrincipal;
import com.sun.web.security.WebSecurityManager;
import com.sun.web.security.WebSecurityManagerFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.util.StringManager;
import sun.security.x509.X500Name;

public class RealmAdapter
extends RealmBase {
    private static final String UNCONSTRAINED = "unconstrained";
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    public static final String SECURITY_CONTEXT = "SecurityContext";
    public static final String BASIC = "BASIC";
    public static final String FORM = "FORM";
    private static final String SERVER_AUTH_CONTEXT = "__javax.security.auth.message.ServerAuthContext";
    private static final String MESSAGE_INFO = "__javax.security.auth.message.MessageInfo";
    private static final String SYSTEM_HTTPSERVLET_SECURITY_PROVIDER = "system_httpservlet_security_provider";
    private SecurityRoleMapper mapper = null;
    private WebBundleDescriptor webDesc = null;
    private HashMap runAsPrincipals = null;
    private String _realmName = null;
    protected static final String name = "J2EE-RI-RealmAdapter";
    private String CONTEXT_ID = null;
    private Container virtualServer;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.realm");
    protected static final StringManager smRA = StringManager.getManager("com.sun.web.security");
    protected volatile WebSecurityManager webSecurityManager = null;
    protected WebSecurityManagerFactory webSecurityManagerFactory = WebSecurityManagerFactory.getInstance();
    protected boolean isCurrentURIincluded = false;
    private ArrayList roles = null;
    protected final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private boolean contextEvaluated = false;
    private String loginPage = null;
    private String errorPage = null;
    private static SecurityConstraint[] emptyConstraints = new SecurityConstraint[0];
    private static String defaultSystemProviderID = RealmAdapter.getDefaultSystemProviderID();
    private String appID;
    private boolean isSystemApp;
    private String jmacProviderRegisID = null;
    private HttpServletHelper helper = null;
    private static String PROXY_AUTH_TYPE = "PLUGGABLE_PROVIDER";

    public RealmAdapter() {
    }

    public RealmAdapter(String realmName) {
        this._realmName = realmName;
    }

    public RealmAdapter(WebBundleDescriptor descriptor, boolean isSystemApp) {
        this(descriptor, isSystemApp, null);
    }

    public RealmAdapter(WebBundleDescriptor descriptor, boolean isSystemApp, String realmName) {
        this.isSystemApp = isSystemApp;
        this.webDesc = descriptor;
        Application app = descriptor.getApplication();
        this.mapper = app.getRoleMapper();
        LoginConfiguration loginConfig = descriptor.getLoginConfiguration();
        this._realmName = app.getRealm();
        if (this._realmName == null && loginConfig != null) {
            this._realmName = loginConfig.getRealmName();
        }
        if (realmName != null && (this._realmName == null || this._realmName.equals(""))) {
            this._realmName = realmName;
        }
        this.CONTEXT_ID = WebSecurityManager.getContextID(descriptor);
        this.runAsPrincipals = new HashMap();
        for (WebComponentDescriptor wcd : this.webDesc.getWebComponentDescriptorsSet()) {
            RunAsIdentityDescriptor runAsDescriptor = wcd.getRunAsIdentity();
            if (runAsDescriptor == null) continue;
            String principal = runAsDescriptor.getPrincipal();
            String servlet = wcd.getCanonicalName();
            if (principal == null || servlet == null) {
                _logger.warning("web.realmadapter.norunas");
                continue;
            }
            this.runAsPrincipals.put(servlet, principal);
            _logger.fine("Servlet " + servlet + " will run-as: " + principal);
        }
        this.appID = app.getRegistrationName();
    }

    public void destroy() {
        super.destroy();
        if (this.helper != null) {
            this.helper.disable();
        }
    }

    public void setVirtualServer(Container container) {
        this.virtualServer = container;
        this.helper = this.getConfigHelper();
    }

    public WebBundleDescriptor getWebDescriptor() {
        return this.webDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WebSecurityManager getWebSecurityManager(boolean logNull) {
        if (this.webSecurityManager == null) {
            RealmAdapter realmAdapter = this;
            synchronized (realmAdapter) {
                this.webSecurityManager = this.webSecurityManagerFactory.getWebSecurityManager(this.CONTEXT_ID);
            }
            if (this.webSecurityManager == null && logNull) {
                String msg = smRA.getString("realmAdapter.noWebSecMgr", this.CONTEXT_ID);
                _logger.warning(msg);
            }
        }
        return this.webSecurityManager;
    }

    public boolean hasRole(HttpRequest request, HttpResponse response, Principal principal, String role) {
        WebSecurityManager secMgr = this.getWebSecurityManager(true);
        if (secMgr == null) {
            return false;
        }
        HttpServletRequest hrequest = (HttpServletRequest)((Object)request);
        String servletName = this.getResourceName(hrequest.getRequestURI(), hrequest.getContextPath());
        boolean isGranted = secMgr.hasRoleRefPermission(servletName, role, principal);
        if (!isGranted) {
            servletName = this.getCanonicalName(hrequest);
            if (servletName.equalsIgnoreCase(UNCONSTRAINED)) {
                if (_logger.isLoggable(Level.INFO)) {
                    _logger.log(Level.INFO, "Unable to find a <servlet-name> element which map: " + hrequest.getRequestURI());
                }
                isGranted = secMgr.hasRoleRefPermission("", role, principal);
            } else {
                isGranted = secMgr.hasRoleRefPermission(servletName, role, principal);
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Checking if servlet " + servletName + " with principal " + principal + " has role " + role + " isGranted: " + isGranted);
        }
        return isGranted;
    }

    public void logout() {
        this.setSecurityContext(null);
    }

    public Principal authenticate(String username, byte[] authData) {
        return this.authenticate(username, new String(authData));
    }

    public Principal authenticate(String username, String password) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Tomcat callback for authenticate user/password");
            _logger.fine("usename = " + username);
        }
        if (this.authenticate(username, password, null)) {
            SecurityContext secCtx = SecurityContext.getCurrent();
            assert (secCtx != null);
            return new WebPrincipal(username, password, secCtx);
        }
        return null;
    }

    public Principal authenticate(X509Certificate[] certs) {
        if (this.authenticate(null, null, certs)) {
            SecurityContext secCtx = SecurityContext.getCurrent();
            assert (secCtx != null);
            return new WebPrincipal(certs, secCtx);
        }
        return null;
    }

    public boolean authenticate(WebPrincipal prin) {
        if (prin.isUsingCertificate()) {
            return this.authenticate(null, null, prin.getCertificates());
        }
        return this.authenticate(prin.getName(), prin.getPassword(), null);
    }

    protected boolean authenticate(String username, String password, X509Certificate[] certs) {
        boolean success;
        block8: {
            SecurityContext.setCurrent(null);
            String realm_name = null;
            success = false;
            try {
                if (certs != null) {
                    Subject subject = new Subject();
                    X509Certificate certificate = certs[0];
                    X500Name x500Name = (X500Name)certificate.getSubjectDN();
                    Switch.getSwitch().getCallFlowAgent().addRequestInfo(RequestInfo.REMOTE_USER, x500Name.getName());
                    subject.getPublicCredentials().add(x500Name);
                    LoginContextDriver.login(subject, X500Name.class);
                    realm_name = "certificate";
                } else {
                    Switch.getSwitch().getCallFlowAgent().addRequestInfo(RequestInfo.REMOTE_USER, username);
                    realm_name = this._realmName;
                    LoginContextDriver.login(username, password, realm_name);
                }
                success = true;
            }
            catch (Exception le) {
                success = false;
                if (!_logger.isLoggable(Level.WARNING)) break block8;
                _logger.warning("Web login failed: " + le.getMessage());
            }
        }
        if (success && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Web login succeeded for: " + username);
        }
        if (this.webDesc != null && this.webDesc.hasWebServices()) {
            WebPrincipal principal = new WebPrincipal(username, password, null);
            for (AuthenticationListener listener : WebServiceEngineImpl.getInstance().getAuthListeners()) {
                if (success) {
                    listener.authSucess(this.webDesc, null, principal);
                    continue;
                }
                listener.authFailure(this.webDesc, null, principal);
            }
        }
        return success;
    }

    public void preSetRunAsIdentity(ComponentInvocation inv) {
        String name = this.getServletName(inv);
        if (name == null) {
            return;
        }
        String runAs = (String)this.runAsPrincipals.get(name);
        if (runAs != null) {
            SecurityContext old = this.getSecurityContext();
            inv.setOldSecurityContext(old);
            this.loginForRunAs(runAs);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("run-as principal for " + name + " set to: " + runAs);
            }
        }
    }

    private String getServletName(ComponentInvocation inv) {
        HttpServlet thisServlet;
        ServletConfig svc;
        Object invInstance = inv.getInstance();
        if (invInstance instanceof HttpServlet && (svc = (thisServlet = (HttpServlet)invInstance).getServletConfig()) != null) {
            return thisServlet.getServletName();
        }
        return null;
    }

    public void postSetRunAsIdentity(ComponentInvocation inv) {
        String name = this.getServletName(inv);
        if (name == null) {
            return;
        }
        String runAs = (String)this.runAsPrincipals.get(name);
        if (runAs != null) {
            this.setSecurityContext(inv.getOldSecurityContext());
        }
    }

    private void loginForRunAs(String principal) {
        LoginContextDriver.loginPrincipal(principal, this._realmName);
    }

    private SecurityContext getSecurityContext() {
        return SecurityContext.getCurrent();
    }

    private void setSecurityContext(SecurityContext sc) {
        SecurityContext.setCurrent(sc);
    }

    protected String getPassword(String username) {
        throw new IllegalStateException("Should not reach here");
    }

    protected Principal getPrincipal(String username) {
        throw new IllegalStateException("Should not reach here");
    }

    public Principal createFailOveredPrincipal(String username) {
        _logger.log(Level.FINEST, "IN createFailOveredPrincipal (" + username + ")");
        this.loginForRunAs(username);
        SecurityContext secCtx = SecurityContext.getCurrent();
        _logger.log(Level.FINE, "Security context is " + secCtx);
        assert (secCtx != null);
        WebPrincipal principal = new WebPrincipal(username, null, secCtx);
        _logger.log(Level.INFO, "Principal created for FailOvered user " + principal);
        return principal;
    }

    public boolean hasResourcePermission(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints, Context context) throws IOException {
        boolean isGranted = false;
        try {
            isGranted = this.invokeWebSecurityManager(request, response, constraints);
        }
        catch (IOException iex) {
            throw iex;
        }
        catch (Throwable ex) {
            ((HttpServletResponse)response.getResponse()).sendError(503);
            response.setDetailMessage(sm.getString("realmBase.forbidden"));
            return isGranted;
        }
        if (isGranted) {
            return isGranted;
        }
        ((HttpServletResponse)response.getResponse()).sendError(403);
        response.setDetailMessage(sm.getString("realmBase.forbidden"));
        this.invokePostAuthenticateDelegate(request, response, context);
        return isGranted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invokeWebSecurityManager(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints) throws IOException {
        WebSecurityManager secMgr;
        HttpServletRequest hrequest;
        boolean evaluated = false;
        try {
            this.rwLock.readLock().lock();
            evaluated = this.contextEvaluated;
            Object var6_5 = null;
            this.rwLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.rwLock.readLock().unlock();
            throw throwable;
        }
        if (!evaluated) {
            try {
                this.rwLock.writeLock().lock();
                if (!this.contextEvaluated) {
                    Context context = (Context)this.getContainer();
                    LoginConfig config = context.getLoginConfig();
                    if (config != null && FORM.equals(config.getAuthMethod())) {
                        this.loginPage = config.getLoginPage();
                        this.errorPage = config.getErrorPage();
                    }
                    this.contextEvaluated = true;
                }
                Object var8_9 = null;
                this.rwLock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.rwLock.writeLock().unlock();
                throw throwable;
            }
        }
        if (this.loginPage != null || this.errorPage != null) {
            String requestURI = request.getRequestPathMB().toString();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("[Web-Security]  requestURI: " + requestURI + " loginPage: " + this.loginPage);
            }
            if (this.loginPage != null && this.loginPage.equals(requestURI)) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(" Allow access to login page " + this.loginPage);
                }
                return true;
            }
            if (this.errorPage != null && this.errorPage.equals(requestURI)) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(" Allow access to error page " + this.errorPage);
                }
                return true;
            }
            if (requestURI.endsWith("/j_security_check")) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(" Allow access to username/password submission");
                }
                return true;
            }
        }
        if ((hrequest = (HttpServletRequest)((Object)request)).getServletPath() == null) {
            request.setServletPath(this.getResourceName(hrequest.getRequestURI(), hrequest.getContextPath()));
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("[Web-Security] [ hasResourcePermission ] Principal: " + hrequest.getUserPrincipal() + " ContextPath: " + hrequest.getContextPath());
        }
        if ((secMgr = this.getWebSecurityManager(true)) == null) {
            return false;
        }
        return secMgr.hasResourcePermission(hrequest);
    }

    public boolean hasUserDataPermission(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints) throws IOException {
        HttpServletRequest hrequest = (HttpServletRequest)((Object)request);
        if (hrequest.getServletPath() == null) {
            request.setServletPath(this.getResourceName(hrequest.getRequestURI(), hrequest.getContextPath()));
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("[Web-Security][ hasUserDataPermission ] Principal: " + hrequest.getUserPrincipal() + " ContextPath: " + hrequest.getContextPath());
        }
        if (request.getRequest().isSecure()) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("[Web-Security] request.getRequest().isSecure(): " + request.getRequest().isSecure());
            }
            return true;
        }
        WebSecurityManager secMgr = this.getWebSecurityManager(true);
        if (secMgr == null) {
            return false;
        }
        int isGranted = 0;
        try {
            isGranted = secMgr.hasUserDataPermission(hrequest);
        }
        catch (IllegalArgumentException e) {
            String msg = smRA.getString("realmAdapter.badRequest", e.getMessage());
            _logger.warning(msg);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, msg, e);
            }
            ((HttpServletResponse)response.getResponse()).sendError(400, msg);
            return false;
        }
        if (isGranted == -1) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("[Web-Security] redirecting using SSL");
            }
            return this.redirect(request, response);
        }
        if (isGranted == 0) {
            ((HttpServletResponse)response.getResponse()).sendError(403, sm.getString("realmBase.forbidden"));
            return false;
        }
        return true;
    }

    private boolean redirect(HttpRequest request, HttpResponse response) throws IOException {
        String queryString;
        HttpServletRequest hrequest = (HttpServletRequest)request.getRequest();
        HttpServletResponse hresponse = (HttpServletResponse)response.getResponse();
        int redirectPort = request.getConnector().getRedirectPort();
        if (redirectPort <= 0) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.fine("[Web-Security]  SSL redirect is disabled");
            }
            hresponse.sendError(403, hrequest.getRequestURI());
            return false;
        }
        String protocol = "https";
        String host = hrequest.getServerName();
        StringBuffer file = new StringBuffer(hrequest.getRequestURI());
        String requestedSessionId = hrequest.getRequestedSessionId();
        if (requestedSessionId != null && hrequest.isRequestedSessionIdFromURL()) {
            file.append(";jsessionid=");
            file.append(requestedSessionId);
        }
        if ((queryString = hrequest.getQueryString()) != null) {
            file.append('?');
            file.append(queryString);
        }
        URL url = null;
        try {
            url = new URL(protocol, host, redirectPort, file.toString());
            hresponse.sendRedirect(url.toString());
            return false;
        }
        catch (MalformedURLException e) {
            hresponse.sendError(500, hrequest.getRequestURI());
            return false;
        }
    }

    private String getCanonicalName(HttpServletRequest currentRequest) {
        String servletUri = "";
        String currentUri = "";
        String aliasUri = "";
        String currentUriExtension = "";
        String aliasUriExtension = "";
        boolean isAliasExists = false;
        for (WebComponentDescriptor webComponentDescriptor : this.webDesc.getWebComponentDescriptorsSet()) {
            servletUri = webComponentDescriptor.getWebComponentImplementation();
            currentUri = this.getResourceName(currentRequest.getRequestURI(), currentRequest.getContextPath());
            currentUriExtension = this.getExtension(currentUri);
            Iterator i = webComponentDescriptor.getUrlPatternsSet().iterator();
            while (i.hasNext()) {
                aliasUri = i.next().toString();
                aliasUriExtension = this.getExtension(aliasUri);
                if (aliasUri.equalsIgnoreCase(currentUri)) {
                    isAliasExists = true;
                    break;
                }
                if (!aliasUriExtension.equalsIgnoreCase(currentUriExtension) || !aliasUri.equalsIgnoreCase("*" + aliasUriExtension)) continue;
                isAliasExists = true;
                break;
            }
            if (!currentUri.equalsIgnoreCase(servletUri) && !isAliasExists) continue;
            return webComponentDescriptor.getCanonicalName();
        }
        return UNCONSTRAINED;
    }

    private String getResourceName(String uri, String contextPath) {
        try {
            return uri.substring(contextPath.length());
        }
        catch (Exception ex) {
            return "";
        }
    }

    private String getExtension(String uri) {
        try {
            return uri.substring(uri.lastIndexOf("."));
        }
        catch (Exception ex) {
            return "";
        }
    }

    protected String getName() {
        return name;
    }

    public String getRealmName() {
        return this._realmName;
    }

    public void setRealmName(String realmName) {
    }

    public SecurityConstraint[] findSecurityConstraints(HttpRequest request, Context context) {
        WebSecurityManager secMgr = this.getWebSecurityManager(false);
        if (secMgr != null && secMgr.hasNoConstrainedResources()) {
            return null;
        }
        SecurityConstraint[] constraints = emptyConstraints;
        return constraints;
    }

    public int preAuthenticateCheck(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints, boolean disableProxyCaching, boolean securePagesWithPragma, boolean ssoEnabled) throws IOException {
        boolean isGranted = false;
        try {
            if (this.helper != null && this.helper.getServerAuthConfig() != null) {
                return 1;
            }
            isGranted = this.invokeWebSecurityManager(request, response, constraints);
        }
        catch (IOException iex) {
            throw iex;
        }
        catch (Throwable ex) {
            ((HttpServletResponse)response.getResponse()).sendError(503);
            response.setDetailMessage(sm.getString("realmBase.forbidden"));
            return -1;
        }
        if (isGranted) {
            Object sharedState = null;
            boolean delegateSessionMgmt = false;
            if (((HttpServletRequest)((Object)request)).getUserPrincipal() != null) {
                this.disableProxyCaching(request, response, disableProxyCaching, securePagesWithPragma);
                if (ssoEnabled) {
                    HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
                    WebSecurityManager webSecMgr = this.getWebSecurityManager(true);
                    if (!webSecMgr.permitAll(hreq)) {
                        hreq.getSession(true);
                    }
                }
            }
            return 0;
        }
        if (((HttpServletRequest)((Object)request)).getUserPrincipal() != null) {
            ((HttpServletResponse)response.getResponse()).sendError(403);
            response.setDetailMessage(sm.getString("realmBase.forbidden"));
            return -1;
        }
        this.disableProxyCaching(request, response, disableProxyCaching, securePagesWithPragma);
        return 1;
    }

    public boolean invokeAuthenticateDelegate(HttpRequest request, HttpResponse response, Context context, Authenticator authenticator) throws IOException {
        boolean result = false;
        LoginConfig config = context.getLoginConfig();
        ServerAuthConfig serverAuthConfig = null;
        try {
            if (this.helper != null) {
                serverAuthConfig = this.helper.getServerAuthConfig();
            }
        }
        catch (Exception ex) {
            IOException iex = new IOException();
            iex.initCause(ex);
            throw iex;
        }
        result = serverAuthConfig != null ? this.validate(request, response, config, authenticator) : ((AuthenticatorBase)authenticator).authenticate(request, response, config);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean invokePostAuthenticateDelegate(HttpRequest request, HttpResponse response, Context context) throws IOException {
        boolean result = false;
        ServerAuthContext sAC = null;
        try {
            block6: {
                try {
                    HttpServletRequest req;
                    MessageInfo messageInfo;
                    if (this.helper == null || (messageInfo = (MessageInfo)(req = (HttpServletRequest)request.getRequest()).getAttribute(MESSAGE_INFO)) == null || (sAC = (ServerAuthContext)messageInfo.getMap().get(SERVER_AUTH_CONTEXT)) == null) break block6;
                    AuthStatus authStatus = sAC.secureResponse(messageInfo, null);
                    result = AuthStatus.SUCCESS.equals(authStatus);
                }
                catch (AuthException ex) {
                    IOException iex = new IOException();
                    iex.initCause(ex);
                    throw iex;
                }
            }
            Object var10_11 = null;
            if (this.helper == null) return result;
            if (sAC == null) return result;
            if (request instanceof HttpRequestWrapper) {
                request.removeNote("__javax.security.auth.message.request");
            }
            if (!(response instanceof HttpResponseWrapper)) return result;
            request.removeNote("__javax.security.auth.message.response");
            return result;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (this.helper == null) throw throwable;
            if (sAC == null) throw throwable;
            if (request instanceof HttpRequestWrapper) {
                request.removeNote("__javax.security.auth.message.request");
            }
            if (!(response instanceof HttpResponseWrapper)) throw throwable;
            request.removeNote("__javax.security.auth.message.response");
            throw throwable;
        }
    }

    public boolean isSecurityExtensionEnabled() {
        if (this.helper == null) {
            return false;
        }
        try {
            return this.helper.getServerAuthConfig() != null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private HttpServletHelper getConfigHelper() {
        HashMap<String, WebBundleDescriptor> map = new HashMap<String, WebBundleDescriptor>();
        map.put("WEB_BUNDLE", this.webDesc);
        return new HttpServletHelper(this.getAppContextID(), map, null, this._realmName, this.isSystemApp, defaultSystemProviderID);
    }

    private String getAppContextID() {
        return this.virtualServer.getName() + " " + this.webDesc.getContextRoot();
    }

    private boolean validate(HttpRequest request, HttpResponse response, LoginConfig config, Authenticator authenticator) throws IOException {
        boolean isMandatory;
        boolean rvalue;
        HttpMessageInfo messageInfo;
        Subject subject;
        HttpServletResponse res;
        HttpServletRequest req;
        block17: {
            req = (HttpServletRequest)request.getRequest();
            res = (HttpServletResponse)response.getResponse();
            subject = new Subject();
            messageInfo = new HttpMessageInfo(req, res);
            rvalue = false;
            isMandatory = true;
            try {
                ServerAuthContext sAC;
                WebSecurityManager webSecMgr = this.getWebSecurityManager(true);
                boolean bl = isMandatory = !webSecMgr.permitAll(req);
                if (isMandatory) {
                    messageInfo.getMap().put("javax.security.auth.message.MessagePolicy.isMandatory", Boolean.TRUE.toString());
                }
                if ((sAC = this.helper.getServerAuthContext(messageInfo, null)) != null) {
                    AuthStatus authStatus = sAC.validateRequest((MessageInfo)messageInfo, subject, null);
                    rvalue = AuthStatus.SUCCESS.equals(authStatus);
                    if (rvalue) {
                        messageInfo.getMap().put(SERVER_AUTH_CONTEXT, sAC);
                        req.setAttribute(MESSAGE_INFO, messageInfo);
                    }
                    break block17;
                }
                throw new AuthException("null ServerAuthContext");
            }
            catch (AuthException ae) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "JAMC: http msg authentication fail", ae);
                }
                res.setStatus(500);
            }
        }
        if (rvalue) {
            Set<Principal> principalSet = subject.getPrincipals();
            if (principalSet != null && !principalSet.isEmpty()) {
                HttpServletResponse newResponse;
                SecurityContext ctx = new SecurityContext(subject);
                Principal p = ctx.getCallerPrincipal();
                WebPrincipal wp = new WebPrincipal(p, ctx);
                try {
                    String authType = (String)messageInfo.getMap().get("javax.servlet.http.authType");
                    boolean register = messageInfo.getMap().containsKey("com.sun.web.RealmAdapter.register");
                    if (authType == null && config != null && config.getAuthMethod() != null) {
                        authType = config.getAuthMethod();
                    }
                    if (register) {
                        AuthenticatorProxy proxy = new AuthenticatorProxy(authenticator, wp, authType);
                        proxy.authenticate(request, response, config);
                    } else {
                        request.setAuthType(authType == null ? PROXY_AUTH_TYPE : authType);
                        request.setUserPrincipal(wp);
                    }
                }
                catch (LifecycleException le) {
                    _logger.log(Level.SEVERE, "[Web-Security] unable to register session", le);
                }
                HttpServletRequest newRequest = (HttpServletRequest)messageInfo.getRequestMessage();
                if (newRequest != req) {
                    request.setNote("__javax.security.auth.message.request", new HttpRequestWrapper(request, newRequest));
                }
                if ((newResponse = (HttpServletResponse)messageInfo.getResponseMessage()) != res) {
                    request.setNote("__javax.security.auth.message.response", new HttpResponseWrapper(response, newResponse));
                }
            } else if (isMandatory) {
                rvalue = false;
            }
        }
        return rvalue;
    }

    private static String getDefaultSystemProviderID() {
        String p = System.getProperty(SYSTEM_HTTPSERVLET_SECURITY_PROVIDER);
        if (p != null && (p = p.trim()).length() == 0) {
            p = null;
        }
        return p;
    }

    class AuthenticatorProxy
    extends AuthenticatorBase {
        private AuthenticatorBase authBase;
        private Principal principal;
        private String authType;

        public boolean getCache() {
            return this.authBase.getCache();
        }

        public Container getContainer() {
            return this.authBase.getContainer();
        }

        AuthenticatorProxy(Authenticator authenticator, Principal p, String authType) throws LifecycleException {
            this.authBase = (AuthenticatorBase)authenticator;
            this.principal = p;
            this.authType = authType == null ? PROXY_AUTH_TYPE : authType;
            this.setCache(this.authBase.getCache());
            this.setContainer(this.authBase.getContainer());
            this.start();
        }

        public boolean authenticate(HttpRequest request, HttpResponse response, LoginConfig config) throws IOException {
            this.register(request, response, this.principal, this.authType, this.principal.getName(), null);
            return true;
        }
    }

    private class HttpMessageInfo
    implements MessageInfo {
        private Object request = null;
        private Object response = null;
        private Map map = new HashMap();

        HttpMessageInfo() {
        }

        HttpMessageInfo(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public Object getRequestMessage() {
            return this.request;
        }

        public Object getResponseMessage() {
            return this.response;
        }

        public void setRequestMessage(Object request) {
            this.request = request;
        }

        public void setResponseMessage(Object response) {
            this.response = response;
        }

        public Map getMap() {
            return this.map;
        }
    }
}

