/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.web.AuthorizationConstraint;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.SecurityRoleReference;
import com.sun.enterprise.deployment.web.UserDataConstraint;
import com.sun.enterprise.deployment.web.WebResourceCollection;
import com.sun.web.security.MapValue;
import com.sun.web.security.MethodValue;
import java.security.Permission;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;

public class WebPermissionUtil {
    private static Logger logger = Logger.getLogger("javax.enterprise.system.core.security");
    private static final int PT_DEFAULT = 0;
    private static final int PT_EXTENSION = 1;
    private static final int PT_PREFIX = 2;
    private static final int PT_EXACT = 3;
    private static ArrayList skippableList = new ArrayList();

    static int patternType(Object urlPattern) {
        String pattern = urlPattern.toString();
        if (pattern.startsWith("*.")) {
            return 1;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/*")) {
            return 2;
        }
        if (pattern.equals("/")) {
            return 0;
        }
        return 3;
    }

    static boolean implies(String pattern, String path) {
        if (pattern.equals(path)) {
            return true;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/*")) {
            int length = (pattern = pattern.substring(0, pattern.length() - 2)).length();
            if (length == 0) {
                return true;
            }
            return path.startsWith(pattern) && (path.length() == length || path.substring(length).startsWith("/"));
        }
        if (pattern.startsWith("*.")) {
            int slash = path.lastIndexOf(47);
            int period = path.lastIndexOf(46);
            return slash >= 0 && period > slash && path.endsWith(pattern.substring(1));
        }
        return pattern.equals("/");
    }

    public static HashMap parseConstraints(WebBundleDescriptor wbd) {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering("WebPermissionUtil", "parseConstraints");
        }
        HashMap<String, MapValue> qpMap = new HashMap<String, MapValue>();
        qpMap.put("/", new MapValue("/"));
        Enumeration esc = wbd.getSecurityConstraints();
        while (esc.hasMoreElements()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "JACC: constraint translation: begin parsing security constraint");
            }
            SecurityConstraint sc = (SecurityConstraint)esc.nextElement();
            AuthorizationConstraint ac = sc.getAuthorizationConstraint();
            UserDataConstraint udc = sc.getUserDataConstraint();
            Enumeration ewrc = sc.getWebResourceCollections();
            while (ewrc.hasMoreElements()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "JACC: constraint translation: begin parsing web resource collection");
                }
                WebResourceCollection wrc = (WebResourceCollection)ewrc.nextElement();
                Enumeration eurl = wrc.getUrlPatterns();
                while (eurl.hasMoreElements()) {
                    MapValue mValue;
                    String url = (String)eurl.nextElement();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "JACC: constraint translation: process url: " + url);
                    }
                    if ((mValue = (MapValue)qpMap.get(url)) == null) {
                        mValue = new MapValue(url);
                        for (String otherUrl : qpMap.keySet()) {
                            int otherUrlType = WebPermissionUtil.patternType(otherUrl);
                            switch (WebPermissionUtil.patternType(url)) {
                                case 2: {
                                    if ((otherUrlType == 2 || otherUrlType == 3) && WebPermissionUtil.implies(url, otherUrl)) {
                                        mValue.addQualifier(otherUrl);
                                        break;
                                    }
                                    if (otherUrlType == 2 && WebPermissionUtil.implies(otherUrl, url)) {
                                        ((MapValue)qpMap.get(otherUrl)).addQualifier(url);
                                        break;
                                    }
                                    if (otherUrlType != 1 && otherUrlType != 0) break;
                                    ((MapValue)qpMap.get(otherUrl)).addQualifier(url);
                                    break;
                                }
                                case 1: {
                                    if (otherUrlType == 2 || otherUrlType == 3 && WebPermissionUtil.implies(url, otherUrl)) {
                                        mValue.addQualifier(otherUrl);
                                        break;
                                    }
                                    if (otherUrlType != 0) break;
                                    ((MapValue)qpMap.get(otherUrl)).addQualifier(url);
                                    break;
                                }
                                case 0: {
                                    if (otherUrlType == 0) break;
                                    mValue.addQualifier(otherUrl);
                                    break;
                                }
                                case 3: {
                                    if ((otherUrlType == 2 || otherUrlType == 1) && WebPermissionUtil.implies(otherUrl, url)) {
                                        ((MapValue)qpMap.get(otherUrl)).addQualifier(url);
                                        break;
                                    }
                                    if (otherUrlType != 0) break;
                                    ((MapValue)qpMap.get(otherUrl)).addQualifier(url);
                                }
                            }
                        }
                        qpMap.put(url, mValue);
                    }
                    BitSet methods = MapValue.methodArrayToSet(wrc.getHttpMethodsAsArray());
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "JACC: constraint translation: methods of collection: " + MapValue.getActions(methods));
                    }
                    if (ac == null) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "JACC: constraint translation: collection is unchecked for authorization at methods: " + MapValue.getActions(methods));
                        }
                        mValue.setPredefinedOutcomeOnMethods(methods, true);
                    } else {
                        Enumeration eroles = ac.getSecurityRoles();
                        if (!eroles.hasMoreElements()) {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "JACC: constraint translation: collection is exclude at methods: " + MapValue.getActions(methods));
                            }
                            mValue.setPredefinedOutcomeOnMethods(methods, false);
                        } else {
                            while (eroles.hasMoreElements()) {
                                SecurityRoleDescriptor srd = (SecurityRoleDescriptor)eroles.nextElement();
                                mValue.setRoleOnMethods(srd.getName(), methods, wbd);
                                if (!logger.isLoggable(Level.FINE)) continue;
                                logger.log(Level.FINE, "JACC: constraint translation: collection is athorized to: " + srd.getName() + " at methods: " + MapValue.getActions(methods));
                            }
                        }
                    }
                    if (udc == null) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "JACC: constraint translation: collection requires no transport guarantee at methods: " + MapValue.getActions(methods));
                        }
                        mValue.setConnectOnMethods(null, methods);
                    } else {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "JACC: constraint translation: collection requires transport guarantee: " + udc.getTransportGuarantee() + " at methods: " + MapValue.getActions(methods));
                        }
                        mValue.setConnectOnMethods(udc.getTransportGuarantee(), methods);
                    }
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "JACC: constraint translation: end processing url: " + url);
                }
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "JACC: constraint translation: end parsing web resource collection");
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.log(Level.FINE, "JACC: constraint translation: end parsing security constraint");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting("WebPermissionUtil", "parseConstraints");
        }
        return qpMap;
    }

    public static void processConstraints(WebBundleDescriptor wbd, PolicyConfiguration pc) throws PolicyContextException {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering("WebPermissionUtil", "processConstraints");
            logger.log(Level.FINE, "JACC: constraint translation: CODEBASE = " + pc.getContextID());
        }
        HashMap qpMap = WebPermissionUtil.parseConstraints(wbd);
        HashMap<String, Permissions> roleMap = new HashMap<String, Permissions>();
        Permissions excluded = new Permissions();
        Permissions unchecked = new Permissions();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "JACC: constraint capture: begin processing qualified url patterns");
        }
        for (MapValue m : qpMap.values()) {
            BitSet methods;
            if (m.irrelevantByQualifier) continue;
            String name = m.urlPatternSpec.toString();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "JACC: constraint capture: urlPattern: " + name);
            }
            if (!(methods = m.getExcludedMethods()).isEmpty()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "JACC: constraint capture: adding excluded methods: " + MapValue.getActions(methods));
                }
                String[] actions = MapValue.getMethodArray(methods);
                excluded.add(new WebResourcePermission(name, actions));
                excluded.add(new WebUserDataPermission(name, actions, null));
            }
            HashMap rMap = m.getRoleMap();
            for (String role : rMap.keySet()) {
                methods = (BitSet)rMap.get(role);
                if (methods.isEmpty()) continue;
                Permissions p = (Permissions)roleMap.get(role);
                if (p == null) {
                    p = new Permissions();
                    roleMap.put(role, p);
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "JACC: constraint capture: adding methods that may be called by role: " + role + " methods: " + MapValue.getActions(methods));
                }
                String[] actions = MapValue.getMethodArray(methods);
                p.add(new WebResourcePermission(name, actions));
            }
            for (int i = 1; i < MethodValue.connectKeys.length; ++i) {
                methods = m.getConnectMap(1 << i);
                if (methods.isEmpty()) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "JACC: constraint capture: adding methods that accept connections with protection: " + MethodValue.connectKeys[i] + " methods: " + MapValue.getActions(methods));
                }
                String[] actions = MapValue.getMethodArray(methods);
                unchecked.add(new WebUserDataPermission(name, actions, (String)MethodValue.connectKeys[i]));
            }
            methods = m.getAuthConstrainedMethods();
            if (!methods.get(0)) {
                String actions = methods.isEmpty() ? null : "!" + MapValue.getActions(methods);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "JACC: constraint capture: adding unchecked (for authorization) methods: " + actions);
                }
                unchecked.add(new WebResourcePermission(name, actions));
            }
            if ((methods = m.getTransportConstrainedMethods()).get(0)) continue;
            String actions = methods.isEmpty() ? null : "!" + MapValue.getActions(methods);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "JACC: constraint capture: adding methods that accept unprotected connections: " + actions);
            }
            unchecked.add(new WebUserDataPermission(name, actions));
        }
        if (logger.isLoggable(Level.FINE)) {
            String ptype;
            Permission p;
            logger.log(Level.FINE, "JACC: constraint capture: end processing qualified url patterns");
            Enumeration<Permission> e = excluded.elements();
            while (e.hasMoreElements()) {
                p = e.nextElement();
                ptype = p instanceof WebResourcePermission ? "WRP  " : "WUDP ";
                logger.log(Level.FINE, "JACC: permission(excluded) type: " + ptype + " name: " + p.getName() + " actions: " + p.getActions());
            }
            e = unchecked.elements();
            while (e.hasMoreElements()) {
                p = e.nextElement();
                ptype = p instanceof WebResourcePermission ? "WRP  " : "WUDP ";
                logger.log(Level.FINE, "JACC: permission(unchecked) type: " + ptype + " name: " + p.getName() + " actions: " + p.getActions());
            }
        }
        pc.addToExcludedPolicy(excluded);
        pc.addToUncheckedPolicy(unchecked);
        for (String role : roleMap.keySet()) {
            Permissions pCollection = (Permissions)roleMap.get(role);
            pc.addToRole(role, pCollection);
            if (!logger.isLoggable(Level.FINE)) continue;
            Enumeration<Permission> e = pCollection.elements();
            while (e.hasMoreElements()) {
                Permission p = e.nextElement();
                String ptype = p instanceof WebResourcePermission ? "WRP  " : "WUDP ";
                logger.log(Level.FINE, "JACC: permission(" + role + ") type: " + ptype + " name: " + p.getName() + " actions: " + p.getActions());
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting("WebPermissionUtil", "processConstraints");
        }
    }

    public static void createWebRoleRefPermission(WebBundleDescriptor wbd, PolicyConfiguration pc) throws PolicyContextException {
        if (logger.isLoggable(Level.FINE)) {
            logger.entering("WebPermissionUtil", "createWebRoleRefPermission");
            logger.log(Level.FINE, "JACC: role-reference translation: Processing WebRoleRefPermission : CODEBASE = " + pc.getContextID());
        }
        ArrayList<Role> role = new ArrayList<Role>();
        Set roleset = wbd.getRoles();
        Enumeration e = wbd.getWebComponentDescriptors();
        while (e.hasMoreElements()) {
            WebComponentDescriptor comp = (WebComponentDescriptor)e.nextElement();
            String name = comp.getCanonicalName();
            Enumeration esrr = comp.getSecurityRoleReferences();
            while (esrr.hasMoreElements()) {
                SecurityRoleReference srr = (SecurityRoleReference)esrr.nextElement();
                if (srr == null) continue;
                String action = srr.getRolename();
                WebRoleRefPermission wrrp = new WebRoleRefPermission(name, action);
                role.add(new Role(action));
                pc.addToRole(srr.getSecurityRoleLink().getName(), wrrp);
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "JACC: role-reference translation: RoleRefPermission created with name(servlet-name)  = " + name + " and action(Role-name tag) = " + action + " added to role(role-link tag) = " + srr.getSecurityRoleLink().getName());
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "JACC: role-reference translation: Going through the list of roles not present in RoleRef elements and creating WebRoleRefPermissions ");
            }
            for (Role r : roleset) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "JACC: role-reference translation: Looking at Role =  " + r.getName());
                }
                if (role.contains(r)) continue;
                String action = r.getName();
                WebRoleRefPermission wrrp = new WebRoleRefPermission(name, action);
                pc.addToRole(action, wrrp);
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "JACC: role-reference translation: RoleRef  = " + action + " is added for servlet-resource = " + name);
                logger.log(Level.FINE, "JACC: role-reference translation: Permission added for above role-ref =" + wrrp.getName() + " " + wrrp.getActions());
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting("WebPermissionUtil", "createWebRoleRefPermission");
        }
        for (Role r : roleset) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "JACC: role-reference translation: Looking at Role =  " + r.getName());
            }
            String action = r.getName();
            WebRoleRefPermission wrrp = new WebRoleRefPermission("", action);
            pc.addToRole(action, wrrp);
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.log(Level.FINE, "JACC: role-reference translation: RoleRef  = " + action + " is added for jsp's that can't be mapped to servlets");
            logger.log(Level.FINE, "JACC: role-reference translation: Permission added for above role-ref =" + wrrp.getName() + " " + wrrp.getActions());
        }
    }

    static {
        skippableList.add("meta-inf");
        skippableList.add("web-inf");
        skippableList.add("tld");
        skippableList.add(".com.sun.deployment.backend.lock");
    }
}

