/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import org.apache.catalina.Response;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.util.StringManager;

public class ResponseFacade
implements ServletResponse {
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.connector");
    protected ServletResponse response = null;
    protected Response resp = null;

    public ResponseFacade(Response response) {
        this.resp = response;
        this.response = (ServletResponse)((Object)response);
    }

    public void clear() {
        this.response = null;
        this.resp = null;
    }

    public void finish() {
        this.resp.setSuspended(true);
    }

    public boolean isFinished() {
        return this.resp.isSuspended();
    }

    public String getCharacterEncoding() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        return this.response.getCharacterEncoding();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        ServletOutputStream sos = this.response.getOutputStream();
        if (this.isFinished()) {
            this.resp.setSuspended(true);
        }
        return sos;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        PrintWriter writer = this.response.getWriter();
        if (this.isFinished()) {
            this.resp.setSuspended(true);
        }
        return writer;
    }

    public void setContentLength(int len) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        if (this.isCommitted()) {
            return;
        }
        this.response.setContentLength(len);
    }

    public void setCharacterEncoding(String charset) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        if (this.isCommitted()) {
            return;
        }
        this.response.setCharacterEncoding(charset);
    }

    public void setContentType(String type) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        if (this.isCommitted()) {
            return;
        }
        this.response.setContentType(type);
    }

    public String getContentType() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        return this.response.getContentType();
    }

    public void setBufferSize(int size) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.setBufferSize(size);
    }

    public int getBufferSize() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        return this.response.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        if (this.isFinished()) {
            return;
        }
        this.resp.setAppCommitted(true);
        try {
            this.response.flushBuffer();
        }
        catch (IOException ioe) {
            throw new ClientAbortException(ioe);
        }
    }

    public void resetBuffer() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.resetBuffer();
    }

    public boolean isCommitted() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        return this.resp.isAppCommitted();
    }

    public void reset() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.reset();
    }

    public void setLocale(Locale loc) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        if (this.isCommitted()) {
            return;
        }
        this.response.setLocale(loc);
    }

    public Locale getLocale() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("object.invalidScope"));
        }
        return this.response.getLocale();
    }
}

