/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.log.SystemLogHandler;

final class StandardContextValve
extends ValveBase {
    private static final String info = "org.apache.catalina.core.StandardContextValve/1.0";
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private static Log log = LogFactory.getLog(StandardContextValve.class);

    StandardContextValve() {
    }

    public String getInfo() {
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int invoke(Request request, Response response) throws IOException, ServletException {
        MessageBytes requestPathMB;
        HttpRequest hreq = (HttpRequest)request;
        if (request.getCheckRestrictedResources() && ((requestPathMB = hreq.getRequestPathMB()).startsWithIgnoreCase("/META-INF/", 0) || requestPathMB.equalsIgnoreCase("/META-INF") || requestPathMB.startsWithIgnoreCase("/WEB-INF/", 0) || requestPathMB.equalsIgnoreCase("/WEB-INF"))) {
            String requestURI = hreq.getDecodedRequestURI();
            this.notFound(requestURI, (HttpServletResponse)response.getResponse());
            return 2;
        }
        while (((StandardContext)this.container).getPaused()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        Wrapper wrapper = request.getWrapper();
        if (wrapper == null) {
            String requestURI = hreq.getDecodedRequestURI();
            this.notFound(requestURI, (HttpServletResponse)response.getResponse());
            return 2;
        }
        if (((StandardContext)this.container).getSwallowOutput()) {
            try {
                SystemLogHandler.startCapture();
                int n = this.invokeInternal(wrapper, request, response);
                return n;
            }
            finally {
                String log = SystemLogHandler.stopCapture();
                if (log != null && log.length() > 0) {
                    this.container.getLogger().log(log);
                }
            }
        }
        return this.invokeInternal(wrapper, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int invokeInternal(Wrapper wrapper, Request request, Response response) throws IOException, ServletException {
        Valve basic;
        Object[] instances = ((Context)this.container).getApplicationEventListeners();
        ServletRequestEvent event = null;
        if (instances != null && instances.length > 0) {
            event = new ServletRequestEvent(((StandardContext)this.container).getServletContext(), request.getRequest());
            for (int i = 0; i < instances.length; ++i) {
                if (instances[i] == null || !(instances[i] instanceof ServletRequestListener)) continue;
                ServletRequestListener listener = (ServletRequestListener)instances[i];
                this.container.fireContainerEvent("beforeRequestInitialized", listener);
                try {
                    listener.requestInitialized(event);
                    continue;
                }
                catch (Throwable t) {
                    this.log(sm.getString("standardContextValve.requestListener.requestInit", instances[i].getClass().getName()), t);
                    ServletRequest sreq = request.getRequest();
                    sreq.setAttribute("javax.servlet.error.exception", t);
                    int n = 2;
                    return n;
                }
                finally {
                    this.container.fireContainerEvent("afterRequestInitialized", listener);
                }
            }
        }
        if ((basic = wrapper.getPipeline().getBasic()) != null) {
            basic.invoke(request, response);
            basic.postInvoke(request, response);
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInvoke(Request request, Response response) throws IOException, ServletException {
        Object[] instances = ((Context)this.container).getApplicationEventListeners();
        if (instances != null && instances.length > 0) {
            ServletRequestEvent event = new ServletRequestEvent(((StandardContext)this.container).getServletContext(), request.getRequest());
            for (int i = 0; i < instances.length; ++i) {
                if (instances[i] == null || !(instances[i] instanceof ServletRequestListener)) continue;
                ServletRequestListener listener = (ServletRequestListener)instances[i];
                this.container.fireContainerEvent("beforeRequestDestroyed", listener);
                try {
                    listener.requestDestroyed(event);
                    continue;
                }
                catch (Throwable t) {
                    this.log(sm.getString("standardContextValve.requestListener.requestDestroyed", instances[i].getClass().getName()), t);
                    ServletRequest sreq = request.getRequest();
                    sreq.setAttribute("javax.servlet.error.exception", t);
                    continue;
                }
                finally {
                    this.container.fireContainerEvent("afterRequestDestroyed", listener);
                }
            }
        }
    }

    private void notFound(String requestURI, HttpServletResponse response) {
        try {
            response.sendError(404);
        }
        catch (IllegalStateException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void log(String message) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardContextValve[" + this.container.getName() + "]: " + message);
        } else {
            String containerName = null;
            if (this.container != null) {
                containerName = this.container.getName();
            }
            System.out.println("StandardContextValve[" + containerName + "]: " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardContextValve[" + this.container.getName() + "]: " + message, throwable);
        } else {
            String containerName = null;
            if (this.container != null) {
                containerName = this.container.getName();
            }
            System.out.println("StandardContextValve[" + containerName + "]: " + message);
            System.out.println("" + throwable);
            throwable.printStackTrace(System.out);
        }
    }
}

