/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.collections.MultiMap;
import org.apache.tomcat.util.http.MimeHeaders;

public final class Parameters
extends MultiMap {
    private static Log log = LogFactory.getLog(Parameters.class);
    private LinkedHashMap paramHashStringArray = new LinkedHashMap();
    private boolean didQueryParameters = false;
    private boolean didMerge = false;
    MessageBytes queryMB;
    MimeHeaders headers;
    UDecoder urlDec;
    MessageBytes decodedQuery = MessageBytes.newInstance();
    public static final int INITIAL_SIZE = 4;
    private Parameters child = null;
    private Parameters parent = null;
    private Parameters currentChild = null;
    String encoding = null;
    String queryStringEncoding = null;
    ByteChunk tmpName = new ByteChunk();
    ByteChunk tmpValue = new ByteChunk();
    CharChunk tmpNameC = new CharChunk(1024);
    CharChunk tmpValueC = new CharChunk(1024);
    private static int debug = 0;

    public Parameters() {
        super(4);
    }

    public void setQuery(MessageBytes queryMB) {
        this.queryMB = queryMB;
    }

    public void setHeaders(MimeHeaders headers) {
        this.headers = headers;
    }

    public void setEncoding(String s) {
        this.encoding = s;
        if (debug > 0) {
            this.log("Set encoding to " + s);
        }
    }

    public void setQueryStringEncoding(String s) {
        this.queryStringEncoding = s;
        if (debug > 0) {
            this.log("Set query string encoding to " + s);
        }
    }

    public void recycle() {
        super.recycle();
        this.paramHashStringArray.clear();
        this.didQueryParameters = false;
        this.currentChild = null;
        this.didMerge = false;
        this.encoding = null;
        this.decodedQuery.recycle();
    }

    public Parameters getCurrentSet() {
        if (this.currentChild == null) {
            return this;
        }
        return this.currentChild;
    }

    public void push() {
        if (this.currentChild == null) {
            this.currentChild = new Parameters();
            this.currentChild.setURLDecoder(this.urlDec);
            this.currentChild.parent = this;
            return;
        }
        if (this.currentChild.child == null) {
            this.currentChild.child = new Parameters();
            this.currentChild.setURLDecoder(this.urlDec);
            this.currentChild.child.parent = this.currentChild;
        }
        this.currentChild = this.currentChild.child;
        this.currentChild.setEncoding(this.encoding);
    }

    public void pop() {
        if (this.currentChild == null) {
            throw new RuntimeException("Attempt to pop without a push");
        }
        this.currentChild.recycle();
        this.currentChild = this.currentChild.parent;
    }

    public void addParameterValues(String key, String[] newValues) {
        String[] values;
        if (key == null) {
            return;
        }
        if (this.paramHashStringArray.containsKey(key)) {
            int i;
            String[] oldValues = (String[])this.paramHashStringArray.get(key);
            values = new String[oldValues.length + newValues.length];
            for (i = 0; i < oldValues.length; ++i) {
                values[i] = oldValues[i];
            }
            for (i = 0; i < newValues.length; ++i) {
                values[i + oldValues.length] = newValues[i];
            }
        } else {
            values = newValues;
        }
        this.paramHashStringArray.put(key, values);
    }

    public String[] getParameterValues(String name) {
        this.handleQueryParameters();
        if (this.currentChild != null) {
            this.currentChild.merge();
            return (String[])this.currentChild.paramHashStringArray.get(name);
        }
        String[] values = (String[])this.paramHashStringArray.get(name);
        return values;
    }

    public Enumeration getParameterNames() {
        this.handleQueryParameters();
        if (this.currentChild != null) {
            this.currentChild.merge();
            return Collections.enumeration(this.currentChild.paramHashStringArray.keySet());
        }
        return Collections.enumeration(this.paramHashStringArray.keySet());
    }

    private void merge() {
        if (debug > 0) {
            this.log("Before merging " + this + " " + this.parent + " " + this.didMerge);
            this.log(this.paramsAsString());
        }
        this.handleQueryParameters();
        if (this.didMerge) {
            return;
        }
        if (this.parent == null) {
            return;
        }
        this.parent.merge();
        LinkedHashMap parentProps = this.parent.paramHashStringArray;
        Parameters.merge2(this.paramHashStringArray, parentProps);
        this.didMerge = true;
        if (debug > 0) {
            this.log("After " + this.paramsAsString());
        }
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values != null) {
            if (values.length == 0) {
                return "";
            }
            return values[0];
        }
        return null;
    }

    public String getUndecodedParameter(String name) {
        this.processParameters(name);
        if (this.currentChild != null) {
            this.currentChild.merge();
            return (String)this.currentChild.paramHashStringArray.get(name);
        }
        String[] values = (String[])this.paramHashStringArray.get(name);
        if (values != null) {
            if (values.length == 0) {
                return "";
            }
            return values[0];
        }
        return null;
    }

    public void handleQueryParameters() {
        if (this.didQueryParameters) {
            return;
        }
        this.didQueryParameters = true;
        if (this.queryMB == null || this.queryMB.isNull()) {
            return;
        }
        if (debug > 0) {
            this.log("Decoding query " + this.decodedQuery + " " + this.queryStringEncoding);
        }
        try {
            this.decodedQuery.duplicate(this.queryMB);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.processParameters(this.decodedQuery, this.queryStringEncoding);
    }

    private static void merge2(LinkedHashMap one, LinkedHashMap two) {
        for (String name : two.keySet()) {
            String[] combinedValue;
            String[] oneValue = (String[])one.get(name);
            String[] twoValue = (String[])two.get(name);
            if (twoValue == null) continue;
            if (oneValue == null) {
                combinedValue = new String[twoValue.length];
                System.arraycopy(twoValue, 0, combinedValue, 0, twoValue.length);
            } else {
                combinedValue = new String[oneValue.length + twoValue.length];
                System.arraycopy(oneValue, 0, combinedValue, 0, oneValue.length);
                System.arraycopy(twoValue, 0, combinedValue, oneValue.length, twoValue.length);
            }
            one.put(name, combinedValue);
        }
    }

    private void addParam(String key, String value) {
        String[] values;
        if (key == null) {
            return;
        }
        if (this.paramHashStringArray.containsKey(key)) {
            String[] oldValues = (String[])this.paramHashStringArray.get(key);
            values = new String[oldValues.length + 1];
            for (int i = 0; i < oldValues.length; ++i) {
                values[i] = oldValues[i];
            }
            values[oldValues.length] = value;
        } else {
            values = new String[]{value};
        }
        this.paramHashStringArray.put(key, values);
    }

    public void setURLDecoder(UDecoder u) {
        this.urlDec = u;
    }

    public void processParameters(byte[] bytes, int start, int len) {
        this.processParameters(bytes, start, len, this.encoding);
    }

    public void processParameters(byte[] bytes, int start, int len, String enc) {
        int end = start + len;
        int pos = start;
        if (debug > 0) {
            this.log("Bytes: " + new String(bytes, start, len));
        }
        do {
            boolean noEq = false;
            int valStart = -1;
            int valEnd = -1;
            int nameStart = pos;
            int nameEnd = ByteChunk.indexOf(bytes, nameStart, end, '=');
            int nameEnd2 = ByteChunk.indexOf(bytes, nameStart, end, '&');
            if (nameEnd2 != -1 && (nameEnd == -1 || nameEnd > nameEnd2)) {
                nameEnd = nameEnd2;
                noEq = true;
                valStart = nameEnd;
                valEnd = nameEnd;
                if (debug > 0) {
                    this.log("no equal " + nameStart + " " + nameEnd + " " + new String(bytes, nameStart, nameEnd - nameStart));
                }
            }
            if (nameEnd == -1) {
                nameEnd = end;
            }
            if (!noEq && (valEnd = ByteChunk.indexOf(bytes, valStart = nameEnd < end ? nameEnd + 1 : end, end, '&')) == -1) {
                valEnd = valStart < end ? end : valStart;
            }
            pos = valEnd + 1;
            if (nameEnd <= nameStart) continue;
            this.tmpName.setBytes(bytes, nameStart, nameEnd - nameStart);
            this.tmpValue.setBytes(bytes, valStart, valEnd - valStart);
            try {
                this.addParam(this.urlDecode(this.tmpName, enc), this.urlDecode(this.tmpValue, enc));
            }
            catch (IOException e) {
                // empty catch block
            }
            this.tmpName.recycle();
            this.tmpValue.recycle();
        } while (pos < end);
    }

    private String urlDecode(ByteChunk bc, String enc) throws IOException {
        if (this.urlDec == null) {
            this.urlDec = new UDecoder();
        }
        this.urlDec.convert(bc);
        String result = null;
        if (enc != null) {
            bc.setEncoding(enc);
            result = bc.toString();
        } else {
            CharChunk cc = this.tmpNameC;
            int length = bc.getLength();
            cc.allocate(length, -1);
            byte[] bbuf = bc.getBuffer();
            char[] cbuf = cc.getBuffer();
            int start = bc.getStart();
            for (int i = 0; i < length; ++i) {
                cbuf[i] = (char)(bbuf[i + start] & 0xFF);
            }
            cc.setChars(cbuf, 0, length);
            result = cc.toString();
            cc.recycle();
        }
        return result;
    }

    public void processParameters(char[] chars, int start, int len) {
        int end = start + len;
        int pos = start;
        if (debug > 0) {
            this.log("Chars: " + new String(chars, start, len));
        }
        do {
            boolean noEq = false;
            int nameStart = pos;
            int valStart = -1;
            int valEnd = -1;
            int nameEnd = CharChunk.indexOf(chars, nameStart, end, '=');
            int nameEnd2 = CharChunk.indexOf(chars, nameStart, end, '&');
            if (nameEnd2 != -1 && (nameEnd == -1 || nameEnd > nameEnd2)) {
                nameEnd = nameEnd2;
                noEq = true;
                valStart = nameEnd;
                valEnd = nameEnd;
                if (debug > 0) {
                    this.log("no equal " + nameStart + " " + nameEnd + " " + new String(chars, nameStart, nameEnd - nameStart));
                }
            }
            if (nameEnd == -1) {
                nameEnd = end;
            }
            if (!noEq && (valEnd = CharChunk.indexOf(chars, valStart = nameEnd < end ? nameEnd + 1 : end, end, '&')) == -1) {
                valEnd = valStart < end ? end : valStart;
            }
            pos = valEnd + 1;
            if (nameEnd <= nameStart) continue;
            try {
                this.tmpNameC.append(chars, nameStart, nameEnd - nameStart);
                this.tmpValueC.append(chars, valStart, valEnd - valStart);
                if (debug > 0) {
                    this.log(this.tmpNameC + "= " + this.tmpValueC);
                }
                if (this.urlDec == null) {
                    this.urlDec = new UDecoder();
                }
                this.urlDec.convert(this.tmpNameC);
                this.urlDec.convert(this.tmpValueC);
                if (debug > 0) {
                    this.log(this.tmpNameC + "= " + this.tmpValueC);
                }
                this.addParam(this.tmpNameC.toString(), this.tmpValueC.toString());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.tmpNameC.recycle();
            this.tmpValueC.recycle();
        } while (pos < end);
    }

    public void processParameters(MessageBytes data) {
        this.processParameters(data, this.encoding);
    }

    public void processParameters(MessageBytes data, String encoding) {
        if (data == null || data.isNull() || data.getLength() <= 0) {
            return;
        }
        if (data.getType() == 2) {
            ByteChunk bc = data.getByteChunk();
            this.processParameters(bc.getBytes(), bc.getOffset(), bc.getLength(), encoding);
        } else {
            if (data.getType() != 3) {
                data.toChars();
            }
            CharChunk cc = data.getCharChunk();
            this.processParameters(cc.getChars(), cc.getOffset(), cc.getLength());
        }
    }

    public String paramsAsString() {
        StringBuffer sb = new StringBuffer();
        for (String k : this.paramHashStringArray.keySet()) {
            sb.append(k).append("=");
            String[] v = (String[])this.paramHashStringArray.get(k);
            for (int i = 0; i < v.length; ++i) {
                sb.append(v[i]).append(",");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private void log(String s) {
        if (log.isDebugEnabled()) {
            log.debug("Parameters: " + s);
        }
    }

    public void processSingleParameters(String str) {
        int end = str.length();
        int pos = 0;
        if (debug > 0) {
            this.log("String: " + str);
        }
        do {
            boolean noEq = false;
            int valStart = -1;
            int valEnd = -1;
            int nameStart = pos;
            int nameEnd = str.indexOf(61, nameStart);
            int nameEnd2 = str.indexOf(38, nameStart);
            if (nameEnd2 == -1) {
                nameEnd2 = end;
            }
            if (nameEnd2 != -1 && (nameEnd == -1 || nameEnd > nameEnd2)) {
                nameEnd = nameEnd2;
                noEq = true;
                valStart = nameEnd;
                valEnd = nameEnd;
                if (debug > 0) {
                    this.log("no equal " + nameStart + " " + nameEnd + " " + str.substring(nameStart, nameEnd));
                }
            }
            if (nameEnd == -1) {
                nameEnd = end;
            }
            if (!noEq && (valEnd = str.indexOf(38, valStart = nameEnd + 1)) == -1) {
                valEnd = valStart < end ? end : valStart;
            }
            pos = valEnd + 1;
            if (nameEnd <= nameStart) continue;
            if (debug > 0) {
                this.log("XXX " + nameStart + " " + nameEnd + " " + valStart + " " + valEnd);
            }
            try {
                this.tmpNameC.append(str, nameStart, nameEnd - nameStart);
                this.tmpValueC.append(str, valStart, valEnd - valStart);
                if (debug > 0) {
                    this.log(this.tmpNameC + "= " + this.tmpValueC);
                }
                if (this.urlDec == null) {
                    this.urlDec = new UDecoder();
                }
                this.urlDec.convert(this.tmpNameC);
                this.urlDec.convert(this.tmpValueC);
                if (debug > 0) {
                    this.log(this.tmpNameC + "= " + this.tmpValueC);
                }
                if (str.compareTo(this.tmpNameC.toString()) == 0) {
                    this.addParam(this.tmpNameC.toString(), this.tmpValueC.toString());
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.tmpNameC.recycle();
            this.tmpValueC.recycle();
        } while (pos < end);
    }

    public void processParameters(String str) {
        int end = str.length();
        int pos = 0;
        if (debug > 0) {
            this.log("String: " + str);
        }
        do {
            boolean noEq = false;
            int valStart = -1;
            int valEnd = -1;
            int nameStart = pos;
            int nameEnd = str.indexOf(61, nameStart);
            int nameEnd2 = str.indexOf(38, nameStart);
            if (nameEnd2 == -1) {
                nameEnd2 = end;
            }
            if (nameEnd2 != -1 && (nameEnd == -1 || nameEnd > nameEnd2)) {
                nameEnd = nameEnd2;
                noEq = true;
                valStart = nameEnd;
                valEnd = nameEnd;
                if (debug > 0) {
                    this.log("no equal " + nameStart + " " + nameEnd + " " + str.substring(nameStart, nameEnd));
                }
            }
            if (nameEnd == -1) {
                nameEnd = end;
            }
            if (!noEq && (valEnd = str.indexOf(38, valStart = nameEnd + 1)) == -1) {
                valEnd = valStart < end ? end : valStart;
            }
            pos = valEnd + 1;
            if (nameEnd <= nameStart) continue;
            if (debug > 0) {
                this.log("XXX " + nameStart + " " + nameEnd + " " + valStart + " " + valEnd);
            }
            try {
                this.tmpNameC.append(str, nameStart, nameEnd - nameStart);
                this.tmpValueC.append(str, valStart, valEnd - valStart);
                if (debug > 0) {
                    this.log(this.tmpNameC + "= " + this.tmpValueC);
                }
                if (this.urlDec == null) {
                    this.urlDec = new UDecoder();
                }
                this.urlDec.convert(this.tmpNameC);
                this.urlDec.convert(this.tmpValueC);
                if (debug > 0) {
                    this.log(this.tmpNameC + "= " + this.tmpValueC);
                }
                this.addParam(this.tmpNameC.toString(), this.tmpValueC.toString());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.tmpNameC.recycle();
            this.tmpValueC.recycle();
        } while (pos < end);
    }
}

