/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import java.util.Vector;
import sun.rmi.rmic.iiop.ClassType;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.Type;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;

public class NCClassType
extends ClassType {
    public static NCClassType forNCClass(ClassDefinition classDef, ContextStack stack) {
        if (stack.anyErrors()) {
            return null;
        }
        boolean doPop = false;
        try {
            sun.tools.java.Type theType = classDef.getType();
            Type existing = NCClassType.getType(theType, stack);
            if (existing != null) {
                if (!(existing instanceof NCClassType)) {
                    return null;
                }
                return (NCClassType)existing;
            }
            NCClassType it = new NCClassType(stack, classDef);
            NCClassType.putType(theType, (Type)it, stack);
            stack.push(it);
            doPop = true;
            if (it.initialize(stack)) {
                stack.pop(true);
                return it;
            }
            NCClassType.removeType(theType, stack);
            stack.pop(false);
            return null;
        }
        catch (CompilerError e) {
            if (doPop) {
                stack.pop(false);
            }
            return null;
        }
    }

    public String getTypeDescription() {
        return this.addExceptionDescription("Non-conforming class");
    }

    private NCClassType(ContextStack stack, ClassDefinition classDef) {
        super(stack, classDef, 0x6020000);
    }

    private boolean initialize(ContextStack stack) {
        if (!this.initParents(stack)) {
            return false;
        }
        if (stack.getEnv().getParseNonConforming()) {
            Vector directInterfaces = new Vector();
            Vector directMethods = new Vector();
            Vector directMembers = new Vector();
            try {
                return this.addAllMethods(this.getClassDefinition(), directMethods, false, false, stack) == null || this.updateParentClassMethods(this.getClassDefinition(), directMethods, false, stack) == null || !this.addConformingConstants(directMembers, false, stack) || this.initialize(directInterfaces, directMethods, directMembers, stack, false);
            }
            catch (ClassNotFound e) {
                NCClassType.classNotFound(stack, e);
                return false;
            }
        }
        return this.initialize(null, null, null, stack, false);
    }
}

