/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.debug.util.DebugLog;
import org.apache.bsf.util.BSFDebugManagerImpl;
import org.apache.bsf.util.BreakPoint;

public class DocumentCell {
    BSFDebugManagerImpl m_mger;
    String m_docName;
    Vector m_fnOrScripts;
    Vector m_breakpoints;
    Vector m_engines;
    Hashtable m_functionMap;
    private boolean m_entryexit;

    public DocumentCell(BSFDebugManagerImpl bSFDebugManagerImpl, String string) {
        this.m_mger = bSFDebugManagerImpl;
        this.m_docName = string;
        this.m_breakpoints = new Vector();
        this.m_functionMap = new Hashtable();
        this.m_fnOrScripts = new Vector();
        this.m_engines = new Vector();
        this.m_entryexit = false;
    }

    public String getName() {
        return this.m_docName;
    }

    public void loadNotify(BSFEngine bSFEngine) {
        this.m_engines.addElement(bSFEngine);
        this.propagateBreakpoints(bSFEngine);
        this.propagateEntryExit(bSFEngine);
    }

    public void terminateEngineNotify(BSFEngine bSFEngine) {
        this.m_engines.removeElement(bSFEngine);
    }

    private void propagateBreakpoints(BSFEngine bSFEngine) {
        Enumeration enumeration = this.m_breakpoints.elements();
        while (enumeration.hasMoreElements()) {
            BreakPoint breakPoint = (BreakPoint)enumeration.nextElement();
            int n = breakPoint.getId();
            try {
                if (breakPoint.isLineDefined()) {
                    int n2 = breakPoint.getLineNo();
                    bSFEngine.placeBreakpointAtLine(n, this.m_docName, n2);
                    continue;
                }
                int n3 = breakPoint.getOffset();
                bSFEngine.placeBreakpointAtOffset(n, this.m_docName, n3);
            }
            catch (BSFException bSFException) {}
        }
    }

    private void propagateBreakpoint(BreakPoint breakPoint) {
        Enumeration enumeration = this.m_engines.elements();
        while (enumeration.hasMoreElements()) {
            BSFEngine bSFEngine = (BSFEngine)enumeration.nextElement();
            int n = breakPoint.getId();
            try {
                if (breakPoint.isLineDefined()) {
                    int n2 = breakPoint.getLineNo();
                    bSFEngine.placeBreakpointAtLine(n, this.m_docName, n2);
                    continue;
                }
                int n3 = breakPoint.getOffset();
                bSFEngine.placeBreakpointAtOffset(n, this.m_docName, n3);
            }
            catch (BSFException bSFException) {}
        }
    }

    private void propagateBreakPointRemove(BreakPoint breakPoint) {
        Enumeration enumeration = this.m_engines.elements();
        while (enumeration.hasMoreElements()) {
            BSFEngine bSFEngine = (BSFEngine)enumeration.nextElement();
            int n = breakPoint.getId();
            try {
                bSFEngine.removeBreakpoint(this.m_docName, n);
            }
            catch (BSFException bSFException) {}
        }
    }

    public void addBreakpointAtLine(int n, int n2) {
        BreakPoint breakPoint = new BreakPoint(this, n);
        breakPoint.setLineNo(n2);
        this.m_breakpoints.addElement(breakPoint);
        this.propagateBreakpoint(breakPoint);
    }

    public void addBreakpointAtOffset(int n, int n2) {
        BreakPoint breakPoint = new BreakPoint(this, n);
        breakPoint.setOffset(n2);
        this.m_breakpoints.addElement(breakPoint);
        this.propagateBreakpoint(breakPoint);
    }

    public void removeBreakpoint(int n) {
        Enumeration enumeration = this.m_breakpoints.elements();
        while (enumeration.hasMoreElements()) {
            BreakPoint breakPoint = (BreakPoint)enumeration.nextElement();
            if (n != breakPoint.getId()) continue;
            this.m_breakpoints.removeElement(breakPoint);
            this.propagateBreakPointRemove(breakPoint);
            break;
        }
    }

    public void setEntryExit(boolean bl) {
        this.m_entryexit = bl;
        Enumeration enumeration = this.m_engines.elements();
        while (enumeration.hasMoreElements()) {
            this.propagateEntryExit((BSFEngine)enumeration.nextElement());
        }
    }

    private void propagateEntryExit(BSFEngine bSFEngine) {
        try {
            bSFEngine.setEntryExit(this.m_docName, this.m_entryexit);
        }
        catch (BSFException bSFException) {
            // empty catch block
        }
    }

    public boolean getEntryExit() {
        return this.m_entryexit;
    }

    public void removeAllBreakpoints() {
        DebugLog.stdoutPrintln("Drop breakpoints for " + this.m_docName, 3);
        Enumeration enumeration = this.m_breakpoints.elements();
        while (enumeration.hasMoreElements()) {
            BreakPoint breakPoint = (BreakPoint)enumeration.nextElement();
            DebugLog.stdoutPrintln("\tBreakpoints " + breakPoint, 3);
            this.propagateBreakPointRemove(breakPoint);
        }
        this.m_breakpoints = new Vector();
    }

    public BreakPoint findBreakpointAtLine(int n) {
        Enumeration enumeration = this.m_breakpoints.elements();
        while (enumeration.hasMoreElements()) {
            BreakPoint breakPoint = (BreakPoint)enumeration.nextElement();
            if (n != breakPoint.getLineNo()) continue;
            return breakPoint;
        }
        return null;
    }

    public BreakPoint findBreakpointAtOffset(int n) {
        Enumeration enumeration = this.m_breakpoints.elements();
        while (enumeration.hasMoreElements()) {
            BreakPoint breakPoint = (BreakPoint)enumeration.nextElement();
            if (n != breakPoint.getOffset()) continue;
            return breakPoint;
        }
        return null;
    }
}

